<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPolicyRelationship StructType
 * @subpackage Structs
 */
class XPolicyRelationship extends AbstractStructBase
{
    /**
     * The geoLocationPolicyAName
     * Meta informations extracted from the WSDL
     * - documentation: This is a read only tag. The value will be the currently added GeoLocationPolicy pkid.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $geoLocationPolicyAName;
    /**
     * The geoLocationDeviceA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $geoLocationDeviceA;
    /**
     * The geoLocationPolicyBName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $geoLocationPolicyBName;
    /**
     * The geoLocationDeviceB
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $geoLocationDeviceB;
    /**
     * The logicalPartitionPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $logicalPartitionPolicy;
    /**
     * Constructor method for XPolicyRelationship
     * @uses XPolicyRelationship::setGeoLocationPolicyAName()
     * @uses XPolicyRelationship::setGeoLocationDeviceA()
     * @uses XPolicyRelationship::setGeoLocationPolicyBName()
     * @uses XPolicyRelationship::setGeoLocationDeviceB()
     * @uses XPolicyRelationship::setLogicalPartitionPolicy()
     * @param \CUCM\StructType\XFkType $geoLocationPolicyAName
     * @param string $geoLocationDeviceA
     * @param \CUCM\StructType\XFkType $geoLocationPolicyBName
     * @param string $geoLocationDeviceB
     * @param string $logicalPartitionPolicy
     */
    public function __construct(\CUCM\StructType\XFkType $geoLocationPolicyAName = null, $geoLocationDeviceA = null, \CUCM\StructType\XFkType $geoLocationPolicyBName = null, $geoLocationDeviceB = null, $logicalPartitionPolicy = null)
    {
        $this
            ->setGeoLocationPolicyAName($geoLocationPolicyAName)
            ->setGeoLocationDeviceA($geoLocationDeviceA)
            ->setGeoLocationPolicyBName($geoLocationPolicyBName)
            ->setGeoLocationDeviceB($geoLocationDeviceB)
            ->setLogicalPartitionPolicy($logicalPartitionPolicy);
    }
    /**
     * Get geoLocationPolicyAName value
     * @return \CUCM\StructType\XFkType
     */
    public function getGeoLocationPolicyAName()
    {
        return $this->geoLocationPolicyAName;
    }
    /**
     * Set geoLocationPolicyAName value
     * @param \CUCM\StructType\XFkType $geoLocationPolicyAName
     * @return \CUCM\StructType\XPolicyRelationship
     */
    public function setGeoLocationPolicyAName(\CUCM\StructType\XFkType $geoLocationPolicyAName = null)
    {
        $this->geoLocationPolicyAName = $geoLocationPolicyAName;
        return $this;
    }
    /**
     * Get geoLocationDeviceA value
     * @return string
     */
    public function getGeoLocationDeviceA()
    {
        return $this->geoLocationDeviceA;
    }
    /**
     * Set geoLocationDeviceA value
     * @uses \CUCM\EnumType\XGeoLocationDevice::valueIsValid()
     * @uses \CUCM\EnumType\XGeoLocationDevice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoLocationDeviceA
     * @return \CUCM\StructType\XPolicyRelationship
     */
    public function setGeoLocationDeviceA($geoLocationDeviceA = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XGeoLocationDevice::valueIsValid($geoLocationDeviceA)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geoLocationDeviceA, implode(', ', \CUCM\EnumType\XGeoLocationDevice::getValidValues())), __LINE__);
        }
        $this->geoLocationDeviceA = $geoLocationDeviceA;
        return $this;
    }
    /**
     * Get geoLocationPolicyBName value
     * @return \CUCM\StructType\XFkType
     */
    public function getGeoLocationPolicyBName()
    {
        return $this->geoLocationPolicyBName;
    }
    /**
     * Set geoLocationPolicyBName value
     * @param \CUCM\StructType\XFkType $geoLocationPolicyBName
     * @return \CUCM\StructType\XPolicyRelationship
     */
    public function setGeoLocationPolicyBName(\CUCM\StructType\XFkType $geoLocationPolicyBName = null)
    {
        $this->geoLocationPolicyBName = $geoLocationPolicyBName;
        return $this;
    }
    /**
     * Get geoLocationDeviceB value
     * @return string
     */
    public function getGeoLocationDeviceB()
    {
        return $this->geoLocationDeviceB;
    }
    /**
     * Set geoLocationDeviceB value
     * @uses \CUCM\EnumType\XGeoLocationDevice::valueIsValid()
     * @uses \CUCM\EnumType\XGeoLocationDevice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoLocationDeviceB
     * @return \CUCM\StructType\XPolicyRelationship
     */
    public function setGeoLocationDeviceB($geoLocationDeviceB = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XGeoLocationDevice::valueIsValid($geoLocationDeviceB)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geoLocationDeviceB, implode(', ', \CUCM\EnumType\XGeoLocationDevice::getValidValues())), __LINE__);
        }
        $this->geoLocationDeviceB = $geoLocationDeviceB;
        return $this;
    }
    /**
     * Get logicalPartitionPolicy value
     * @return string
     */
    public function getLogicalPartitionPolicy()
    {
        return $this->logicalPartitionPolicy;
    }
    /**
     * Set logicalPartitionPolicy value
     * @uses \CUCM\EnumType\XLogicalPartitionPolicy::valueIsValid()
     * @uses \CUCM\EnumType\XLogicalPartitionPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $logicalPartitionPolicy
     * @return \CUCM\StructType\XPolicyRelationship
     */
    public function setLogicalPartitionPolicy($logicalPartitionPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XLogicalPartitionPolicy::valueIsValid($logicalPartitionPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $logicalPartitionPolicy, implode(', ', \CUCM\EnumType\XLogicalPartitionPolicy::getValidValues())), __LINE__);
        }
        $this->logicalPartitionPolicy = $logicalPartitionPolicy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XPolicyRelationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
