<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPhone StructType
 * @subpackage Structs
 */
class XPhone extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - default: User
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocolSide;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonPhoneConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $commonPhoneConfigName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $locationName;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The phoneTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $phoneTemplateName;
    /**
     * The primaryPhoneName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $primaryPhoneName;
    /**
     * The builtInBridgeStatus
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $builtInBridgeStatus;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The certificateOperation
     * Meta informations extracted from the WSDL
     * - default: No Pending Operation
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $certificateOperation;
    /**
     * The deviceMobilityMode
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: Specifies if the phone is configured for device mobility or not.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $deviceMobilityMode;
    /**
     * The mobileSmartClientProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $mobileSmartClientProfileName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkLocation;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The versionStamp
     * Meta informations extracted from the WSDL
     * - documentation: UUID changed each time device is updated
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $versionStamp;
    /**
     * The traceFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: This setting only effects devices that support MLPP. Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - default: Off
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $preemption;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta informations extracted from the WSDL
     * - documentation: This Tag is valid only for SIP Phones and SIP Trunks
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $sipProfileName;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The sendGeoLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The lines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Lines
     */
    public $lines;
    /**
     * The speeddials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Speeddials
     */
    public $speeddials;
    /**
     * The busyLampFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\BusyLampFields
     */
    public $busyLampFields;
    /**
     * The ringSettingIdleBlfAudibleAlert
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ringSettingIdleBlfAudibleAlert;
    /**
     * The ringSettingBusyBlfAudibleAlert
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ringSettingBusyBlfAudibleAlert;
    /**
     * The blfDirectedCallParks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AddOnModules
     */
    public $addOnModules;
    /**
     * The userlocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userlocale;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkLocale;
    /**
     * The idleTimeout
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $idleTimeout;
    /**
     * The authenticationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationUrl;
    /**
     * The directoryUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $directoryUrl;
    /**
     * The idleUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $idleUrl;
    /**
     * The informationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $informationUrl;
    /**
     * The messagesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $messagesUrl;
    /**
     * The proxyServerUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $proxyServerUrl;
    /**
     * The servicesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $servicesUrl;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Services
     */
    public $services;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $softkeyTemplateName;
    /**
     * The defaultProfileName
     * Meta informations extracted from the WSDL
     * - documentation: The name of the default profile for this device.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $defaultProfileName;
    /**
     * The enableExtensionMobility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtensionMobility;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The callInfoPrivacyStatus
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callInfoPrivacyStatus;
    /**
     * The hlogStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $hlogStatus;
    /**
     * The ownerUserName
     * Meta informations extracted from the WSDL
     * - documentation: Read-only for IP Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $ownerUserName;
    /**
     * The ignorePresentationIndicators
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: The new Ignore Presentation Indicators flag for Hospitality feature is required for most phones andand device profiles. Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The allowCtiControlFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowCtiControlFlag;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The unattendedPort
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Applicable only for H323Phones and H323Trunks.Not for Gateways.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The requireDtmfReception
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $requireDtmfReception;
    /**
     * The rfc2833Disabled
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $rfc2833Disabled;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - default: By Null String
     * - documentation: authenticationMode can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - default: 1024
     * - documentation: keySize can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keySize;
    /**
     * The authenticationString
     * Meta informations extracted from the WSDL
     * - documentation: authenticationString can be updated only if certificateOperation field is Install/Upgrade,Delete or Troubleshoot.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $authenticationString;
    /**
     * The upgradeFinishTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $upgradeFinishTime;
    /**
     * The remoteDevice
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $remoteDevice;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - default: Ringer Off
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dndRingSetting;
    /**
     * The dndStatus
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for devices that support DND.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The isActive
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: This tag determines if the newly added phone is active to determine consumption of license.If set to false the license units will not be consumed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActive;
    /**
     * The isDualMode
     * Meta informations extracted from the WSDL
     * - documentation: Read-only tag.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDualMode;
    /**
     * The mobilityUserIdName
     * Meta informations extracted from the WSDL
     * - documentation: The userid of the mobility user for this phone.Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $mobilityUserIdName;
    /**
     * The phoneSuite
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: If a blank tag is passed ,the value of the default is inserted into the database.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $phoneSuite;
    /**
     * The phoneServiceDisplay
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $phoneServiceDisplay;
    /**
     * The isProtected
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: This tag is valid only for devices that support Secure Tone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isProtected;
    /**
     * The mtpRequired
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The mtpPreferedCodec
     * Meta informations extracted from the WSDL
     * - default: 711ulaw
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mtpPreferedCodec;
    /**
     * The dialRulesName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $dialRulesName;
    /**
     * The sshUserId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable only to thosedevices that support ssh feature.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $sshUserId;
    /**
     * The sshPwd
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable only to thosedevices that support ssh feature.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $sshPwd;
    /**
     * The digestUser
     * Meta informations extracted from the WSDL
     * - documentation: This field is applicable only to SIP phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $digestUser;
    /**
     * The outboundCallRollover
     * Meta informations extracted from the WSDL
     * - default: No Rollover
     * - documentation: This tag is valid only for devices that Automatic Outbound Callrollover
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $outboundCallRollover;
    /**
     * The hotlineDevice
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: This tag is applicable for PLAR-supporting SIP/SCCP phones only
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $hotlineDevice;
    /**
     * The secureInformationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $secureInformationUrl;
    /**
     * The secureDirectoryUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $secureDirectoryUrl;
    /**
     * The secureMessageUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $secureMessageUrl;
    /**
     * The secureServicesUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $secureServicesUrl;
    /**
     * The secureAuthenticationUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $secureAuthenticationUrl;
    /**
     * The secureIdleUrl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $secureIdleUrl;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - documentation: This tag is valid only for RT Phones.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $featureControlPolicy;
    /**
     * The deviceTrustMode
     * Meta informations extracted from the WSDL
     * - default: Not Trusted
     * - documentation: This tag is valid only for TIP endpoints
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $deviceTrustMode;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XPhone
     * @uses XPhone::setName()
     * @uses XPhone::setProduct()
     * @uses XPhone::setClass()
     * @uses XPhone::setProtocol()
     * @uses XPhone::setProtocolSide()
     * @uses XPhone::setDevicePoolName()
     * @uses XPhone::setCommonPhoneConfigName()
     * @uses XPhone::setLocationName()
     * @uses XPhone::setUseTrustedRelayPoint()
     * @uses XPhone::setPhoneTemplateName()
     * @uses XPhone::setPrimaryPhoneName()
     * @uses XPhone::setBuiltInBridgeStatus()
     * @uses XPhone::setPacketCaptureMode()
     * @uses XPhone::setCertificateOperation()
     * @uses XPhone::setDeviceMobilityMode()
     * @uses XPhone::setMobileSmartClientProfileName()
     * @uses XPhone::setDescription()
     * @uses XPhone::setCallingSearchSpaceName()
     * @uses XPhone::setCommonDeviceConfigName()
     * @uses XPhone::setNetworkLocation()
     * @uses XPhone::setMediaResourceListName()
     * @uses XPhone::setNetworkHoldMohAudioSourceId()
     * @uses XPhone::setUserHoldMohAudioSourceId()
     * @uses XPhone::setAutomatedAlternateRoutingCssName()
     * @uses XPhone::setAarNeighborhoodName()
     * @uses XPhone::setLoadInformation()
     * @uses XPhone::setVendorConfig()
     * @uses XPhone::setVersionStamp()
     * @uses XPhone::setTraceFlag()
     * @uses XPhone::setMlppDomainId()
     * @uses XPhone::setMlppIndicationStatus()
     * @uses XPhone::setPreemption()
     * @uses XPhone::setRetryVideoCallAsAudio()
     * @uses XPhone::setSecurityProfileName()
     * @uses XPhone::setSipProfileName()
     * @uses XPhone::setCgpnTransformationCssName()
     * @uses XPhone::setUseDevicePoolCgpnTransformCss()
     * @uses XPhone::setGeoLocationName()
     * @uses XPhone::setGeoLocationFilterName()
     * @uses XPhone::setSendGeoLocation()
     * @uses XPhone::setLines()
     * @uses XPhone::setSpeeddials()
     * @uses XPhone::setBusyLampFields()
     * @uses XPhone::setRingSettingIdleBlfAudibleAlert()
     * @uses XPhone::setRingSettingBusyBlfAudibleAlert()
     * @uses XPhone::setBlfDirectedCallParks()
     * @uses XPhone::setAddOnModules()
     * @uses XPhone::setUserlocale()
     * @uses XPhone::setNetworkLocale()
     * @uses XPhone::setIdleTimeout()
     * @uses XPhone::setAuthenticationUrl()
     * @uses XPhone::setDirectoryUrl()
     * @uses XPhone::setIdleUrl()
     * @uses XPhone::setInformationUrl()
     * @uses XPhone::setMessagesUrl()
     * @uses XPhone::setProxyServerUrl()
     * @uses XPhone::setServicesUrl()
     * @uses XPhone::setServices()
     * @uses XPhone::setSoftkeyTemplateName()
     * @uses XPhone::setDefaultProfileName()
     * @uses XPhone::setEnableExtensionMobility()
     * @uses XPhone::setSingleButtonBarge()
     * @uses XPhone::setJoinAcrossLines()
     * @uses XPhone::setCallInfoPrivacyStatus()
     * @uses XPhone::setHlogStatus()
     * @uses XPhone::setOwnerUserName()
     * @uses XPhone::setIgnorePresentationIndicators()
     * @uses XPhone::setPacketCaptureDuration()
     * @uses XPhone::setSubscribeCallingSearchSpaceName()
     * @uses XPhone::setRerouteCallingSearchSpaceName()
     * @uses XPhone::setAllowCtiControlFlag()
     * @uses XPhone::setPresenceGroupName()
     * @uses XPhone::setUnattendedPort()
     * @uses XPhone::setRequireDtmfReception()
     * @uses XPhone::setRfc2833Disabled()
     * @uses XPhone::setAuthenticationMode()
     * @uses XPhone::setKeySize()
     * @uses XPhone::setAuthenticationString()
     * @uses XPhone::setUpgradeFinishTime()
     * @uses XPhone::setRemoteDevice()
     * @uses XPhone::setDndOption()
     * @uses XPhone::setDndRingSetting()
     * @uses XPhone::setDndStatus()
     * @uses XPhone::setIsActive()
     * @uses XPhone::setIsDualMode()
     * @uses XPhone::setMobilityUserIdName()
     * @uses XPhone::setPhoneSuite()
     * @uses XPhone::setPhoneServiceDisplay()
     * @uses XPhone::setIsProtected()
     * @uses XPhone::setMtpRequired()
     * @uses XPhone::setMtpPreferedCodec()
     * @uses XPhone::setDialRulesName()
     * @uses XPhone::setSshUserId()
     * @uses XPhone::setSshPwd()
     * @uses XPhone::setDigestUser()
     * @uses XPhone::setOutboundCallRollover()
     * @uses XPhone::setHotlineDevice()
     * @uses XPhone::setSecureInformationUrl()
     * @uses XPhone::setSecureDirectoryUrl()
     * @uses XPhone::setSecureMessageUrl()
     * @uses XPhone::setSecureServicesUrl()
     * @uses XPhone::setSecureAuthenticationUrl()
     * @uses XPhone::setSecureIdleUrl()
     * @uses XPhone::setAlwaysUsePrimeLine()
     * @uses XPhone::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses XPhone::setFeatureControlPolicy()
     * @uses XPhone::setDeviceTrustMode()
     * @uses XPhone::setCtiid()
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @param \CUCM\StructType\XFkType $commonPhoneConfigName
     * @param \CUCM\StructType\XFkType $locationName
     * @param string $useTrustedRelayPoint
     * @param \CUCM\StructType\XFkType $phoneTemplateName
     * @param \CUCM\StructType\XFkType $primaryPhoneName
     * @param string $builtInBridgeStatus
     * @param string $packetCaptureMode
     * @param string $certificateOperation
     * @param string $deviceMobilityMode
     * @param \CUCM\StructType\XFkType $mobileSmartClientProfileName
     * @param string $description
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @param \CUCM\StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \CUCM\StructType\XFkType $mediaResourceListName
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param \CUCM\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \CUCM\StructType\XFkType $aarNeighborhoodName
     * @param \CUCM\StructType\XLoadInformation $loadInformation
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @param string $versionStamp
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $retryVideoCallAsAudio
     * @param \CUCM\StructType\XFkType $securityProfileName
     * @param \CUCM\StructType\XFkType $sipProfileName
     * @param \CUCM\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \CUCM\StructType\XFkType $geoLocationName
     * @param \CUCM\StructType\XFkType $geoLocationFilterName
     * @param string $sendGeoLocation
     * @param \CUCM\StructType\Lines $lines
     * @param \CUCM\StructType\Speeddials $speeddials
     * @param \CUCM\StructType\BusyLampFields $busyLampFields
     * @param string $ringSettingIdleBlfAudibleAlert
     * @param string $ringSettingBusyBlfAudibleAlert
     * @param \CUCM\StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @param \CUCM\StructType\AddOnModules $addOnModules
     * @param string $userlocale
     * @param string $networkLocale
     * @param string $idleTimeout
     * @param string $authenticationUrl
     * @param string $directoryUrl
     * @param string $idleUrl
     * @param string $informationUrl
     * @param string $messagesUrl
     * @param string $proxyServerUrl
     * @param string $servicesUrl
     * @param \CUCM\StructType\Services $services
     * @param \CUCM\StructType\XFkType $softkeyTemplateName
     * @param \CUCM\StructType\XFkType $defaultProfileName
     * @param string $enableExtensionMobility
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param string $callInfoPrivacyStatus
     * @param string $hlogStatus
     * @param \CUCM\StructType\XFkType $ownerUserName
     * @param string $ignorePresentationIndicators
     * @param string $packetCaptureDuration
     * @param \CUCM\StructType\XFkType $subscribeCallingSearchSpaceName
     * @param \CUCM\StructType\XFkType $rerouteCallingSearchSpaceName
     * @param string $allowCtiControlFlag
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @param string $unattendedPort
     * @param string $requireDtmfReception
     * @param string $rfc2833Disabled
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $authenticationString
     * @param string $upgradeFinishTime
     * @param string $remoteDevice
     * @param string $dndOption
     * @param string $dndRingSetting
     * @param string $dndStatus
     * @param string $isActive
     * @param string $isDualMode
     * @param \CUCM\StructType\XFkType $mobilityUserIdName
     * @param string $phoneSuite
     * @param string $phoneServiceDisplay
     * @param string $isProtected
     * @param string $mtpRequired
     * @param string $mtpPreferedCodec
     * @param \CUCM\StructType\XFkType $dialRulesName
     * @param string $sshUserId
     * @param string $sshPwd
     * @param string $digestUser
     * @param string $outboundCallRollover
     * @param string $hotlineDevice
     * @param string $secureInformationUrl
     * @param string $secureDirectoryUrl
     * @param string $secureMessageUrl
     * @param string $secureServicesUrl
     * @param string $secureAuthenticationUrl
     * @param string $secureIdleUrl
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param \CUCM\StructType\XFkType $featureControlPolicy
     * @param string $deviceTrustMode
     * @param int $ctiid
     */
    public function __construct($name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', \CUCM\StructType\XFkType $devicePoolName = null, \CUCM\StructType\XFkType $commonPhoneConfigName = null, \CUCM\StructType\XFkType $locationName = null, $useTrustedRelayPoint = 'Default', \CUCM\StructType\XFkType $phoneTemplateName = null, \CUCM\StructType\XFkType $primaryPhoneName = null, $builtInBridgeStatus = 'Default', $packetCaptureMode = 'None', $certificateOperation = 'No Pending Operation', $deviceMobilityMode = 'Default', \CUCM\StructType\XFkType $mobileSmartClientProfileName = null, $description = null, \CUCM\StructType\XFkType $callingSearchSpaceName = null, \CUCM\StructType\XFkType $commonDeviceConfigName = null, $networkLocation = 'Use System Default', \CUCM\StructType\XFkType $mediaResourceListName = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, \CUCM\StructType\XFkType $automatedAlternateRoutingCssName = null, \CUCM\StructType\XFkType $aarNeighborhoodName = null, \CUCM\StructType\XLoadInformation $loadInformation = null, \CUCM\StructType\XVendorConfig $vendorConfig = null, $versionStamp = null, $traceFlag = null, $mlppDomainId = null, $mlppIndicationStatus = 'Off', $preemption = 'Default', $retryVideoCallAsAudio = true, \CUCM\StructType\XFkType $securityProfileName = null, \CUCM\StructType\XFkType $sipProfileName = null, \CUCM\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = true, \CUCM\StructType\XFkType $geoLocationName = null, \CUCM\StructType\XFkType $geoLocationFilterName = null, $sendGeoLocation = null, \CUCM\StructType\Lines $lines = null, \CUCM\StructType\Speeddials $speeddials = null, \CUCM\StructType\BusyLampFields $busyLampFields = null, $ringSettingIdleBlfAudibleAlert = 'Default', $ringSettingBusyBlfAudibleAlert = 'Default', \CUCM\StructType\BlfDirectedCallParks $blfDirectedCallParks = null, \CUCM\StructType\AddOnModules $addOnModules = null, $userlocale = null, $networkLocale = null, $idleTimeout = null, $authenticationUrl = null, $directoryUrl = null, $idleUrl = null, $informationUrl = null, $messagesUrl = null, $proxyServerUrl = null, $servicesUrl = null, \CUCM\StructType\Services $services = null, \CUCM\StructType\XFkType $softkeyTemplateName = null, \CUCM\StructType\XFkType $defaultProfileName = null, $enableExtensionMobility = null, $singleButtonBarge = 'Default', $joinAcrossLines = 'Default', $callInfoPrivacyStatus = 'Default', $hlogStatus = null, \CUCM\StructType\XFkType $ownerUserName = null, $ignorePresentationIndicators = false, $packetCaptureDuration = '0', \CUCM\StructType\XFkType $subscribeCallingSearchSpaceName = null, \CUCM\StructType\XFkType $rerouteCallingSearchSpaceName = null, $allowCtiControlFlag = null, \CUCM\StructType\XFkType $presenceGroupName = null, $unattendedPort = false, $requireDtmfReception = false, $rfc2833Disabled = false, $authenticationMode = 'By Null String', $keySize = '1024', $authenticationString = null, $upgradeFinishTime = null, $remoteDevice = false, $dndOption = 'Ringer Off', $dndRingSetting = null, $dndStatus = null, $isActive = true, $isDualMode = null, \CUCM\StructType\XFkType $mobilityUserIdName = null, $phoneSuite = 'Default', $phoneServiceDisplay = 'Default', $isProtected = false, $mtpRequired = null, $mtpPreferedCodec = '711ulaw', \CUCM\StructType\XFkType $dialRulesName = null, $sshUserId = null, $sshPwd = null, $digestUser = null, $outboundCallRollover = 'No Rollover', $hotlineDevice = false, $secureInformationUrl = null, $secureDirectoryUrl = null, $secureMessageUrl = null, $secureServicesUrl = null, $secureAuthenticationUrl = null, $secureIdleUrl = null, $alwaysUsePrimeLine = 'Default', $alwaysUsePrimeLineForVoiceMessage = 'Default', \CUCM\StructType\XFkType $featureControlPolicy = null, $deviceTrustMode = 'Not Trusted', $ctiid = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setDevicePoolName($devicePoolName)
            ->setCommonPhoneConfigName($commonPhoneConfigName)
            ->setLocationName($locationName)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setPrimaryPhoneName($primaryPhoneName)
            ->setBuiltInBridgeStatus($builtInBridgeStatus)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setCertificateOperation($certificateOperation)
            ->setDeviceMobilityMode($deviceMobilityMode)
            ->setMobileSmartClientProfileName($mobileSmartClientProfileName)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setVersionStamp($versionStamp)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setLines($lines)
            ->setSpeeddials($speeddials)
            ->setBusyLampFields($busyLampFields)
            ->setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert)
            ->setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserlocale($userlocale)
            ->setNetworkLocale($networkLocale)
            ->setIdleTimeout($idleTimeout)
            ->setAuthenticationUrl($authenticationUrl)
            ->setDirectoryUrl($directoryUrl)
            ->setIdleUrl($idleUrl)
            ->setInformationUrl($informationUrl)
            ->setMessagesUrl($messagesUrl)
            ->setProxyServerUrl($proxyServerUrl)
            ->setServicesUrl($servicesUrl)
            ->setServices($services)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setDefaultProfileName($defaultProfileName)
            ->setEnableExtensionMobility($enableExtensionMobility)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setHlogStatus($hlogStatus)
            ->setOwnerUserName($ownerUserName)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setAllowCtiControlFlag($allowCtiControlFlag)
            ->setPresenceGroupName($presenceGroupName)
            ->setUnattendedPort($unattendedPort)
            ->setRequireDtmfReception($requireDtmfReception)
            ->setRfc2833Disabled($rfc2833Disabled)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setAuthenticationString($authenticationString)
            ->setUpgradeFinishTime($upgradeFinishTime)
            ->setRemoteDevice($remoteDevice)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setDndStatus($dndStatus)
            ->setIsActive($isActive)
            ->setIsDualMode($isDualMode)
            ->setMobilityUserIdName($mobilityUserIdName)
            ->setPhoneSuite($phoneSuite)
            ->setPhoneServiceDisplay($phoneServiceDisplay)
            ->setIsProtected($isProtected)
            ->setMtpRequired($mtpRequired)
            ->setMtpPreferedCodec($mtpPreferedCodec)
            ->setDialRulesName($dialRulesName)
            ->setSshUserId($sshUserId)
            ->setSshPwd($sshPwd)
            ->setDigestUser($digestUser)
            ->setOutboundCallRollover($outboundCallRollover)
            ->setHotlineDevice($hotlineDevice)
            ->setSecureInformationUrl($secureInformationUrl)
            ->setSecureDirectoryUrl($secureDirectoryUrl)
            ->setSecureMessageUrl($secureMessageUrl)
            ->setSecureServicesUrl($secureServicesUrl)
            ->setSecureAuthenticationUrl($secureAuthenticationUrl)
            ->setSecureIdleUrl($secureIdleUrl)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setDeviceTrustMode($deviceTrustMode)
            ->setCtiid($ctiid);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\XPhone
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \CUCM\EnumType\XProduct::valueIsValid()
     * @uses \CUCM\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \CUCM\StructType\XPhone
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \CUCM\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \CUCM\EnumType\XClass::valueIsValid()
     * @uses \CUCM\EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \CUCM\StructType\XPhone
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \CUCM\EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \CUCM\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \CUCM\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \CUCM\StructType\XPhone
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', \CUCM\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \CUCM\EnumType\XProtocolSide::valueIsValid()
     * @uses \CUCM\EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \CUCM\StructType\XPhone
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', \CUCM\EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \CUCM\StructType\XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @return \CUCM\StructType\XPhone
     */
    public function setDevicePoolName(\CUCM\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonPhoneConfigName value
     * @return \CUCM\StructType\XFkType
     */
    public function getCommonPhoneConfigName()
    {
        return $this->commonPhoneConfigName;
    }
    /**
     * Set commonPhoneConfigName value
     * @param \CUCM\StructType\XFkType $commonPhoneConfigName
     * @return \CUCM\StructType\XPhone
     */
    public function setCommonPhoneConfigName(\CUCM\StructType\XFkType $commonPhoneConfigName = null)
    {
        $this->commonPhoneConfigName = $commonPhoneConfigName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \CUCM\StructType\XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \CUCM\StructType\XFkType $locationName
     * @return \CUCM\StructType\XPhone
     */
    public function setLocationName(\CUCM\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \CUCM\StructType\XPhone
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return \CUCM\StructType\XFkType
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param \CUCM\StructType\XFkType $phoneTemplateName
     * @return \CUCM\StructType\XPhone
     */
    public function setPhoneTemplateName(\CUCM\StructType\XFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get primaryPhoneName value
     * @return \CUCM\StructType\XFkType
     */
    public function getPrimaryPhoneName()
    {
        return $this->primaryPhoneName;
    }
    /**
     * Set primaryPhoneName value
     * @param \CUCM\StructType\XFkType $primaryPhoneName
     * @return \CUCM\StructType\XPhone
     */
    public function setPrimaryPhoneName(\CUCM\StructType\XFkType $primaryPhoneName = null)
    {
        $this->primaryPhoneName = $primaryPhoneName;
        return $this;
    }
    /**
     * Get builtInBridgeStatus value
     * @return string
     */
    public function getBuiltInBridgeStatus()
    {
        return $this->builtInBridgeStatus;
    }
    /**
     * Set builtInBridgeStatus value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $builtInBridgeStatus
     * @return \CUCM\StructType\XPhone
     */
    public function setBuiltInBridgeStatus($builtInBridgeStatus = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($builtInBridgeStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $builtInBridgeStatus, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->builtInBridgeStatus = $builtInBridgeStatus;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses \CUCM\EnumType\XPacketCaptureMode::valueIsValid()
     * @uses \CUCM\EnumType\XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return \CUCM\StructType\XPhone
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', \CUCM\EnumType\XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return string
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @uses \CUCM\EnumType\XCertificateOperation::valueIsValid()
     * @uses \CUCM\EnumType\XCertificateOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificateOperation
     * @return \CUCM\StructType\XPhone
     */
    public function setCertificateOperation($certificateOperation = 'No Pending Operation')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XCertificateOperation::valueIsValid($certificateOperation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $certificateOperation, implode(', ', \CUCM\EnumType\XCertificateOperation::getValidValues())), __LINE__);
        }
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get deviceMobilityMode value
     * @return string
     */
    public function getDeviceMobilityMode()
    {
        return $this->deviceMobilityMode;
    }
    /**
     * Set deviceMobilityMode value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceMobilityMode
     * @return \CUCM\StructType\XPhone
     */
    public function setDeviceMobilityMode($deviceMobilityMode = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($deviceMobilityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceMobilityMode, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->deviceMobilityMode = $deviceMobilityMode;
        return $this;
    }
    /**
     * Get mobileSmartClientProfileName value
     * @return \CUCM\StructType\XFkType
     */
    public function getMobileSmartClientProfileName()
    {
        return $this->mobileSmartClientProfileName;
    }
    /**
     * Set mobileSmartClientProfileName value
     * @param \CUCM\StructType\XFkType $mobileSmartClientProfileName
     * @return \CUCM\StructType\XPhone
     */
    public function setMobileSmartClientProfileName(\CUCM\StructType\XFkType $mobileSmartClientProfileName = null)
    {
        $this->mobileSmartClientProfileName = $mobileSmartClientProfileName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\XPhone
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @return \CUCM\StructType\XPhone
     */
    public function setCallingSearchSpaceName(\CUCM\StructType\XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $commonDeviceConfigName
     * @return \CUCM\StructType\XPhone
     */
    public function setCommonDeviceConfigName(\CUCM\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses \CUCM\EnumType\XNetworkLocation::valueIsValid()
     * @uses \CUCM\EnumType\XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return \CUCM\StructType\XPhone
     */
    public function setNetworkLocation($networkLocation = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocation, implode(', ', \CUCM\EnumType\XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $mediaResourceListName
     * @return \CUCM\StructType\XPhone
     */
    public function setMediaResourceListName(\CUCM\StructType\XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return isset($this->networkHoldMohAudioSourceId) ? $this->networkHoldMohAudioSourceId : null;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \CUCM\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceId
     * @return \CUCM\StructType\XPhone
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSourceId, implode(', ', \CUCM\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($networkHoldMohAudioSourceId) || (is_array($networkHoldMohAudioSourceId) && empty($networkHoldMohAudioSourceId))) {
            unset($this->networkHoldMohAudioSourceId);
        } else {
            $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return isset($this->userHoldMohAudioSourceId) ? $this->userHoldMohAudioSourceId : null;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \CUCM\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \CUCM\StructType\XPhone
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', \CUCM\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($userHoldMohAudioSourceId) || (is_array($userHoldMohAudioSourceId) && empty($userHoldMohAudioSourceId))) {
            unset($this->userHoldMohAudioSourceId);
        } else {
            $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \CUCM\StructType\XPhone
     */
    public function setAutomatedAlternateRoutingCssName(\CUCM\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $aarNeighborhoodName
     * @return \CUCM\StructType\XPhone
     */
    public function setAarNeighborhoodName(\CUCM\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get loadInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return isset($this->loadInformation) ? $this->loadInformation : null;
    }
    /**
     * Set loadInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XLoadInformation $loadInformation
     * @return \CUCM\StructType\XPhone
     */
    public function setLoadInformation(\CUCM\StructType\XLoadInformation $loadInformation = null)
    {
        if (is_null($loadInformation) || (is_array($loadInformation) && empty($loadInformation))) {
            unset($this->loadInformation);
        } else {
            $this->loadInformation = $loadInformation;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \CUCM\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @return \CUCM\StructType\XPhone
     */
    public function setVendorConfig(\CUCM\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get versionStamp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVersionStamp()
    {
        return isset($this->versionStamp) ? $this->versionStamp : null;
    }
    /**
     * Set versionStamp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $versionStamp
     * @return \CUCM\StructType\XPhone
     */
    public function setVersionStamp($versionStamp = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($versionStamp) && strlen($versionStamp) > 128) || (is_array($versionStamp) && count($versionStamp) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($versionStamp) ? strlen($versionStamp) : count($versionStamp)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($versionStamp) && !is_string($versionStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versionStamp)), __LINE__);
        }
        if (is_null($versionStamp) || (is_array($versionStamp) && empty($versionStamp))) {
            unset($this->versionStamp);
        } else {
            $this->versionStamp = $versionStamp;
        }
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \CUCM\StructType\XPhone
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($traceFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceFlag)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \CUCM\StructType\XPhone
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \CUCM\StructType\XPhone
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = 'Off')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \CUCM\EnumType\XPreemption::valueIsValid()
     * @uses \CUCM\EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \CUCM\StructType\XPhone
     */
    public function setPreemption($preemption = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', \CUCM\EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \CUCM\StructType\XPhone
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = true)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get securityProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return isset($this->securityProfileName) ? $this->securityProfileName : null;
    }
    /**
     * Set securityProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $securityProfileName
     * @return \CUCM\StructType\XPhone
     */
    public function setSecurityProfileName(\CUCM\StructType\XFkType $securityProfileName = null)
    {
        if (is_null($securityProfileName) || (is_array($securityProfileName) && empty($securityProfileName))) {
            unset($this->securityProfileName);
        } else {
            $this->securityProfileName = $securityProfileName;
        }
        return $this;
    }
    /**
     * Get sipProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getSipProfileName()
    {
        return isset($this->sipProfileName) ? $this->sipProfileName : null;
    }
    /**
     * Set sipProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $sipProfileName
     * @return \CUCM\StructType\XPhone
     */
    public function setSipProfileName(\CUCM\StructType\XFkType $sipProfileName = null)
    {
        if (is_null($sipProfileName) || (is_array($sipProfileName) && empty($sipProfileName))) {
            unset($this->sipProfileName);
        } else {
            $this->sipProfileName = $sipProfileName;
        }
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $cgpnTransformationCssName
     * @return \CUCM\StructType\XPhone
     */
    public function setCgpnTransformationCssName(\CUCM\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \CUCM\StructType\XPhone
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $geoLocationName
     * @return \CUCM\StructType\XPhone
     */
    public function setGeoLocationName(\CUCM\StructType\XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $geoLocationFilterName
     * @return \CUCM\StructType\XPhone
     */
    public function setGeoLocationFilterName(\CUCM\StructType\XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return \CUCM\StructType\XPhone
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sendGeoLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sendGeoLocation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendGeoLocation) && !is_string($sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendGeoLocation)), __LINE__);
        }
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get lines value
     * @return \CUCM\StructType\Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param \CUCM\StructType\Lines $lines
     * @return \CUCM\StructType\XPhone
     */
    public function setLines(\CUCM\StructType\Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get speeddials value
     * @return \CUCM\StructType\Speeddials|null
     */
    public function getSpeeddials()
    {
        return $this->speeddials;
    }
    /**
     * Set speeddials value
     * @param \CUCM\StructType\Speeddials $speeddials
     * @return \CUCM\StructType\XPhone
     */
    public function setSpeeddials(\CUCM\StructType\Speeddials $speeddials = null)
    {
        $this->speeddials = $speeddials;
        return $this;
    }
    /**
     * Get busyLampFields value
     * @return \CUCM\StructType\BusyLampFields|null
     */
    public function getBusyLampFields()
    {
        return $this->busyLampFields;
    }
    /**
     * Set busyLampFields value
     * @param \CUCM\StructType\BusyLampFields $busyLampFields
     * @return \CUCM\StructType\XPhone
     */
    public function setBusyLampFields(\CUCM\StructType\BusyLampFields $busyLampFields = null)
    {
        $this->busyLampFields = $busyLampFields;
        return $this;
    }
    /**
     * Get ringSettingIdleBlfAudibleAlert value
     * @return string|null
     */
    public function getRingSettingIdleBlfAudibleAlert()
    {
        return $this->ringSettingIdleBlfAudibleAlert;
    }
    /**
     * Set ringSettingIdleBlfAudibleAlert value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingIdleBlfAudibleAlert
     * @return \CUCM\StructType\XPhone
     */
    public function setRingSettingIdleBlfAudibleAlert($ringSettingIdleBlfAudibleAlert = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($ringSettingIdleBlfAudibleAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingIdleBlfAudibleAlert, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->ringSettingIdleBlfAudibleAlert = $ringSettingIdleBlfAudibleAlert;
        return $this;
    }
    /**
     * Get ringSettingBusyBlfAudibleAlert value
     * @return string|null
     */
    public function getRingSettingBusyBlfAudibleAlert()
    {
        return $this->ringSettingBusyBlfAudibleAlert;
    }
    /**
     * Set ringSettingBusyBlfAudibleAlert value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingBusyBlfAudibleAlert
     * @return \CUCM\StructType\XPhone
     */
    public function setRingSettingBusyBlfAudibleAlert($ringSettingBusyBlfAudibleAlert = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($ringSettingBusyBlfAudibleAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingBusyBlfAudibleAlert, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->ringSettingBusyBlfAudibleAlert = $ringSettingBusyBlfAudibleAlert;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return \CUCM\StructType\BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param \CUCM\StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @return \CUCM\StructType\XPhone
     */
    public function setBlfDirectedCallParks(\CUCM\StructType\BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return \CUCM\StructType\AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param \CUCM\StructType\AddOnModules $addOnModules
     * @return \CUCM\StructType\XPhone
     */
    public function setAddOnModules(\CUCM\StructType\AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userlocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserlocale()
    {
        return isset($this->userlocale) ? $this->userlocale : null;
    }
    /**
     * Set userlocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XUserLocale::valueIsValid()
     * @uses \CUCM\EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userlocale
     * @return \CUCM\StructType\XPhone
     */
    public function setUserlocale($userlocale = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XUserLocale::valueIsValid($userlocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userlocale, implode(', ', \CUCM\EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        if (is_null($userlocale) || (is_array($userlocale) && empty($userlocale))) {
            unset($this->userlocale);
        } else {
            $this->userlocale = $userlocale;
        }
        return $this;
    }
    /**
     * Get networkLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return isset($this->networkLocale) ? $this->networkLocale : null;
    }
    /**
     * Set networkLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XCountry::valueIsValid()
     * @uses \CUCM\EnumType\XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return \CUCM\StructType\XPhone
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocale, implode(', ', \CUCM\EnumType\XCountry::getValidValues())), __LINE__);
        }
        if (is_null($networkLocale) || (is_array($networkLocale) && empty($networkLocale))) {
            unset($this->networkLocale);
        } else {
            $this->networkLocale = $networkLocale;
        }
        return $this;
    }
    /**
     * Get idleTimeout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdleTimeout()
    {
        return isset($this->idleTimeout) ? $this->idleTimeout : null;
    }
    /**
     * Set idleTimeout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $idleTimeout
     * @return \CUCM\StructType\XPhone
     */
    public function setIdleTimeout($idleTimeout = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($idleTimeout)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $idleTimeout, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($idleTimeout) || (is_array($idleTimeout) && empty($idleTimeout))) {
            unset($this->idleTimeout);
        } else {
            $this->idleTimeout = $idleTimeout;
        }
        return $this;
    }
    /**
     * Get authenticationUrl value
     * @return string|null
     */
    public function getAuthenticationUrl()
    {
        return $this->authenticationUrl;
    }
    /**
     * Set authenticationUrl value
     * @param string $authenticationUrl
     * @return \CUCM\StructType\XPhone
     */
    public function setAuthenticationUrl($authenticationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationUrl) && !is_string($authenticationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationUrl)), __LINE__);
        }
        $this->authenticationUrl = $authenticationUrl;
        return $this;
    }
    /**
     * Get directoryUrl value
     * @return string|null
     */
    public function getDirectoryUrl()
    {
        return $this->directoryUrl;
    }
    /**
     * Set directoryUrl value
     * @param string $directoryUrl
     * @return \CUCM\StructType\XPhone
     */
    public function setDirectoryUrl($directoryUrl = null)
    {
        // validation for constraint: string
        if (!is_null($directoryUrl) && !is_string($directoryUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directoryUrl)), __LINE__);
        }
        $this->directoryUrl = $directoryUrl;
        return $this;
    }
    /**
     * Get idleUrl value
     * @return string|null
     */
    public function getIdleUrl()
    {
        return $this->idleUrl;
    }
    /**
     * Set idleUrl value
     * @param string $idleUrl
     * @return \CUCM\StructType\XPhone
     */
    public function setIdleUrl($idleUrl = null)
    {
        // validation for constraint: string
        if (!is_null($idleUrl) && !is_string($idleUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idleUrl)), __LINE__);
        }
        $this->idleUrl = $idleUrl;
        return $this;
    }
    /**
     * Get informationUrl value
     * @return string|null
     */
    public function getInformationUrl()
    {
        return $this->informationUrl;
    }
    /**
     * Set informationUrl value
     * @param string $informationUrl
     * @return \CUCM\StructType\XPhone
     */
    public function setInformationUrl($informationUrl = null)
    {
        // validation for constraint: string
        if (!is_null($informationUrl) && !is_string($informationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($informationUrl)), __LINE__);
        }
        $this->informationUrl = $informationUrl;
        return $this;
    }
    /**
     * Get messagesUrl value
     * @return string|null
     */
    public function getMessagesUrl()
    {
        return $this->messagesUrl;
    }
    /**
     * Set messagesUrl value
     * @param string $messagesUrl
     * @return \CUCM\StructType\XPhone
     */
    public function setMessagesUrl($messagesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($messagesUrl) && !is_string($messagesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($messagesUrl)), __LINE__);
        }
        $this->messagesUrl = $messagesUrl;
        return $this;
    }
    /**
     * Get proxyServerUrl value
     * @return string|null
     */
    public function getProxyServerUrl()
    {
        return $this->proxyServerUrl;
    }
    /**
     * Set proxyServerUrl value
     * @param string $proxyServerUrl
     * @return \CUCM\StructType\XPhone
     */
    public function setProxyServerUrl($proxyServerUrl = null)
    {
        // validation for constraint: string
        if (!is_null($proxyServerUrl) && !is_string($proxyServerUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($proxyServerUrl)), __LINE__);
        }
        $this->proxyServerUrl = $proxyServerUrl;
        return $this;
    }
    /**
     * Get servicesUrl value
     * @return string|null
     */
    public function getServicesUrl()
    {
        return $this->servicesUrl;
    }
    /**
     * Set servicesUrl value
     * @param string $servicesUrl
     * @return \CUCM\StructType\XPhone
     */
    public function setServicesUrl($servicesUrl = null)
    {
        // validation for constraint: string
        if (!is_null($servicesUrl) && !is_string($servicesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicesUrl)), __LINE__);
        }
        $this->servicesUrl = $servicesUrl;
        return $this;
    }
    /**
     * Get services value
     * @return \CUCM\StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \CUCM\StructType\Services $services
     * @return \CUCM\StructType\XPhone
     */
    public function setServices(\CUCM\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return isset($this->softkeyTemplateName) ? $this->softkeyTemplateName : null;
    }
    /**
     * Set softkeyTemplateName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $softkeyTemplateName
     * @return \CUCM\StructType\XPhone
     */
    public function setSoftkeyTemplateName(\CUCM\StructType\XFkType $softkeyTemplateName = null)
    {
        if (is_null($softkeyTemplateName) || (is_array($softkeyTemplateName) && empty($softkeyTemplateName))) {
            unset($this->softkeyTemplateName);
        } else {
            $this->softkeyTemplateName = $softkeyTemplateName;
        }
        return $this;
    }
    /**
     * Get defaultProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDefaultProfileName()
    {
        return isset($this->defaultProfileName) ? $this->defaultProfileName : null;
    }
    /**
     * Set defaultProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $defaultProfileName
     * @return \CUCM\StructType\XPhone
     */
    public function setDefaultProfileName(\CUCM\StructType\XFkType $defaultProfileName = null)
    {
        if (is_null($defaultProfileName) || (is_array($defaultProfileName) && empty($defaultProfileName))) {
            unset($this->defaultProfileName);
        } else {
            $this->defaultProfileName = $defaultProfileName;
        }
        return $this;
    }
    /**
     * Get enableExtensionMobility value
     * @return string|null
     */
    public function getEnableExtensionMobility()
    {
        return $this->enableExtensionMobility;
    }
    /**
     * Set enableExtensionMobility value
     * @param string $enableExtensionMobility
     * @return \CUCM\StructType\XPhone
     */
    public function setEnableExtensionMobility($enableExtensionMobility = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableExtensionMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableExtensionMobility, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableExtensionMobility) && !is_string($enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableExtensionMobility)), __LINE__);
        }
        $this->enableExtensionMobility = $enableExtensionMobility;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses \CUCM\EnumType\XBarge::valueIsValid()
     * @uses \CUCM\EnumType\XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return \CUCM\StructType\XPhone
     */
    public function setSingleButtonBarge($singleButtonBarge = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $singleButtonBarge, implode(', ', \CUCM\EnumType\XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return \CUCM\StructType\XPhone
     */
    public function setJoinAcrossLines($joinAcrossLines = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $joinAcrossLines, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return string|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callInfoPrivacyStatus
     * @return \CUCM\StructType\XPhone
     */
    public function setCallInfoPrivacyStatus($callInfoPrivacyStatus = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($callInfoPrivacyStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callInfoPrivacyStatus, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get hlogStatus value
     * @return string|null
     */
    public function getHlogStatus()
    {
        return $this->hlogStatus;
    }
    /**
     * Set hlogStatus value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hlogStatus
     * @return \CUCM\StructType\XPhone
     */
    public function setHlogStatus($hlogStatus = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($hlogStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hlogStatus, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->hlogStatus = $hlogStatus;
        return $this;
    }
    /**
     * Get ownerUserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getOwnerUserName()
    {
        return isset($this->ownerUserName) ? $this->ownerUserName : null;
    }
    /**
     * Set ownerUserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $ownerUserName
     * @return \CUCM\StructType\XPhone
     */
    public function setOwnerUserName(\CUCM\StructType\XFkType $ownerUserName = null)
    {
        if (is_null($ownerUserName) || (is_array($ownerUserName) && empty($ownerUserName))) {
            unset($this->ownerUserName);
        } else {
            $this->ownerUserName = $ownerUserName;
        }
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return \CUCM\StructType\XPhone
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = false)
    {
        // validation for constraint: pattern
        if (is_scalar($ignorePresentationIndicators) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ignorePresentationIndicators, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ignorePresentationIndicators) && !is_string($ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ignorePresentationIndicators)), __LINE__);
        }
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return \CUCM\StructType\XPhone
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return isset($this->subscribeCallingSearchSpaceName) ? $this->subscribeCallingSearchSpaceName : null;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \CUCM\StructType\XPhone
     */
    public function setSubscribeCallingSearchSpaceName(\CUCM\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        if (is_null($subscribeCallingSearchSpaceName) || (is_array($subscribeCallingSearchSpaceName) && empty($subscribeCallingSearchSpaceName))) {
            unset($this->subscribeCallingSearchSpaceName);
        } else {
            $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return isset($this->rerouteCallingSearchSpaceName) ? $this->rerouteCallingSearchSpaceName : null;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $rerouteCallingSearchSpaceName
     * @return \CUCM\StructType\XPhone
     */
    public function setRerouteCallingSearchSpaceName(\CUCM\StructType\XFkType $rerouteCallingSearchSpaceName = null)
    {
        if (is_null($rerouteCallingSearchSpaceName) || (is_array($rerouteCallingSearchSpaceName) && empty($rerouteCallingSearchSpaceName))) {
            unset($this->rerouteCallingSearchSpaceName);
        } else {
            $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get allowCtiControlFlag value
     * @return string|null
     */
    public function getAllowCtiControlFlag()
    {
        return $this->allowCtiControlFlag;
    }
    /**
     * Set allowCtiControlFlag value
     * @param string $allowCtiControlFlag
     * @return \CUCM\StructType\XPhone
     */
    public function setAllowCtiControlFlag($allowCtiControlFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowCtiControlFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowCtiControlFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowCtiControlFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowCtiControlFlag) && !is_string($allowCtiControlFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowCtiControlFlag)), __LINE__);
        }
        $this->allowCtiControlFlag = $allowCtiControlFlag;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @return \CUCM\StructType\XPhone
     */
    public function setPresenceGroupName(\CUCM\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \CUCM\StructType\XPhone
     */
    public function setUnattendedPort($unattendedPort = false)
    {
        // validation for constraint: pattern
        if (is_scalar($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unattendedPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unattendedPort)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get requireDtmfReception value
     * @return string|null
     */
    public function getRequireDtmfReception()
    {
        return $this->requireDtmfReception;
    }
    /**
     * Set requireDtmfReception value
     * @param string $requireDtmfReception
     * @return \CUCM\StructType\XPhone
     */
    public function setRequireDtmfReception($requireDtmfReception = false)
    {
        // validation for constraint: pattern
        if (is_scalar($requireDtmfReception) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $requireDtmfReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($requireDtmfReception, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requireDtmfReception) && !is_string($requireDtmfReception)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requireDtmfReception)), __LINE__);
        }
        $this->requireDtmfReception = $requireDtmfReception;
        return $this;
    }
    /**
     * Get rfc2833Disabled value
     * @return string|null
     */
    public function getRfc2833Disabled()
    {
        return $this->rfc2833Disabled;
    }
    /**
     * Set rfc2833Disabled value
     * @param string $rfc2833Disabled
     * @return \CUCM\StructType\XPhone
     */
    public function setRfc2833Disabled($rfc2833Disabled = false)
    {
        // validation for constraint: pattern
        if (is_scalar($rfc2833Disabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $rfc2833Disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($rfc2833Disabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rfc2833Disabled) && !is_string($rfc2833Disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rfc2833Disabled)), __LINE__);
        }
        $this->rfc2833Disabled = $rfc2833Disabled;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string|null
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses \CUCM\EnumType\XAuthenticationMode::valueIsValid()
     * @uses \CUCM\EnumType\XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return \CUCM\StructType\XPhone
     */
    public function setAuthenticationMode($authenticationMode = 'By Null String')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMode, implode(', ', \CUCM\EnumType\XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string|null
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses \CUCM\EnumType\XKeySize::valueIsValid()
     * @uses \CUCM\EnumType\XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return \CUCM\StructType\XPhone
     */
    public function setKeySize($keySize = '1024')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keySize, implode(', ', \CUCM\EnumType\XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return \CUCM\StructType\XPhone
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authenticationString) && strlen($authenticationString) > 128) || (is_array($authenticationString) && count($authenticationString) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($authenticationString) ? strlen($authenticationString) : count($authenticationString)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get upgradeFinishTime value
     * @return string|null
     */
    public function getUpgradeFinishTime()
    {
        return $this->upgradeFinishTime;
    }
    /**
     * Set upgradeFinishTime value
     * @param string $upgradeFinishTime
     * @return \CUCM\StructType\XPhone
     */
    public function setUpgradeFinishTime($upgradeFinishTime = null)
    {
        // validation for constraint: string
        if (!is_null($upgradeFinishTime) && !is_string($upgradeFinishTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($upgradeFinishTime)), __LINE__);
        }
        $this->upgradeFinishTime = $upgradeFinishTime;
        return $this;
    }
    /**
     * Get remoteDevice value
     * @return string|null
     */
    public function getRemoteDevice()
    {
        return $this->remoteDevice;
    }
    /**
     * Set remoteDevice value
     * @param string $remoteDevice
     * @return \CUCM\StructType\XPhone
     */
    public function setRemoteDevice($remoteDevice = false)
    {
        // validation for constraint: pattern
        if (is_scalar($remoteDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($remoteDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($remoteDevice) && !is_string($remoteDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remoteDevice)), __LINE__);
        }
        $this->remoteDevice = $remoteDevice;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses \CUCM\EnumType\XDNDOption::valueIsValid()
     * @uses \CUCM\EnumType\XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return \CUCM\StructType\XPhone
     */
    public function setDndOption($dndOption = 'Ringer Off')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndOption, implode(', ', \CUCM\EnumType\XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDndRingSetting()
    {
        return isset($this->dndRingSetting) ? $this->dndRingSetting : null;
    }
    /**
     * Set dndRingSetting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XRingSetting::valueIsValid()
     * @uses \CUCM\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndRingSetting
     * @return \CUCM\StructType\XPhone
     */
    public function setDndRingSetting($dndRingSetting = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XRingSetting::valueIsValid($dndRingSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndRingSetting, implode(', ', \CUCM\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($dndRingSetting) || (is_array($dndRingSetting) && empty($dndRingSetting))) {
            unset($this->dndRingSetting);
        } else {
            $this->dndRingSetting = $dndRingSetting;
        }
        return $this;
    }
    /**
     * Get dndStatus value
     * @return string|null
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return \CUCM\StructType\XPhone
     */
    public function setDndStatus($dndStatus = null)
    {
        // validation for constraint: pattern
        if (is_scalar($dndStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($dndStatus, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dndStatus) && !is_string($dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dndStatus)), __LINE__);
        }
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get isActive value
     * @return string|null
     */
    public function getIsActive()
    {
        return $this->isActive;
    }
    /**
     * Set isActive value
     * @param string $isActive
     * @return \CUCM\StructType\XPhone
     */
    public function setIsActive($isActive = true)
    {
        // validation for constraint: pattern
        if (is_scalar($isActive) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActive, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActive) && !is_string($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->isActive = $isActive;
        return $this;
    }
    /**
     * Get isDualMode value
     * @return string|null
     */
    public function getIsDualMode()
    {
        return $this->isDualMode;
    }
    /**
     * Set isDualMode value
     * @param string $isDualMode
     * @return \CUCM\StructType\XPhone
     */
    public function setIsDualMode($isDualMode = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isDualMode) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDualMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isDualMode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isDualMode) && !is_string($isDualMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isDualMode)), __LINE__);
        }
        $this->isDualMode = $isDualMode;
        return $this;
    }
    /**
     * Get mobilityUserIdName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getMobilityUserIdName()
    {
        return isset($this->mobilityUserIdName) ? $this->mobilityUserIdName : null;
    }
    /**
     * Set mobilityUserIdName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $mobilityUserIdName
     * @return \CUCM\StructType\XPhone
     */
    public function setMobilityUserIdName(\CUCM\StructType\XFkType $mobilityUserIdName = null)
    {
        if (is_null($mobilityUserIdName) || (is_array($mobilityUserIdName) && empty($mobilityUserIdName))) {
            unset($this->mobilityUserIdName);
        } else {
            $this->mobilityUserIdName = $mobilityUserIdName;
        }
        return $this;
    }
    /**
     * Get phoneSuite value
     * @return string|null
     */
    public function getPhoneSuite()
    {
        return $this->phoneSuite;
    }
    /**
     * Set phoneSuite value
     * @uses \CUCM\EnumType\XPhonePersonalization::valueIsValid()
     * @uses \CUCM\EnumType\XPhonePersonalization::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneSuite
     * @return \CUCM\StructType\XPhone
     */
    public function setPhoneSuite($phoneSuite = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPhonePersonalization::valueIsValid($phoneSuite)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneSuite, implode(', ', \CUCM\EnumType\XPhonePersonalization::getValidValues())), __LINE__);
        }
        $this->phoneSuite = $phoneSuite;
        return $this;
    }
    /**
     * Get phoneServiceDisplay value
     * @return string|null
     */
    public function getPhoneServiceDisplay()
    {
        return $this->phoneServiceDisplay;
    }
    /**
     * Set phoneServiceDisplay value
     * @uses \CUCM\EnumType\XPhoneServiceDisplay::valueIsValid()
     * @uses \CUCM\EnumType\XPhoneServiceDisplay::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $phoneServiceDisplay
     * @return \CUCM\StructType\XPhone
     */
    public function setPhoneServiceDisplay($phoneServiceDisplay = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPhoneServiceDisplay::valueIsValid($phoneServiceDisplay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $phoneServiceDisplay, implode(', ', \CUCM\EnumType\XPhoneServiceDisplay::getValidValues())), __LINE__);
        }
        $this->phoneServiceDisplay = $phoneServiceDisplay;
        return $this;
    }
    /**
     * Get isProtected value
     * @return string|null
     */
    public function getIsProtected()
    {
        return $this->isProtected;
    }
    /**
     * Set isProtected value
     * @param string $isProtected
     * @return \CUCM\StructType\XPhone
     */
    public function setIsProtected($isProtected = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isProtected) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isProtected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isProtected, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isProtected) && !is_string($isProtected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isProtected)), __LINE__);
        }
        $this->isProtected = $isProtected;
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return \CUCM\StructType\XPhone
     */
    public function setMtpRequired($mtpRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mtpRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($mtpRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mtpRequired) && !is_string($mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mtpRequired)), __LINE__);
        }
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get mtpPreferedCodec value
     * @return string|null
     */
    public function getMtpPreferedCodec()
    {
        return $this->mtpPreferedCodec;
    }
    /**
     * Set mtpPreferedCodec value
     * @uses \CUCM\EnumType\XSIPCodec::valueIsValid()
     * @uses \CUCM\EnumType\XSIPCodec::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mtpPreferedCodec
     * @return \CUCM\StructType\XPhone
     */
    public function setMtpPreferedCodec($mtpPreferedCodec = '711ulaw')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XSIPCodec::valueIsValid($mtpPreferedCodec)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mtpPreferedCodec, implode(', ', \CUCM\EnumType\XSIPCodec::getValidValues())), __LINE__);
        }
        $this->mtpPreferedCodec = $mtpPreferedCodec;
        return $this;
    }
    /**
     * Get dialRulesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDialRulesName()
    {
        return isset($this->dialRulesName) ? $this->dialRulesName : null;
    }
    /**
     * Set dialRulesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $dialRulesName
     * @return \CUCM\StructType\XPhone
     */
    public function setDialRulesName(\CUCM\StructType\XFkType $dialRulesName = null)
    {
        if (is_null($dialRulesName) || (is_array($dialRulesName) && empty($dialRulesName))) {
            unset($this->dialRulesName);
        } else {
            $this->dialRulesName = $dialRulesName;
        }
        return $this;
    }
    /**
     * Get sshUserId value
     * @return string|null
     */
    public function getSshUserId()
    {
        return $this->sshUserId;
    }
    /**
     * Set sshUserId value
     * @param string $sshUserId
     * @return \CUCM\StructType\XPhone
     */
    public function setSshUserId($sshUserId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sshUserId) && strlen($sshUserId) > 50) || (is_array($sshUserId) && count($sshUserId) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($sshUserId) ? strlen($sshUserId) : count($sshUserId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sshUserId) && !is_string($sshUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sshUserId)), __LINE__);
        }
        $this->sshUserId = $sshUserId;
        return $this;
    }
    /**
     * Get sshPwd value
     * @return string|null
     */
    public function getSshPwd()
    {
        return $this->sshPwd;
    }
    /**
     * Set sshPwd value
     * @param string $sshPwd
     * @return \CUCM\StructType\XPhone
     */
    public function setSshPwd($sshPwd = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sshPwd) && strlen($sshPwd) > 255) || (is_array($sshPwd) && count($sshPwd) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($sshPwd) ? strlen($sshPwd) : count($sshPwd)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sshPwd) && !is_string($sshPwd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sshPwd)), __LINE__);
        }
        $this->sshPwd = $sshPwd;
        return $this;
    }
    /**
     * Get digestUser value
     * @return string|null
     */
    public function getDigestUser()
    {
        return $this->digestUser;
    }
    /**
     * Set digestUser value
     * @param string $digestUser
     * @return \CUCM\StructType\XPhone
     */
    public function setDigestUser($digestUser = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($digestUser) && strlen($digestUser) > 255) || (is_array($digestUser) && count($digestUser) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($digestUser) ? strlen($digestUser) : count($digestUser)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($digestUser) && !is_string($digestUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digestUser)), __LINE__);
        }
        $this->digestUser = $digestUser;
        return $this;
    }
    /**
     * Get outboundCallRollover value
     * @return string|null
     */
    public function getOutboundCallRollover()
    {
        return $this->outboundCallRollover;
    }
    /**
     * Set outboundCallRollover value
     * @uses \CUCM\EnumType\XOutboundCallRollover::valueIsValid()
     * @uses \CUCM\EnumType\XOutboundCallRollover::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $outboundCallRollover
     * @return \CUCM\StructType\XPhone
     */
    public function setOutboundCallRollover($outboundCallRollover = 'No Rollover')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XOutboundCallRollover::valueIsValid($outboundCallRollover)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $outboundCallRollover, implode(', ', \CUCM\EnumType\XOutboundCallRollover::getValidValues())), __LINE__);
        }
        $this->outboundCallRollover = $outboundCallRollover;
        return $this;
    }
    /**
     * Get hotlineDevice value
     * @return string|null
     */
    public function getHotlineDevice()
    {
        return $this->hotlineDevice;
    }
    /**
     * Set hotlineDevice value
     * @param string $hotlineDevice
     * @return \CUCM\StructType\XPhone
     */
    public function setHotlineDevice($hotlineDevice = false)
    {
        // validation for constraint: pattern
        if (is_scalar($hotlineDevice) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($hotlineDevice, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hotlineDevice) && !is_string($hotlineDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotlineDevice)), __LINE__);
        }
        $this->hotlineDevice = $hotlineDevice;
        return $this;
    }
    /**
     * Get secureInformationUrl value
     * @return string|null
     */
    public function getSecureInformationUrl()
    {
        return $this->secureInformationUrl;
    }
    /**
     * Set secureInformationUrl value
     * @param string $secureInformationUrl
     * @return \CUCM\StructType\XPhone
     */
    public function setSecureInformationUrl($secureInformationUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureInformationUrl) && strlen($secureInformationUrl) > 255) || (is_array($secureInformationUrl) && count($secureInformationUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureInformationUrl) ? strlen($secureInformationUrl) : count($secureInformationUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureInformationUrl) && !is_string($secureInformationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureInformationUrl)), __LINE__);
        }
        $this->secureInformationUrl = $secureInformationUrl;
        return $this;
    }
    /**
     * Get secureDirectoryUrl value
     * @return string|null
     */
    public function getSecureDirectoryUrl()
    {
        return $this->secureDirectoryUrl;
    }
    /**
     * Set secureDirectoryUrl value
     * @param string $secureDirectoryUrl
     * @return \CUCM\StructType\XPhone
     */
    public function setSecureDirectoryUrl($secureDirectoryUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureDirectoryUrl) && strlen($secureDirectoryUrl) > 255) || (is_array($secureDirectoryUrl) && count($secureDirectoryUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureDirectoryUrl) ? strlen($secureDirectoryUrl) : count($secureDirectoryUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureDirectoryUrl) && !is_string($secureDirectoryUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureDirectoryUrl)), __LINE__);
        }
        $this->secureDirectoryUrl = $secureDirectoryUrl;
        return $this;
    }
    /**
     * Get secureMessageUrl value
     * @return string|null
     */
    public function getSecureMessageUrl()
    {
        return $this->secureMessageUrl;
    }
    /**
     * Set secureMessageUrl value
     * @param string $secureMessageUrl
     * @return \CUCM\StructType\XPhone
     */
    public function setSecureMessageUrl($secureMessageUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureMessageUrl) && strlen($secureMessageUrl) > 255) || (is_array($secureMessageUrl) && count($secureMessageUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureMessageUrl) ? strlen($secureMessageUrl) : count($secureMessageUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureMessageUrl) && !is_string($secureMessageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureMessageUrl)), __LINE__);
        }
        $this->secureMessageUrl = $secureMessageUrl;
        return $this;
    }
    /**
     * Get secureServicesUrl value
     * @return string|null
     */
    public function getSecureServicesUrl()
    {
        return $this->secureServicesUrl;
    }
    /**
     * Set secureServicesUrl value
     * @param string $secureServicesUrl
     * @return \CUCM\StructType\XPhone
     */
    public function setSecureServicesUrl($secureServicesUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureServicesUrl) && strlen($secureServicesUrl) > 255) || (is_array($secureServicesUrl) && count($secureServicesUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureServicesUrl) ? strlen($secureServicesUrl) : count($secureServicesUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureServicesUrl) && !is_string($secureServicesUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureServicesUrl)), __LINE__);
        }
        $this->secureServicesUrl = $secureServicesUrl;
        return $this;
    }
    /**
     * Get secureAuthenticationUrl value
     * @return string|null
     */
    public function getSecureAuthenticationUrl()
    {
        return $this->secureAuthenticationUrl;
    }
    /**
     * Set secureAuthenticationUrl value
     * @param string $secureAuthenticationUrl
     * @return \CUCM\StructType\XPhone
     */
    public function setSecureAuthenticationUrl($secureAuthenticationUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureAuthenticationUrl) && strlen($secureAuthenticationUrl) > 255) || (is_array($secureAuthenticationUrl) && count($secureAuthenticationUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureAuthenticationUrl) ? strlen($secureAuthenticationUrl) : count($secureAuthenticationUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureAuthenticationUrl) && !is_string($secureAuthenticationUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureAuthenticationUrl)), __LINE__);
        }
        $this->secureAuthenticationUrl = $secureAuthenticationUrl;
        return $this;
    }
    /**
     * Get secureIdleUrl value
     * @return string|null
     */
    public function getSecureIdleUrl()
    {
        return $this->secureIdleUrl;
    }
    /**
     * Set secureIdleUrl value
     * @param string $secureIdleUrl
     * @return \CUCM\StructType\XPhone
     */
    public function setSecureIdleUrl($secureIdleUrl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secureIdleUrl) && strlen($secureIdleUrl) > 255) || (is_array($secureIdleUrl) && count($secureIdleUrl) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secureIdleUrl) ? strlen($secureIdleUrl) : count($secureIdleUrl)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secureIdleUrl) && !is_string($secureIdleUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secureIdleUrl)), __LINE__);
        }
        $this->secureIdleUrl = $secureIdleUrl;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return \CUCM\StructType\XPhone
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLine, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \CUCM\StructType\XPhone
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLineForVoiceMessage, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return isset($this->featureControlPolicy) ? $this->featureControlPolicy : null;
    }
    /**
     * Set featureControlPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $featureControlPolicy
     * @return \CUCM\StructType\XPhone
     */
    public function setFeatureControlPolicy(\CUCM\StructType\XFkType $featureControlPolicy = null)
    {
        if (is_null($featureControlPolicy) || (is_array($featureControlPolicy) && empty($featureControlPolicy))) {
            unset($this->featureControlPolicy);
        } else {
            $this->featureControlPolicy = $featureControlPolicy;
        }
        return $this;
    }
    /**
     * Get deviceTrustMode value
     * @return string|null
     */
    public function getDeviceTrustMode()
    {
        return $this->deviceTrustMode;
    }
    /**
     * Set deviceTrustMode value
     * @uses \CUCM\EnumType\XDeviceTrustMode::valueIsValid()
     * @uses \CUCM\EnumType\XDeviceTrustMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceTrustMode
     * @return \CUCM\StructType\XPhone
     */
    public function setDeviceTrustMode($deviceTrustMode = 'Not Trusted')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDeviceTrustMode::valueIsValid($deviceTrustMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceTrustMode, implode(', ', \CUCM\EnumType\XDeviceTrustMode::getValidValues())), __LINE__);
        }
        $this->deviceTrustMode = $deviceTrustMode;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \CUCM\StructType\XPhone
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XPhone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
