<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XOSVersion StructType
 * @subpackage Structs
 */
class XOSVersion extends AbstractStructBase
{
    /**
     * The osName
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * @var string
     */
    public $osName;
    /**
     * The osVersion
     * Meta informations extracted from the WSDL
     * - maxLength: 50
     * @var string
     */
    public $osVersion;
    /**
     * Constructor method for XOSVersion
     * @uses XOSVersion::setOsName()
     * @uses XOSVersion::setOsVersion()
     * @param string $osName
     * @param string $osVersion
     */
    public function __construct($osName = null, $osVersion = null)
    {
        $this
            ->setOsName($osName)
            ->setOsVersion($osVersion);
    }
    /**
     * Get osName value
     * @return string|null
     */
    public function getOsName()
    {
        return $this->osName;
    }
    /**
     * Set osName value
     * @param string $osName
     * @return \CUCM\StructType\XOSVersion
     */
    public function setOsName($osName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($osName) && strlen($osName) > 50) || (is_array($osName) && count($osName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($osName) ? strlen($osName) : count($osName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($osName) && !is_string($osName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($osName)), __LINE__);
        }
        $this->osName = $osName;
        return $this;
    }
    /**
     * Get osVersion value
     * @return string|null
     */
    public function getOsVersion()
    {
        return $this->osVersion;
    }
    /**
     * Set osVersion value
     * @param string $osVersion
     * @return \CUCM\StructType\XOSVersion
     */
    public function setOsVersion($osVersion = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($osVersion) && strlen($osVersion) > 50) || (is_array($osVersion) && count($osVersion) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($osVersion) ? strlen($osVersion) : count($osVersion)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($osVersion) && !is_string($osVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($osVersion)), __LINE__);
        }
        $this->osVersion = $osVersion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XOSVersion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
