<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLocationRelationship StructType
 * @subpackage Structs
 */
class XLocationRelationship extends AbstractStructBase
{
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \CUCM\StructType\XFkType
     */
    public $locationName;
    /**
     * The rsvpSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $rsvpSetting;
    /**
     * Constructor method for XLocationRelationship
     * @uses XLocationRelationship::setLocationName()
     * @uses XLocationRelationship::setRsvpSetting()
     * @param \CUCM\StructType\XFkType $locationName
     * @param string $rsvpSetting
     */
    public function __construct(\CUCM\StructType\XFkType $locationName = null, $rsvpSetting = null)
    {
        $this
            ->setLocationName($locationName)
            ->setRsvpSetting($rsvpSetting);
    }
    /**
     * Get locationName value
     * @return \CUCM\StructType\XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \CUCM\StructType\XFkType $locationName
     * @return \CUCM\StructType\XLocationRelationship
     */
    public function setLocationName(\CUCM\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get rsvpSetting value
     * @return string
     */
    public function getRsvpSetting()
    {
        return $this->rsvpSetting;
    }
    /**
     * Set rsvpSetting value
     * @uses \CUCM\EnumType\XMatrixValue::valueIsValid()
     * @uses \CUCM\EnumType\XMatrixValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rsvpSetting
     * @return \CUCM\StructType\XLocationRelationship
     */
    public function setRsvpSetting($rsvpSetting = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMatrixValue::valueIsValid($rsvpSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rsvpSetting, implode(', ', \CUCM\EnumType\XMatrixValue::getValidValues())), __LINE__);
        }
        $this->rsvpSetting = $rsvpSetting;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XLocationRelationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
