<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XLocation StructType
 * @subpackage Structs
 */
class XLocation extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The kbits
     * Meta informations extracted from the WSDL
     * - documentation: Audio Bandwidth to be provided
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $kbits;
    /**
     * The videoKbits
     * Meta informations extracted from the WSDL
     * - default: 384
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $videoKbits;
    /**
     * The relatedLocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RelatedLocations
     */
    public $relatedLocations;
    /**
     * Constructor method for XLocation
     * @uses XLocation::setName()
     * @uses XLocation::setKbits()
     * @uses XLocation::setVideoKbits()
     * @uses XLocation::setRelatedLocations()
     * @param string $name
     * @param string $kbits
     * @param string $videoKbits
     * @param \CUCM\StructType\RelatedLocations $relatedLocations
     */
    public function __construct($name = null, $kbits = null, $videoKbits = '384', \CUCM\StructType\RelatedLocations $relatedLocations = null)
    {
        $this
            ->setName($name)
            ->setKbits($kbits)
            ->setVideoKbits($videoKbits)
            ->setRelatedLocations($relatedLocations);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\XLocation
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get kbits value
     * @return string
     */
    public function getKbits()
    {
        return $this->kbits;
    }
    /**
     * Set kbits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kbits
     * @return \CUCM\StructType\XLocation
     */
    public function setKbits($kbits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($kbits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $kbits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->kbits = $kbits;
        return $this;
    }
    /**
     * Get videoKbits value
     * @return string
     */
    public function getVideoKbits()
    {
        return $this->videoKbits;
    }
    /**
     * Set videoKbits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoKbits
     * @return \CUCM\StructType\XLocation
     */
    public function setVideoKbits($videoKbits = '384')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($videoKbits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $videoKbits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->videoKbits = $videoKbits;
        return $this;
    }
    /**
     * Get relatedLocations value
     * @return \CUCM\StructType\RelatedLocations|null
     */
    public function getRelatedLocations()
    {
        return $this->relatedLocations;
    }
    /**
     * Set relatedLocations value
     * @param \CUCM\StructType\RelatedLocations $relatedLocations
     * @return \CUCM\StructType\XLocation
     */
    public function setRelatedLocations(\CUCM\StructType\RelatedLocations $relatedLocations = null)
    {
        $this->relatedLocations = $relatedLocations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
