<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XImeRouteFilterElement StructType
 * @subpackage Structs
 */
class XImeRouteFilterElement extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The imeRouteFilterGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $imeRouteFilterGroupName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The elementType
     * Meta informations extracted from the WSDL
     * - default: Domain
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $elementType;
    /**
     * Constructor method for XImeRouteFilterElement
     * @uses XImeRouteFilterElement::setName()
     * @uses XImeRouteFilterElement::setImeRouteFilterGroupName()
     * @uses XImeRouteFilterElement::setDescription()
     * @uses XImeRouteFilterElement::setElementType()
     * @param string $name
     * @param \CUCM\StructType\XFkType $imeRouteFilterGroupName
     * @param string $description
     * @param string $elementType
     */
    public function __construct($name = null, \CUCM\StructType\XFkType $imeRouteFilterGroupName = null, $description = null, $elementType = 'Domain')
    {
        $this
            ->setName($name)
            ->setImeRouteFilterGroupName($imeRouteFilterGroupName)
            ->setDescription($description)
            ->setElementType($elementType);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\XImeRouteFilterElement
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get imeRouteFilterGroupName value
     * @return \CUCM\StructType\XFkType
     */
    public function getImeRouteFilterGroupName()
    {
        return $this->imeRouteFilterGroupName;
    }
    /**
     * Set imeRouteFilterGroupName value
     * @param \CUCM\StructType\XFkType $imeRouteFilterGroupName
     * @return \CUCM\StructType\XImeRouteFilterElement
     */
    public function setImeRouteFilterGroupName(\CUCM\StructType\XFkType $imeRouteFilterGroupName = null)
    {
        $this->imeRouteFilterGroupName = $imeRouteFilterGroupName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\XImeRouteFilterElement
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get elementType value
     * @return string|null
     */
    public function getElementType()
    {
        return $this->elementType;
    }
    /**
     * Set elementType value
     * @uses \CUCM\EnumType\XViprFilterElement::valueIsValid()
     * @uses \CUCM\EnumType\XViprFilterElement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $elementType
     * @return \CUCM\StructType\XImeRouteFilterElement
     */
    public function setElementType($elementType = 'Domain')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XViprFilterElement::valueIsValid($elementType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $elementType, implode(', ', \CUCM\EnumType\XViprFilterElement::getValidValues())), __LINE__);
        }
        $this->elementType = $elementType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XImeRouteFilterElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
