<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XH323TrunkDestination StructType
 * @subpackage Structs
 */
class XH323TrunkDestination extends AbstractStructBase
{
    /**
     * The sortOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $sortOrder;
    /**
     * The addressIpv4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $addressIpv4;
    /**
     * Constructor method for XH323TrunkDestination
     * @uses XH323TrunkDestination::setSortOrder()
     * @uses XH323TrunkDestination::setAddressIpv4()
     * @param string $sortOrder
     * @param string $addressIpv4
     */
    public function __construct($sortOrder = null, $addressIpv4 = null)
    {
        $this
            ->setSortOrder($sortOrder)
            ->setAddressIpv4($addressIpv4);
    }
    /**
     * Get sortOrder value
     * @return string
     */
    public function getSortOrder()
    {
        return $this->sortOrder;
    }
    /**
     * Set sortOrder value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return \CUCM\StructType\XH323TrunkDestination
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sortOrder, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get addressIpv4 value
     * @return string|null
     */
    public function getAddressIpv4()
    {
        return $this->addressIpv4;
    }
    /**
     * Set addressIpv4 value
     * @param string $addressIpv4
     * @return \CUCM\StructType\XH323TrunkDestination
     */
    public function setAddressIpv4($addressIpv4 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($addressIpv4) && strlen($addressIpv4) > 255) || (is_array($addressIpv4) && count($addressIpv4) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($addressIpv4) ? strlen($addressIpv4) : count($addressIpv4)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressIpv4) && !is_string($addressIpv4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressIpv4)), __LINE__);
        }
        $this->addressIpv4 = $addressIpv4;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XH323TrunkDestination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
