<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XExternalCallControlProfile StructType
 * @subpackage Structs
 */
class XExternalCallControlProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The primaryUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $primaryUri;
    /**
     * The callTreatmentOnFailure
     * Meta informations extracted from the WSDL
     * - default: Allow Calls
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $callTreatmentOnFailure;
    /**
     * The secondaryUri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $secondaryUri;
    /**
     * The enableLoadBalancing
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableLoadBalancing;
    /**
     * The routingRequestTimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $routingRequestTimer;
    /**
     * The diversionReroutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $diversionReroutingCssName;
    /**
     * Constructor method for XExternalCallControlProfile
     * @uses XExternalCallControlProfile::setName()
     * @uses XExternalCallControlProfile::setPrimaryUri()
     * @uses XExternalCallControlProfile::setCallTreatmentOnFailure()
     * @uses XExternalCallControlProfile::setSecondaryUri()
     * @uses XExternalCallControlProfile::setEnableLoadBalancing()
     * @uses XExternalCallControlProfile::setRoutingRequestTimer()
     * @uses XExternalCallControlProfile::setDiversionReroutingCssName()
     * @param string $name
     * @param string $primaryUri
     * @param string $callTreatmentOnFailure
     * @param string $secondaryUri
     * @param string $enableLoadBalancing
     * @param string $routingRequestTimer
     * @param \CUCM\StructType\XFkType $diversionReroutingCssName
     */
    public function __construct($name = null, $primaryUri = null, $callTreatmentOnFailure = 'Allow Calls', $secondaryUri = null, $enableLoadBalancing = false, $routingRequestTimer = null, \CUCM\StructType\XFkType $diversionReroutingCssName = null)
    {
        $this
            ->setName($name)
            ->setPrimaryUri($primaryUri)
            ->setCallTreatmentOnFailure($callTreatmentOnFailure)
            ->setSecondaryUri($secondaryUri)
            ->setEnableLoadBalancing($enableLoadBalancing)
            ->setRoutingRequestTimer($routingRequestTimer)
            ->setDiversionReroutingCssName($diversionReroutingCssName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\XExternalCallControlProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get primaryUri value
     * @return string
     */
    public function getPrimaryUri()
    {
        return $this->primaryUri;
    }
    /**
     * Set primaryUri value
     * @param string $primaryUri
     * @return \CUCM\StructType\XExternalCallControlProfile
     */
    public function setPrimaryUri($primaryUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($primaryUri) && strlen($primaryUri) > 255) || (is_array($primaryUri) && count($primaryUri) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($primaryUri) ? strlen($primaryUri) : count($primaryUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($primaryUri) && !is_string($primaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryUri)), __LINE__);
        }
        $this->primaryUri = $primaryUri;
        return $this;
    }
    /**
     * Get callTreatmentOnFailure value
     * @return string
     */
    public function getCallTreatmentOnFailure()
    {
        return $this->callTreatmentOnFailure;
    }
    /**
     * Set callTreatmentOnFailure value
     * @uses \CUCM\EnumType\XCallTreatmentOnFailure::valueIsValid()
     * @uses \CUCM\EnumType\XCallTreatmentOnFailure::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callTreatmentOnFailure
     * @return \CUCM\StructType\XExternalCallControlProfile
     */
    public function setCallTreatmentOnFailure($callTreatmentOnFailure = 'Allow Calls')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XCallTreatmentOnFailure::valueIsValid($callTreatmentOnFailure)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callTreatmentOnFailure, implode(', ', \CUCM\EnumType\XCallTreatmentOnFailure::getValidValues())), __LINE__);
        }
        $this->callTreatmentOnFailure = $callTreatmentOnFailure;
        return $this;
    }
    /**
     * Get secondaryUri value
     * @return string|null
     */
    public function getSecondaryUri()
    {
        return $this->secondaryUri;
    }
    /**
     * Set secondaryUri value
     * @param string $secondaryUri
     * @return \CUCM\StructType\XExternalCallControlProfile
     */
    public function setSecondaryUri($secondaryUri = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($secondaryUri) && strlen($secondaryUri) > 255) || (is_array($secondaryUri) && count($secondaryUri) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($secondaryUri) ? strlen($secondaryUri) : count($secondaryUri)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($secondaryUri) && !is_string($secondaryUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondaryUri)), __LINE__);
        }
        $this->secondaryUri = $secondaryUri;
        return $this;
    }
    /**
     * Get enableLoadBalancing value
     * @return string|null
     */
    public function getEnableLoadBalancing()
    {
        return $this->enableLoadBalancing;
    }
    /**
     * Set enableLoadBalancing value
     * @param string $enableLoadBalancing
     * @return \CUCM\StructType\XExternalCallControlProfile
     */
    public function setEnableLoadBalancing($enableLoadBalancing = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enableLoadBalancing) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableLoadBalancing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableLoadBalancing, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableLoadBalancing) && !is_string($enableLoadBalancing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableLoadBalancing)), __LINE__);
        }
        $this->enableLoadBalancing = $enableLoadBalancing;
        return $this;
    }
    /**
     * Get routingRequestTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutingRequestTimer()
    {
        return isset($this->routingRequestTimer) ? $this->routingRequestTimer : null;
    }
    /**
     * Set routingRequestTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routingRequestTimer
     * @return \CUCM\StructType\XExternalCallControlProfile
     */
    public function setRoutingRequestTimer($routingRequestTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($routingRequestTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $routingRequestTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($routingRequestTimer) || (is_array($routingRequestTimer) && empty($routingRequestTimer))) {
            unset($this->routingRequestTimer);
        } else {
            $this->routingRequestTimer = $routingRequestTimer;
        }
        return $this;
    }
    /**
     * Get diversionReroutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDiversionReroutingCssName()
    {
        return isset($this->diversionReroutingCssName) ? $this->diversionReroutingCssName : null;
    }
    /**
     * Set diversionReroutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $diversionReroutingCssName
     * @return \CUCM\StructType\XExternalCallControlProfile
     */
    public function setDiversionReroutingCssName(\CUCM\StructType\XFkType $diversionReroutingCssName = null)
    {
        if (is_null($diversionReroutingCssName) || (is_array($diversionReroutingCssName) && empty($diversionReroutingCssName))) {
            unset($this->diversionReroutingCssName);
        } else {
            $this->diversionReroutingCssName = $diversionReroutingCssName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XExternalCallControlProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
