<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XBLFDirectedCallPark StructType
 * @subpackage Structs
 */
class XBLFDirectedCallPark extends AbstractStructBase
{
    /**
     * The directedCallParkId
     * Meta informations extracted from the WSDL
     * - documentation: Only the uuid attribute is read
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $directedCallParkId;
    /**
     * The directedCallParkDnAndPartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \CUCM\StructType\DirectedCallParkDnAndPartition
     */
    public $directedCallParkDnAndPartition;
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $index;
    /**
     * The label
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $label;
    /**
     * The labelAscii
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $labelAscii;
    /**
     * Constructor method for XBLFDirectedCallPark
     * @uses XBLFDirectedCallPark::setDirectedCallParkId()
     * @uses XBLFDirectedCallPark::setDirectedCallParkDnAndPartition()
     * @uses XBLFDirectedCallPark::setIndex()
     * @uses XBLFDirectedCallPark::setLabel()
     * @uses XBLFDirectedCallPark::setLabelAscii()
     * @param string $directedCallParkId
     * @param \CUCM\StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition
     * @param string $index
     * @param string $label
     * @param string $labelAscii
     */
    public function __construct($directedCallParkId = null, \CUCM\StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition = null, $index = null, $label = null, $labelAscii = null)
    {
        $this
            ->setDirectedCallParkId($directedCallParkId)
            ->setDirectedCallParkDnAndPartition($directedCallParkDnAndPartition)
            ->setIndex($index)
            ->setLabel($label)
            ->setLabelAscii($labelAscii);
    }
    /**
     * Get directedCallParkId value
     * @return string
     */
    public function getDirectedCallParkId()
    {
        return $this->directedCallParkId;
    }
    /**
     * Set directedCallParkId value
     * @param string $directedCallParkId
     * @return \CUCM\StructType\XBLFDirectedCallPark
     */
    public function setDirectedCallParkId($directedCallParkId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($directedCallParkId) && !preg_match('/\\{........-....-....-....-............\\}/', $directedCallParkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($directedCallParkId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($directedCallParkId) && !is_string($directedCallParkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directedCallParkId)), __LINE__);
        }
        $this->directedCallParkId = $directedCallParkId;
        return $this;
    }
    /**
     * Get directedCallParkDnAndPartition value
     * @return \CUCM\StructType\DirectedCallParkDnAndPartition
     */
    public function getDirectedCallParkDnAndPartition()
    {
        return $this->directedCallParkDnAndPartition;
    }
    /**
     * Set directedCallParkDnAndPartition value
     * @param \CUCM\StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition
     * @return \CUCM\StructType\XBLFDirectedCallPark
     */
    public function setDirectedCallParkDnAndPartition(\CUCM\StructType\DirectedCallParkDnAndPartition $directedCallParkDnAndPartition = null)
    {
        $this->directedCallParkDnAndPartition = $directedCallParkDnAndPartition;
        return $this;
    }
    /**
     * Get index value
     * @return string
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \CUCM\StructType\XBLFDirectedCallPark
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \CUCM\StructType\XBLFDirectedCallPark
     */
    public function setLabel($label = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($label) && strlen($label) > 50) || (is_array($label) && count($label) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($label) ? strlen($label) : count($label)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get labelAscii value
     * @return string|null
     */
    public function getLabelAscii()
    {
        return $this->labelAscii;
    }
    /**
     * Set labelAscii value
     * @param string $labelAscii
     * @return \CUCM\StructType\XBLFDirectedCallPark
     */
    public function setLabelAscii($labelAscii = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($labelAscii) && strlen($labelAscii) > 50) || (is_array($labelAscii) && count($labelAscii) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($labelAscii) ? strlen($labelAscii) : count($labelAscii)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($labelAscii) && !is_string($labelAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($labelAscii)), __LINE__);
        }
        $this->labelAscii = $labelAscii;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XBLFDirectedCallPark
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
