<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XApplicationToSoftKeyTemplate StructType
 * @subpackage Structs
 */
class XApplicationToSoftKeyTemplate extends AbstractStructBase
{
    /**
     * The softKeyTemplateName
     * Meta informations extracted from the WSDL
     * - documentation: This template should not be a standard template
     * - minOccurs: 1
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $softKeyTemplateName;
    /**
     * The standardSoftKeyTemplateName
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $standardSoftKeyTemplateName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for XApplicationToSoftKeyTemplate
     * @uses XApplicationToSoftKeyTemplate::setSoftKeyTemplateName()
     * @uses XApplicationToSoftKeyTemplate::setStandardSoftKeyTemplateName()
     * @uses XApplicationToSoftKeyTemplate::setUuid()
     * @param \CUCM\StructType\XFkType $softKeyTemplateName
     * @param \CUCM\StructType\XFkType $standardSoftKeyTemplateName
     * @param string $uuid
     */
    public function __construct(\CUCM\StructType\XFkType $softKeyTemplateName = null, \CUCM\StructType\XFkType $standardSoftKeyTemplateName = null, $uuid = null)
    {
        $this
            ->setSoftKeyTemplateName($softKeyTemplateName)
            ->setStandardSoftKeyTemplateName($standardSoftKeyTemplateName)
            ->setUuid($uuid);
    }
    /**
     * Get softKeyTemplateName value
     * @return \CUCM\StructType\XFkType
     */
    public function getSoftKeyTemplateName()
    {
        return $this->softKeyTemplateName;
    }
    /**
     * Set softKeyTemplateName value
     * @param \CUCM\StructType\XFkType $softKeyTemplateName
     * @return \CUCM\StructType\XApplicationToSoftKeyTemplate
     */
    public function setSoftKeyTemplateName(\CUCM\StructType\XFkType $softKeyTemplateName = null)
    {
        $this->softKeyTemplateName = $softKeyTemplateName;
        return $this;
    }
    /**
     * Get standardSoftKeyTemplateName value
     * @return \CUCM\StructType\XFkType
     */
    public function getStandardSoftKeyTemplateName()
    {
        return $this->standardSoftKeyTemplateName;
    }
    /**
     * Set standardSoftKeyTemplateName value
     * @param \CUCM\StructType\XFkType $standardSoftKeyTemplateName
     * @return \CUCM\StructType\XApplicationToSoftKeyTemplate
     */
    public function setStandardSoftKeyTemplateName(\CUCM\StructType\XFkType $standardSoftKeyTemplateName = null)
    {
        $this->standardSoftKeyTemplateName = $standardSoftKeyTemplateName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\XApplicationToSoftKeyTemplate
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XApplicationToSoftKeyTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
