<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTvsCertificateReq StructType
 * @subpackage Structs
 */
class UpdateTvsCertificateReq extends APIRequest
{
    /**
     * The issuerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $issuerName;
    /**
     * The serialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $serialNumber;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The timeToLive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $timeToLive;
    /**
     * Constructor method for UpdateTvsCertificateReq
     * @uses UpdateTvsCertificateReq::setIssuerName()
     * @uses UpdateTvsCertificateReq::setSerialNumber()
     * @uses UpdateTvsCertificateReq::setUuid()
     * @uses UpdateTvsCertificateReq::setTimeToLive()
     * @param string $issuerName
     * @param string $serialNumber
     * @param string $uuid
     * @param int $timeToLive
     */
    public function __construct($issuerName = null, $serialNumber = null, $uuid = null, $timeToLive = null)
    {
        $this
            ->setIssuerName($issuerName)
            ->setSerialNumber($serialNumber)
            ->setUuid($uuid)
            ->setTimeToLive($timeToLive);
    }
    /**
     * Get issuerName value
     * @return string
     */
    public function getIssuerName()
    {
        return $this->issuerName;
    }
    /**
     * Set issuerName value
     * @param string $issuerName
     * @return \CUCM\StructType\UpdateTvsCertificateReq
     */
    public function setIssuerName($issuerName = null)
    {
        // validation for constraint: string
        if (!is_null($issuerName) && !is_string($issuerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerName)), __LINE__);
        }
        $this->issuerName = $issuerName;
        return $this;
    }
    /**
     * Get serialNumber value
     * @return string
     */
    public function getSerialNumber()
    {
        return $this->serialNumber;
    }
    /**
     * Set serialNumber value
     * @param string $serialNumber
     * @return \CUCM\StructType\UpdateTvsCertificateReq
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->serialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\UpdateTvsCertificateReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get timeToLive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTimeToLive()
    {
        return isset($this->timeToLive) ? $this->timeToLive : null;
    }
    /**
     * Set timeToLive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $timeToLive
     * @return \CUCM\StructType\UpdateTvsCertificateReq
     */
    public function setTimeToLive($timeToLive = null)
    {
        // validation for constraint: int
        if (!is_null($timeToLive) && !is_numeric($timeToLive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timeToLive)), __LINE__);
        }
        if (is_null($timeToLive) || (is_array($timeToLive) && empty($timeToLive))) {
            unset($this->timeToLive);
        } else {
            $this->timeToLive = $timeToLive;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateTvsCertificateReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
