<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateTimeScheduleReq StructType
 * @subpackage Structs
 */
class UpdateTimeScheduleReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The removeMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Members
     */
    public $members;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The timeScheduleCategory
     * Meta informations extracted from the WSDL
     * - default: Regular
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeScheduleCategory;
    /**
     * Constructor method for UpdateTimeScheduleReq
     * @uses UpdateTimeScheduleReq::setNewName()
     * @uses UpdateTimeScheduleReq::setRemoveMembers()
     * @uses UpdateTimeScheduleReq::setAddMembers()
     * @uses UpdateTimeScheduleReq::setMembers()
     * @uses UpdateTimeScheduleReq::setDescription()
     * @uses UpdateTimeScheduleReq::setTimeScheduleCategory()
     * @param string $newName
     * @param \CUCM\StructType\RemoveMembers $removeMembers
     * @param \CUCM\StructType\AddMembers $addMembers
     * @param \CUCM\StructType\Members $members
     * @param string $description
     * @param string $timeScheduleCategory
     */
    public function __construct($newName = null, \CUCM\StructType\RemoveMembers $removeMembers = null, \CUCM\StructType\AddMembers $addMembers = null, \CUCM\StructType\Members $members = null, $description = null, $timeScheduleCategory = 'Regular')
    {
        $this
            ->setNewName($newName)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members)
            ->setDescription($description)
            ->setTimeScheduleCategory($timeScheduleCategory);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateTimeScheduleReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get removeMembers value
     * @return \CUCM\StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return $this->removeMembers;
    }
    /**
     * Set removeMembers value
     * @param \CUCM\StructType\RemoveMembers $removeMembers
     * @return \CUCM\StructType\UpdateTimeScheduleReq
     */
    public function setRemoveMembers(\CUCM\StructType\RemoveMembers $removeMembers = null)
    {
        $this->removeMembers = $removeMembers;
        return $this;
    }
    /**
     * Get addMembers value
     * @return \CUCM\StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return $this->addMembers;
    }
    /**
     * Set addMembers value
     * @param \CUCM\StructType\AddMembers $addMembers
     * @return \CUCM\StructType\UpdateTimeScheduleReq
     */
    public function setAddMembers(\CUCM\StructType\AddMembers $addMembers = null)
    {
        $this->addMembers = $addMembers;
        return $this;
    }
    /**
     * Get members value
     * @return \CUCM\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \CUCM\StructType\Members $members
     * @return \CUCM\StructType\UpdateTimeScheduleReq
     */
    public function setMembers(\CUCM\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateTimeScheduleReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get timeScheduleCategory value
     * @return string|null
     */
    public function getTimeScheduleCategory()
    {
        return $this->timeScheduleCategory;
    }
    /**
     * Set timeScheduleCategory value
     * @uses \CUCM\EnumType\XTimeScheduleCategory::valueIsValid()
     * @uses \CUCM\EnumType\XTimeScheduleCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeScheduleCategory
     * @return \CUCM\StructType\UpdateTimeScheduleReq
     */
    public function setTimeScheduleCategory($timeScheduleCategory = 'Regular')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTimeScheduleCategory::valueIsValid($timeScheduleCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeScheduleCategory, implode(', ', \CUCM\EnumType\XTimeScheduleCategory::getValidValues())), __LINE__);
        }
        $this->timeScheduleCategory = $timeScheduleCategory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateTimeScheduleReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
