<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateServiceParameterReq StructType
 * @subpackage Structs
 */
class UpdateServiceParameterReq extends APIRequest
{
    /**
     * The processNodeName
     * Meta informations extracted from the WSDL
     * - documentation: The process Node that this the service parameter belongs to. Not nullable.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $processNodeName;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Name of the service parameter. Not nullable.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The service
     * Meta informations extracted from the WSDL
     * - documentation: The service that this service parameter belongs to.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $service;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $value;
    /**
     * Constructor method for UpdateServiceParameterReq
     * @uses UpdateServiceParameterReq::setProcessNodeName()
     * @uses UpdateServiceParameterReq::setName()
     * @uses UpdateServiceParameterReq::setService()
     * @uses UpdateServiceParameterReq::setUuid()
     * @uses UpdateServiceParameterReq::setValue()
     * @param \CUCM\StructType\XFkType $processNodeName
     * @param string $name
     * @param string $service
     * @param string $uuid
     * @param string $value
     */
    public function __construct(\CUCM\StructType\XFkType $processNodeName = null, $name = null, $service = null, $uuid = null, $value = null)
    {
        $this
            ->setProcessNodeName($processNodeName)
            ->setName($name)
            ->setService($service)
            ->setUuid($uuid)
            ->setValue($value);
    }
    /**
     * Get processNodeName value
     * @return \CUCM\StructType\XFkType
     */
    public function getProcessNodeName()
    {
        return $this->processNodeName;
    }
    /**
     * Set processNodeName value
     * @param \CUCM\StructType\XFkType $processNodeName
     * @return \CUCM\StructType\UpdateServiceParameterReq
     */
    public function setProcessNodeName(\CUCM\StructType\XFkType $processNodeName = null)
    {
        $this->processNodeName = $processNodeName;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\UpdateServiceParameterReq
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get service value
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @uses \CUCM\EnumType\XService::valueIsValid()
     * @uses \CUCM\EnumType\XService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $service
     * @return \CUCM\StructType\UpdateServiceParameterReq
     */
    public function setService($service = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XService::valueIsValid($service)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $service, implode(', ', \CUCM\EnumType\XService::getValidValues())), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\UpdateServiceParameterReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->value) ? $this->value : null;
    }
    /**
     * Set value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \CUCM\StructType\UpdateServiceParameterReq
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->value);
        } else {
            $this->value = $value;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateServiceParameterReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
