<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSafCcdPurgeBlockLearnedRoutesReq StructType
 * @subpackage Structs
 */
class UpdateSafCcdPurgeBlockLearnedRoutesReq extends APIRequest
{
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The learnedPattern
     * Meta informations extracted from the WSDL
     * - documentation: Either learnedPattern or learnedPatternPrefix has to be set
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $learnedPattern;
    /**
     * The learnedPatternPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $learnedPatternPrefix;
    /**
     * The callControlIdentity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $callControlIdentity;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $ipAddress;
    /**
     * The newLearnedPattern
     * Meta informations extracted from the WSDL
     * - documentation: Either learnedPattern or learnedPatternPrefix has to be set
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newLearnedPattern;
    /**
     * The newLearnedPatternPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newLearnedPatternPrefix;
    /**
     * The newCallControlIdentity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newCallControlIdentity;
    /**
     * The newIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newIpAddress;
    /**
     * Constructor method for UpdateSafCcdPurgeBlockLearnedRoutesReq
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setUuid()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setLearnedPattern()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setLearnedPatternPrefix()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setCallControlIdentity()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setIpAddress()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setNewLearnedPattern()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setNewLearnedPatternPrefix()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setNewCallControlIdentity()
     * @uses UpdateSafCcdPurgeBlockLearnedRoutesReq::setNewIpAddress()
     * @param string $uuid
     * @param string $learnedPattern
     * @param string $learnedPatternPrefix
     * @param string $callControlIdentity
     * @param string $ipAddress
     * @param string $newLearnedPattern
     * @param string $newLearnedPatternPrefix
     * @param string $newCallControlIdentity
     * @param string $newIpAddress
     */
    public function __construct($uuid = null, $learnedPattern = null, $learnedPatternPrefix = null, $callControlIdentity = null, $ipAddress = null, $newLearnedPattern = null, $newLearnedPatternPrefix = null, $newCallControlIdentity = null, $newIpAddress = null)
    {
        $this
            ->setUuid($uuid)
            ->setLearnedPattern($learnedPattern)
            ->setLearnedPatternPrefix($learnedPatternPrefix)
            ->setCallControlIdentity($callControlIdentity)
            ->setIpAddress($ipAddress)
            ->setNewLearnedPattern($newLearnedPattern)
            ->setNewLearnedPatternPrefix($newLearnedPatternPrefix)
            ->setNewCallControlIdentity($newCallControlIdentity)
            ->setNewIpAddress($newIpAddress);
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get learnedPattern value
     * @return string|null
     */
    public function getLearnedPattern()
    {
        return $this->learnedPattern;
    }
    /**
     * Set learnedPattern value
     * @param string $learnedPattern
     * @return \CUCM\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setLearnedPattern($learnedPattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($learnedPattern) && strlen($learnedPattern) > 50) || (is_array($learnedPattern) && count($learnedPattern) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($learnedPattern) ? strlen($learnedPattern) : count($learnedPattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($learnedPattern) && !is_string($learnedPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($learnedPattern)), __LINE__);
        }
        $this->learnedPattern = $learnedPattern;
        return $this;
    }
    /**
     * Get learnedPatternPrefix value
     * @return string|null
     */
    public function getLearnedPatternPrefix()
    {
        return $this->learnedPatternPrefix;
    }
    /**
     * Set learnedPatternPrefix value
     * @param string $learnedPatternPrefix
     * @return \CUCM\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setLearnedPatternPrefix($learnedPatternPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($learnedPatternPrefix) && strlen($learnedPatternPrefix) > 50) || (is_array($learnedPatternPrefix) && count($learnedPatternPrefix) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($learnedPatternPrefix) ? strlen($learnedPatternPrefix) : count($learnedPatternPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($learnedPatternPrefix) && !is_string($learnedPatternPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($learnedPatternPrefix)), __LINE__);
        }
        $this->learnedPatternPrefix = $learnedPatternPrefix;
        return $this;
    }
    /**
     * Get callControlIdentity value
     * @return string|null
     */
    public function getCallControlIdentity()
    {
        return $this->callControlIdentity;
    }
    /**
     * Set callControlIdentity value
     * @param string $callControlIdentity
     * @return \CUCM\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setCallControlIdentity($callControlIdentity = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callControlIdentity) && strlen($callControlIdentity) > 50) || (is_array($callControlIdentity) && count($callControlIdentity) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callControlIdentity) ? strlen($callControlIdentity) : count($callControlIdentity)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callControlIdentity) && !is_string($callControlIdentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callControlIdentity)), __LINE__);
        }
        $this->callControlIdentity = $callControlIdentity;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \CUCM\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ipAddress) && strlen($ipAddress) > 50) || (is_array($ipAddress) && count($ipAddress) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($ipAddress) ? strlen($ipAddress) : count($ipAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get newLearnedPattern value
     * @return string|null
     */
    public function getNewLearnedPattern()
    {
        return $this->newLearnedPattern;
    }
    /**
     * Set newLearnedPattern value
     * @param string $newLearnedPattern
     * @return \CUCM\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setNewLearnedPattern($newLearnedPattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newLearnedPattern) && strlen($newLearnedPattern) > 50) || (is_array($newLearnedPattern) && count($newLearnedPattern) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newLearnedPattern) ? strlen($newLearnedPattern) : count($newLearnedPattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newLearnedPattern) && !is_string($newLearnedPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newLearnedPattern)), __LINE__);
        }
        $this->newLearnedPattern = $newLearnedPattern;
        return $this;
    }
    /**
     * Get newLearnedPatternPrefix value
     * @return string|null
     */
    public function getNewLearnedPatternPrefix()
    {
        return $this->newLearnedPatternPrefix;
    }
    /**
     * Set newLearnedPatternPrefix value
     * @param string $newLearnedPatternPrefix
     * @return \CUCM\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setNewLearnedPatternPrefix($newLearnedPatternPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newLearnedPatternPrefix) && strlen($newLearnedPatternPrefix) > 50) || (is_array($newLearnedPatternPrefix) && count($newLearnedPatternPrefix) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newLearnedPatternPrefix) ? strlen($newLearnedPatternPrefix) : count($newLearnedPatternPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newLearnedPatternPrefix) && !is_string($newLearnedPatternPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newLearnedPatternPrefix)), __LINE__);
        }
        $this->newLearnedPatternPrefix = $newLearnedPatternPrefix;
        return $this;
    }
    /**
     * Get newCallControlIdentity value
     * @return string|null
     */
    public function getNewCallControlIdentity()
    {
        return $this->newCallControlIdentity;
    }
    /**
     * Set newCallControlIdentity value
     * @param string $newCallControlIdentity
     * @return \CUCM\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setNewCallControlIdentity($newCallControlIdentity = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newCallControlIdentity) && strlen($newCallControlIdentity) > 50) || (is_array($newCallControlIdentity) && count($newCallControlIdentity) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newCallControlIdentity) ? strlen($newCallControlIdentity) : count($newCallControlIdentity)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newCallControlIdentity) && !is_string($newCallControlIdentity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newCallControlIdentity)), __LINE__);
        }
        $this->newCallControlIdentity = $newCallControlIdentity;
        return $this;
    }
    /**
     * Get newIpAddress value
     * @return string|null
     */
    public function getNewIpAddress()
    {
        return $this->newIpAddress;
    }
    /**
     * Set newIpAddress value
     * @param string $newIpAddress
     * @return \CUCM\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public function setNewIpAddress($newIpAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newIpAddress) && strlen($newIpAddress) > 50) || (is_array($newIpAddress) && count($newIpAddress) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newIpAddress) ? strlen($newIpAddress) : count($newIpAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newIpAddress) && !is_string($newIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newIpAddress)), __LINE__);
        }
        $this->newIpAddress = $newIpAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
