<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRoutePartitionReq StructType
 * @subpackage Structs
 */
class UpdateRoutePartitionReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The timeScheduleIdName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $timeScheduleIdName;
    /**
     * The useOriginatingDeviceTimeZone
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useOriginatingDeviceTimeZone;
    /**
     * The timeZone
     * Meta informations extracted from the WSDL
     * - default: GMT
     * - documentation: Only Applicable if TimeSchedule is selected. If OriginatingDevice is selected then this tag is not applicable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeZone;
    /**
     * Constructor method for UpdateRoutePartitionReq
     * @uses UpdateRoutePartitionReq::setNewName()
     * @uses UpdateRoutePartitionReq::setDescription()
     * @uses UpdateRoutePartitionReq::setTimeScheduleIdName()
     * @uses UpdateRoutePartitionReq::setUseOriginatingDeviceTimeZone()
     * @uses UpdateRoutePartitionReq::setTimeZone()
     * @param string $newName
     * @param string $description
     * @param \CUCM\StructType\XFkType $timeScheduleIdName
     * @param string $useOriginatingDeviceTimeZone
     * @param string $timeZone
     */
    public function __construct($newName = null, $description = null, \CUCM\StructType\XFkType $timeScheduleIdName = null, $useOriginatingDeviceTimeZone = true, $timeZone = 'GMT')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setTimeScheduleIdName($timeScheduleIdName)
            ->setUseOriginatingDeviceTimeZone($useOriginatingDeviceTimeZone)
            ->setTimeZone($timeZone);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateRoutePartitionReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateRoutePartitionReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get timeScheduleIdName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getTimeScheduleIdName()
    {
        return isset($this->timeScheduleIdName) ? $this->timeScheduleIdName : null;
    }
    /**
     * Set timeScheduleIdName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $timeScheduleIdName
     * @return \CUCM\StructType\UpdateRoutePartitionReq
     */
    public function setTimeScheduleIdName(\CUCM\StructType\XFkType $timeScheduleIdName = null)
    {
        if (is_null($timeScheduleIdName) || (is_array($timeScheduleIdName) && empty($timeScheduleIdName))) {
            unset($this->timeScheduleIdName);
        } else {
            $this->timeScheduleIdName = $timeScheduleIdName;
        }
        return $this;
    }
    /**
     * Get useOriginatingDeviceTimeZone value
     * @return string|null
     */
    public function getUseOriginatingDeviceTimeZone()
    {
        return $this->useOriginatingDeviceTimeZone;
    }
    /**
     * Set useOriginatingDeviceTimeZone value
     * @param string $useOriginatingDeviceTimeZone
     * @return \CUCM\StructType\UpdateRoutePartitionReq
     */
    public function setUseOriginatingDeviceTimeZone($useOriginatingDeviceTimeZone = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useOriginatingDeviceTimeZone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useOriginatingDeviceTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useOriginatingDeviceTimeZone, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useOriginatingDeviceTimeZone) && !is_string($useOriginatingDeviceTimeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useOriginatingDeviceTimeZone)), __LINE__);
        }
        $this->useOriginatingDeviceTimeZone = $useOriginatingDeviceTimeZone;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses \CUCM\EnumType\XTimeZone::valueIsValid()
     * @uses \CUCM\EnumType\XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return \CUCM\StructType\UpdateRoutePartitionReq
     */
    public function setTimeZone($timeZone = 'GMT')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeZone, implode(', ', \CUCM\EnumType\XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateRoutePartitionReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
