<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRemoteDestinationReq StructType
 * @subpackage Structs
 */
class UpdateRemoteDestinationReq extends APIRequest
{
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $destination;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The newDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newDestination;
    /**
     * The answerTooSoonTimer
     * Meta informations extracted from the WSDL
     * - default: 1500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $answerTooSoonTimer;
    /**
     * The answerTooLateTimer
     * Meta informations extracted from the WSDL
     * - default: 19000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $answerTooLateTimer;
    /**
     * The delayBeforeRingingCell
     * Meta informations extracted from the WSDL
     * - default: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $delayBeforeRingingCell;
    /**
     * The isMobilePhone
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isMobilePhone;
    /**
     * The enableMobileConnect
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileConnect;
    /**
     * The lineAssociations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\LineAssociations
     */
    public $lineAssociations;
    /**
     * The timeZone
     * Meta informations extracted from the WSDL
     * - default: GMT
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeZone;
    /**
     * The todAccessName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $todAccessName;
    /**
     * The mobileSmartClientName
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not applicable for dualmode phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $mobileSmartClientName;
    /**
     * The mobilityProfileName
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable only to CUMC devices.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $mobilityProfileName;
    /**
     * Constructor method for UpdateRemoteDestinationReq
     * @uses UpdateRemoteDestinationReq::setDestination()
     * @uses UpdateRemoteDestinationReq::setUuid()
     * @uses UpdateRemoteDestinationReq::setNewName()
     * @uses UpdateRemoteDestinationReq::setNewDestination()
     * @uses UpdateRemoteDestinationReq::setAnswerTooSoonTimer()
     * @uses UpdateRemoteDestinationReq::setAnswerTooLateTimer()
     * @uses UpdateRemoteDestinationReq::setDelayBeforeRingingCell()
     * @uses UpdateRemoteDestinationReq::setIsMobilePhone()
     * @uses UpdateRemoteDestinationReq::setEnableMobileConnect()
     * @uses UpdateRemoteDestinationReq::setLineAssociations()
     * @uses UpdateRemoteDestinationReq::setTimeZone()
     * @uses UpdateRemoteDestinationReq::setTodAccessName()
     * @uses UpdateRemoteDestinationReq::setMobileSmartClientName()
     * @uses UpdateRemoteDestinationReq::setMobilityProfileName()
     * @param string $destination
     * @param string $uuid
     * @param string $newName
     * @param string $newDestination
     * @param string $answerTooSoonTimer
     * @param string $answerTooLateTimer
     * @param string $delayBeforeRingingCell
     * @param string $isMobilePhone
     * @param string $enableMobileConnect
     * @param \CUCM\StructType\LineAssociations $lineAssociations
     * @param string $timeZone
     * @param \CUCM\StructType\XFkType $todAccessName
     * @param \CUCM\StructType\XFkType $mobileSmartClientName
     * @param \CUCM\StructType\XFkType $mobilityProfileName
     */
    public function __construct($destination = null, $uuid = null, $newName = null, $newDestination = null, $answerTooSoonTimer = '1500', $answerTooLateTimer = '19000', $delayBeforeRingingCell = '4000', $isMobilePhone = false, $enableMobileConnect = true, \CUCM\StructType\LineAssociations $lineAssociations = null, $timeZone = 'GMT', \CUCM\StructType\XFkType $todAccessName = null, \CUCM\StructType\XFkType $mobileSmartClientName = null, \CUCM\StructType\XFkType $mobilityProfileName = null)
    {
        $this
            ->setDestination($destination)
            ->setUuid($uuid)
            ->setNewName($newName)
            ->setNewDestination($newDestination)
            ->setAnswerTooSoonTimer($answerTooSoonTimer)
            ->setAnswerTooLateTimer($answerTooLateTimer)
            ->setDelayBeforeRingingCell($delayBeforeRingingCell)
            ->setIsMobilePhone($isMobilePhone)
            ->setEnableMobileConnect($enableMobileConnect)
            ->setLineAssociations($lineAssociations)
            ->setTimeZone($timeZone)
            ->setTodAccessName($todAccessName)
            ->setMobileSmartClientName($mobileSmartClientName)
            ->setMobilityProfileName($mobilityProfileName);
    }
    /**
     * Get destination value
     * @return string
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get newDestination value
     * @return string|null
     */
    public function getNewDestination()
    {
        return $this->newDestination;
    }
    /**
     * Set newDestination value
     * @param string $newDestination
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public function setNewDestination($newDestination = null)
    {
        // validation for constraint: string
        if (!is_null($newDestination) && !is_string($newDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newDestination)), __LINE__);
        }
        $this->newDestination = $newDestination;
        return $this;
    }
    /**
     * Get answerTooSoonTimer value
     * @return string|null
     */
    public function getAnswerTooSoonTimer()
    {
        return $this->answerTooSoonTimer;
    }
    /**
     * Set answerTooSoonTimer value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answerTooSoonTimer
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public function setAnswerTooSoonTimer($answerTooSoonTimer = '1500')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($answerTooSoonTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $answerTooSoonTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->answerTooSoonTimer = $answerTooSoonTimer;
        return $this;
    }
    /**
     * Get answerTooLateTimer value
     * @return string|null
     */
    public function getAnswerTooLateTimer()
    {
        return $this->answerTooLateTimer;
    }
    /**
     * Set answerTooLateTimer value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answerTooLateTimer
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public function setAnswerTooLateTimer($answerTooLateTimer = '19000')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($answerTooLateTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $answerTooLateTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->answerTooLateTimer = $answerTooLateTimer;
        return $this;
    }
    /**
     * Get delayBeforeRingingCell value
     * @return string|null
     */
    public function getDelayBeforeRingingCell()
    {
        return $this->delayBeforeRingingCell;
    }
    /**
     * Set delayBeforeRingingCell value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $delayBeforeRingingCell
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public function setDelayBeforeRingingCell($delayBeforeRingingCell = '4000')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($delayBeforeRingingCell)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $delayBeforeRingingCell, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->delayBeforeRingingCell = $delayBeforeRingingCell;
        return $this;
    }
    /**
     * Get isMobilePhone value
     * @return string|null
     */
    public function getIsMobilePhone()
    {
        return $this->isMobilePhone;
    }
    /**
     * Set isMobilePhone value
     * @param string $isMobilePhone
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public function setIsMobilePhone($isMobilePhone = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isMobilePhone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isMobilePhone, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isMobilePhone) && !is_string($isMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isMobilePhone)), __LINE__);
        }
        $this->isMobilePhone = $isMobilePhone;
        return $this;
    }
    /**
     * Get enableMobileConnect value
     * @return string|null
     */
    public function getEnableMobileConnect()
    {
        return $this->enableMobileConnect;
    }
    /**
     * Set enableMobileConnect value
     * @param string $enableMobileConnect
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public function setEnableMobileConnect($enableMobileConnect = true)
    {
        // validation for constraint: pattern
        if (is_scalar($enableMobileConnect) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobileConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableMobileConnect, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableMobileConnect) && !is_string($enableMobileConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableMobileConnect)), __LINE__);
        }
        $this->enableMobileConnect = $enableMobileConnect;
        return $this;
    }
    /**
     * Get lineAssociations value
     * @return \CUCM\StructType\LineAssociations|null
     */
    public function getLineAssociations()
    {
        return $this->lineAssociations;
    }
    /**
     * Set lineAssociations value
     * @param \CUCM\StructType\LineAssociations $lineAssociations
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public function setLineAssociations(\CUCM\StructType\LineAssociations $lineAssociations = null)
    {
        $this->lineAssociations = $lineAssociations;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses \CUCM\EnumType\XTimeZone::valueIsValid()
     * @uses \CUCM\EnumType\XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public function setTimeZone($timeZone = 'GMT')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeZone, implode(', ', \CUCM\EnumType\XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get todAccessName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getTodAccessName()
    {
        return isset($this->todAccessName) ? $this->todAccessName : null;
    }
    /**
     * Set todAccessName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $todAccessName
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public function setTodAccessName(\CUCM\StructType\XFkType $todAccessName = null)
    {
        if (is_null($todAccessName) || (is_array($todAccessName) && empty($todAccessName))) {
            unset($this->todAccessName);
        } else {
            $this->todAccessName = $todAccessName;
        }
        return $this;
    }
    /**
     * Get mobileSmartClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getMobileSmartClientName()
    {
        return isset($this->mobileSmartClientName) ? $this->mobileSmartClientName : null;
    }
    /**
     * Set mobileSmartClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $mobileSmartClientName
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public function setMobileSmartClientName(\CUCM\StructType\XFkType $mobileSmartClientName = null)
    {
        if (is_null($mobileSmartClientName) || (is_array($mobileSmartClientName) && empty($mobileSmartClientName))) {
            unset($this->mobileSmartClientName);
        } else {
            $this->mobileSmartClientName = $mobileSmartClientName;
        }
        return $this;
    }
    /**
     * Get mobilityProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getMobilityProfileName()
    {
        return isset($this->mobilityProfileName) ? $this->mobilityProfileName : null;
    }
    /**
     * Set mobilityProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $mobilityProfileName
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public function setMobilityProfileName(\CUCM\StructType\XFkType $mobilityProfileName = null)
    {
        if (is_null($mobilityProfileName) || (is_array($mobilityProfileName) && empty($mobilityProfileName))) {
            unset($this->mobilityProfileName);
        } else {
            $this->mobilityProfileName = $mobilityProfileName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateRemoteDestinationReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
