<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRegionMatrixReq StructType
 * @subpackage Structs
 */
class UpdateRegionMatrixReq extends APIRequest
{
    /**
     * The regionAName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $regionAName;
    /**
     * The regionBName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $regionBName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The bandwidth
     * Meta informations extracted from the WSDL
     * - documentation: The new bandwidth value for this particular region relationship.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $bandwidth;
    /**
     * The videoBandwidth
     * Meta informations extracted from the WSDL
     * - default: 384
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $videoBandwidth;
    /**
     * The lossyNetwork
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $lossyNetwork;
    /**
     * Constructor method for UpdateRegionMatrixReq
     * @uses UpdateRegionMatrixReq::setRegionAName()
     * @uses UpdateRegionMatrixReq::setRegionBName()
     * @uses UpdateRegionMatrixReq::setUuid()
     * @uses UpdateRegionMatrixReq::setBandwidth()
     * @uses UpdateRegionMatrixReq::setVideoBandwidth()
     * @uses UpdateRegionMatrixReq::setLossyNetwork()
     * @param \CUCM\StructType\XFkType $regionAName
     * @param \CUCM\StructType\XFkType $regionBName
     * @param string $uuid
     * @param string $bandwidth
     * @param string $videoBandwidth
     * @param string $lossyNetwork
     */
    public function __construct(\CUCM\StructType\XFkType $regionAName = null, \CUCM\StructType\XFkType $regionBName = null, $uuid = null, $bandwidth = null, $videoBandwidth = '384', $lossyNetwork = 'Use System Default')
    {
        $this
            ->setRegionAName($regionAName)
            ->setRegionBName($regionBName)
            ->setUuid($uuid)
            ->setBandwidth($bandwidth)
            ->setVideoBandwidth($videoBandwidth)
            ->setLossyNetwork($lossyNetwork);
    }
    /**
     * Get regionAName value
     * @return \CUCM\StructType\XFkType
     */
    public function getRegionAName()
    {
        return $this->regionAName;
    }
    /**
     * Set regionAName value
     * @param \CUCM\StructType\XFkType $regionAName
     * @return \CUCM\StructType\UpdateRegionMatrixReq
     */
    public function setRegionAName(\CUCM\StructType\XFkType $regionAName = null)
    {
        $this->regionAName = $regionAName;
        return $this;
    }
    /**
     * Get regionBName value
     * @return \CUCM\StructType\XFkType
     */
    public function getRegionBName()
    {
        return $this->regionBName;
    }
    /**
     * Set regionBName value
     * @param \CUCM\StructType\XFkType $regionBName
     * @return \CUCM\StructType\UpdateRegionMatrixReq
     */
    public function setRegionBName(\CUCM\StructType\XFkType $regionBName = null)
    {
        $this->regionBName = $regionBName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\UpdateRegionMatrixReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get bandwidth value
     * @return string|null
     */
    public function getBandwidth()
    {
        return $this->bandwidth;
    }
    /**
     * Set bandwidth value
     * @uses \CUCM\EnumType\XBandwidth::valueIsValid()
     * @uses \CUCM\EnumType\XBandwidth::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $bandwidth
     * @return \CUCM\StructType\UpdateRegionMatrixReq
     */
    public function setBandwidth($bandwidth = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XBandwidth::valueIsValid($bandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $bandwidth, implode(', ', \CUCM\EnumType\XBandwidth::getValidValues())), __LINE__);
        }
        $this->bandwidth = $bandwidth;
        return $this;
    }
    /**
     * Get videoBandwidth value
     * @return string|null
     */
    public function getVideoBandwidth()
    {
        return $this->videoBandwidth;
    }
    /**
     * Set videoBandwidth value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoBandwidth
     * @return \CUCM\StructType\UpdateRegionMatrixReq
     */
    public function setVideoBandwidth($videoBandwidth = '384')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($videoBandwidth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $videoBandwidth, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->videoBandwidth = $videoBandwidth;
        return $this;
    }
    /**
     * Get lossyNetwork value
     * @return string|null
     */
    public function getLossyNetwork()
    {
        return $this->lossyNetwork;
    }
    /**
     * Set lossyNetwork value
     * @uses \CUCM\EnumType\XLossyNetwork::valueIsValid()
     * @uses \CUCM\EnumType\XLossyNetwork::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lossyNetwork
     * @return \CUCM\StructType\UpdateRegionMatrixReq
     */
    public function setLossyNetwork($lossyNetwork = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XLossyNetwork::valueIsValid($lossyNetwork)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lossyNetwork, implode(', ', \CUCM\EnumType\XLossyNetwork::getValidValues())), __LINE__);
        }
        $this->lossyNetwork = $lossyNetwork;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateRegionMatrixReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
