<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMohServerReq StructType
 * @subpackage Structs
 */
class UpdateMohServerReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $locationName;
    /**
     * The maxUnicastConnections
     * Meta informations extracted from the WSDL
     * - default: 250
     * - documentation: Maximum Half Duplex Streams must be a number in the range 0 to 500.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxUnicastConnections;
    /**
     * The maxMulticastConnections
     * Meta informations extracted from the WSDL
     * - default: 250000
     * - documentation: Maximum Multicast Connections must be a number in the range 0 to 999999.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maxMulticastConnections;
    /**
     * The fixedAudioSourceDevice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $fixedAudioSourceDevice;
    /**
     * The runFlag
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $runFlag;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The isMultiCastEnabled
     * Meta informations extracted from the WSDL
     * - documentation: If isMultiCastEnabled is false then these elements are not necessary.MOHServer will be added to the database without the values of these tags. ie. The table MOHServerMulticastInfo table will be empty. Multicast Base Port number must
     * be an even number in the range 16384 to 32766.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isMultiCastEnabled;
    /**
     * The baseMulticastIpaddress
     * Meta informations extracted from the WSDL
     * - default: 239.1.1.1
     * - documentation: If isMultiCastEnabled is false then these elements are not necessary.MOHServer will be added to the database without the values of these tags. ie. The table MOHServerMulticastInfo table will be empty. Multicast Base Port number must
     * be an even number in the range 16384 to 32766. baseMulticastIPAddress and baseMulticastPort must be a unique pair. All Multicast IP Addresses must be in the range 239.1.1.1 to 239.255.255.255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $baseMulticastIpaddress;
    /**
     * The baseMulticastPort
     * Meta informations extracted from the WSDL
     * - default: 0
     * - documentation: If isMultiCastEnabled is false then these elements are not necessary.MOHServer will be added to the database without the values of these tags. ie. The table MOHServerMulticastInfo table will be empty. Multicast Base Port number must
     * be an even number in the range 16384 to 32766
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $baseMulticastPort;
    /**
     * The multicastIncrementOnIp
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: If isMultiCastEnabled is false then these elements are not necessary.MOHServer will be added to the database without the values of these tags. ie. The table MOHServerMulticastInfo table will be empty.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicastIncrementOnIp;
    /**
     * The audioSources
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AudioSources
     */
    public $audioSources;
    /**
     * Constructor method for UpdateMohServerReq
     * @uses UpdateMohServerReq::setNewName()
     * @uses UpdateMohServerReq::setDescription()
     * @uses UpdateMohServerReq::setDevicePoolName()
     * @uses UpdateMohServerReq::setLocationName()
     * @uses UpdateMohServerReq::setMaxUnicastConnections()
     * @uses UpdateMohServerReq::setMaxMulticastConnections()
     * @uses UpdateMohServerReq::setFixedAudioSourceDevice()
     * @uses UpdateMohServerReq::setRunFlag()
     * @uses UpdateMohServerReq::setUseTrustedRelayPoint()
     * @uses UpdateMohServerReq::setIsMultiCastEnabled()
     * @uses UpdateMohServerReq::setBaseMulticastIpaddress()
     * @uses UpdateMohServerReq::setBaseMulticastPort()
     * @uses UpdateMohServerReq::setMulticastIncrementOnIp()
     * @uses UpdateMohServerReq::setAudioSources()
     * @param string $newName
     * @param string $description
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @param \CUCM\StructType\XFkType $locationName
     * @param string $maxUnicastConnections
     * @param string $maxMulticastConnections
     * @param string $fixedAudioSourceDevice
     * @param string $runFlag
     * @param string $useTrustedRelayPoint
     * @param string $isMultiCastEnabled
     * @param string $baseMulticastIpaddress
     * @param string $baseMulticastPort
     * @param string $multicastIncrementOnIp
     * @param \CUCM\StructType\AudioSources $audioSources
     */
    public function __construct($newName = null, $description = null, \CUCM\StructType\XFkType $devicePoolName = null, \CUCM\StructType\XFkType $locationName = null, $maxUnicastConnections = '250', $maxMulticastConnections = '250000', $fixedAudioSourceDevice = null, $runFlag = true, $useTrustedRelayPoint = 'Default', $isMultiCastEnabled = null, $baseMulticastIpaddress = '239.1.1.1', $baseMulticastPort = '0', $multicastIncrementOnIp = false, \CUCM\StructType\AudioSources $audioSources = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setDevicePoolName($devicePoolName)
            ->setLocationName($locationName)
            ->setMaxUnicastConnections($maxUnicastConnections)
            ->setMaxMulticastConnections($maxMulticastConnections)
            ->setFixedAudioSourceDevice($fixedAudioSourceDevice)
            ->setRunFlag($runFlag)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setIsMultiCastEnabled($isMultiCastEnabled)
            ->setBaseMulticastIpaddress($baseMulticastIpaddress)
            ->setBaseMulticastPort($baseMulticastPort)
            ->setMulticastIncrementOnIp($multicastIncrementOnIp)
            ->setAudioSources($audioSources);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get devicePoolName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return isset($this->devicePoolName) ? $this->devicePoolName : null;
    }
    /**
     * Set devicePoolName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public function setDevicePoolName(\CUCM\StructType\XFkType $devicePoolName = null)
    {
        if (is_null($devicePoolName) || (is_array($devicePoolName) && empty($devicePoolName))) {
            unset($this->devicePoolName);
        } else {
            $this->devicePoolName = $devicePoolName;
        }
        return $this;
    }
    /**
     * Get locationName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \CUCM\StructType\XFkType $locationName
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public function setLocationName(\CUCM\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get maxUnicastConnections value
     * @return string|null
     */
    public function getMaxUnicastConnections()
    {
        return $this->maxUnicastConnections;
    }
    /**
     * Set maxUnicastConnections value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxUnicastConnections
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public function setMaxUnicastConnections($maxUnicastConnections = '250')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($maxUnicastConnections)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxUnicastConnections, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxUnicastConnections = $maxUnicastConnections;
        return $this;
    }
    /**
     * Get maxMulticastConnections value
     * @return string|null
     */
    public function getMaxMulticastConnections()
    {
        return $this->maxMulticastConnections;
    }
    /**
     * Set maxMulticastConnections value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxMulticastConnections
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public function setMaxMulticastConnections($maxMulticastConnections = '250000')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($maxMulticastConnections)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxMulticastConnections, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxMulticastConnections = $maxMulticastConnections;
        return $this;
    }
    /**
     * Get fixedAudioSourceDevice value
     * @return string|null
     */
    public function getFixedAudioSourceDevice()
    {
        return $this->fixedAudioSourceDevice;
    }
    /**
     * Set fixedAudioSourceDevice value
     * @param string $fixedAudioSourceDevice
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public function setFixedAudioSourceDevice($fixedAudioSourceDevice = null)
    {
        // validation for constraint: string
        if (!is_null($fixedAudioSourceDevice) && !is_string($fixedAudioSourceDevice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fixedAudioSourceDevice)), __LINE__);
        }
        $this->fixedAudioSourceDevice = $fixedAudioSourceDevice;
        return $this;
    }
    /**
     * Get runFlag value
     * @return string|null
     */
    public function getRunFlag()
    {
        return $this->runFlag;
    }
    /**
     * Set runFlag value
     * @param string $runFlag
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public function setRunFlag($runFlag = true)
    {
        // validation for constraint: pattern
        if (is_scalar($runFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $runFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($runFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($runFlag) && !is_string($runFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runFlag)), __LINE__);
        }
        $this->runFlag = $runFlag;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get isMultiCastEnabled value
     * @return string|null
     */
    public function getIsMultiCastEnabled()
    {
        return $this->isMultiCastEnabled;
    }
    /**
     * Set isMultiCastEnabled value
     * @param string $isMultiCastEnabled
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public function setIsMultiCastEnabled($isMultiCastEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isMultiCastEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isMultiCastEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isMultiCastEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isMultiCastEnabled) && !is_string($isMultiCastEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isMultiCastEnabled)), __LINE__);
        }
        $this->isMultiCastEnabled = $isMultiCastEnabled;
        return $this;
    }
    /**
     * Get baseMulticastIpaddress value
     * @return string|null
     */
    public function getBaseMulticastIpaddress()
    {
        return $this->baseMulticastIpaddress;
    }
    /**
     * Set baseMulticastIpaddress value
     * @param string $baseMulticastIpaddress
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public function setBaseMulticastIpaddress($baseMulticastIpaddress = '239.1.1.1')
    {
        // validation for constraint: string
        if (!is_null($baseMulticastIpaddress) && !is_string($baseMulticastIpaddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($baseMulticastIpaddress)), __LINE__);
        }
        $this->baseMulticastIpaddress = $baseMulticastIpaddress;
        return $this;
    }
    /**
     * Get baseMulticastPort value
     * @return string|null
     */
    public function getBaseMulticastPort()
    {
        return $this->baseMulticastPort;
    }
    /**
     * Set baseMulticastPort value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $baseMulticastPort
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public function setBaseMulticastPort($baseMulticastPort = '0')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($baseMulticastPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $baseMulticastPort, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->baseMulticastPort = $baseMulticastPort;
        return $this;
    }
    /**
     * Get multicastIncrementOnIp value
     * @return string|null
     */
    public function getMulticastIncrementOnIp()
    {
        return $this->multicastIncrementOnIp;
    }
    /**
     * Set multicastIncrementOnIp value
     * @param string $multicastIncrementOnIp
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public function setMulticastIncrementOnIp($multicastIncrementOnIp = false)
    {
        // validation for constraint: pattern
        if (is_scalar($multicastIncrementOnIp) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $multicastIncrementOnIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($multicastIncrementOnIp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($multicastIncrementOnIp) && !is_string($multicastIncrementOnIp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($multicastIncrementOnIp)), __LINE__);
        }
        $this->multicastIncrementOnIp = $multicastIncrementOnIp;
        return $this;
    }
    /**
     * Get audioSources value
     * @return \CUCM\StructType\AudioSources|null
     */
    public function getAudioSources()
    {
        return $this->audioSources;
    }
    /**
     * Set audioSources value
     * @param \CUCM\StructType\AudioSources $audioSources
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public function setAudioSources(\CUCM\StructType\AudioSources $audioSources = null)
    {
        $this->audioSources = $audioSources;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateMohServerReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
