<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMlppDomainReq StructType
 * @subpackage Structs
 */
class UpdateMlppDomainReq extends APIRequest
{
    /**
     * The domainName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newDomainName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newDomainName;
    /**
     * The domainId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $domainId;
    /**
     * Constructor method for UpdateMlppDomainReq
     * @uses UpdateMlppDomainReq::setDomainName()
     * @uses UpdateMlppDomainReq::setUuid()
     * @uses UpdateMlppDomainReq::setNewDomainName()
     * @uses UpdateMlppDomainReq::setDomainId()
     * @param string $domainName
     * @param string $uuid
     * @param string $newDomainName
     * @param string $domainId
     */
    public function __construct($domainName = null, $uuid = null, $newDomainName = null, $domainId = null)
    {
        $this
            ->setDomainName($domainName)
            ->setUuid($uuid)
            ->setNewDomainName($newDomainName)
            ->setDomainId($domainId);
    }
    /**
     * Get domainName value
     * @return string
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return \CUCM\StructType\UpdateMlppDomainReq
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\UpdateMlppDomainReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get newDomainName value
     * @return string|null
     */
    public function getNewDomainName()
    {
        return $this->newDomainName;
    }
    /**
     * Set newDomainName value
     * @param string $newDomainName
     * @return \CUCM\StructType\UpdateMlppDomainReq
     */
    public function setNewDomainName($newDomainName = null)
    {
        // validation for constraint: string
        if (!is_null($newDomainName) && !is_string($newDomainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newDomainName)), __LINE__);
        }
        $this->newDomainName = $newDomainName;
        return $this;
    }
    /**
     * Get domainId value
     * @return string|null
     */
    public function getDomainId()
    {
        return $this->domainId;
    }
    /**
     * Set domainId value
     * @param string $domainId
     * @return \CUCM\StructType\UpdateMlppDomainReq
     */
    public function setDomainId($domainId = null)
    {
        // validation for constraint: string
        if (!is_null($domainId) && !is_string($domainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainId)), __LINE__);
        }
        $this->domainId = $domainId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateMlppDomainReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
