<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMeetMeReq StructType
 * @subpackage Structs
 */
class UpdateMeetMeReq extends APIRequest
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The newPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The newRoutePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $newRoutePartitionName;
    /**
     * The minimumSecurityLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $minimumSecurityLevel;
    /**
     * Constructor method for UpdateMeetMeReq
     * @uses UpdateMeetMeReq::setPattern()
     * @uses UpdateMeetMeReq::setUuid()
     * @uses UpdateMeetMeReq::setRoutePartitionName()
     * @uses UpdateMeetMeReq::setNewPattern()
     * @uses UpdateMeetMeReq::setDescription()
     * @uses UpdateMeetMeReq::setNewRoutePartitionName()
     * @uses UpdateMeetMeReq::setMinimumSecurityLevel()
     * @param string $pattern
     * @param string $uuid
     * @param \CUCM\StructType\XFkType $routePartitionName
     * @param string $newPattern
     * @param string $description
     * @param \CUCM\StructType\XFkType $newRoutePartitionName
     * @param string $minimumSecurityLevel
     */
    public function __construct($pattern = null, $uuid = null, \CUCM\StructType\XFkType $routePartitionName = null, $newPattern = null, $description = null, \CUCM\StructType\XFkType $newRoutePartitionName = null, $minimumSecurityLevel = null)
    {
        $this
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setRoutePartitionName($routePartitionName)
            ->setNewPattern($newPattern)
            ->setDescription($description)
            ->setNewRoutePartitionName($newRoutePartitionName)
            ->setMinimumSecurityLevel($minimumSecurityLevel);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \CUCM\StructType\UpdateMeetMeReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\UpdateMeetMeReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $routePartitionName
     * @return \CUCM\StructType\UpdateMeetMeReq
     */
    public function setRoutePartitionName(\CUCM\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \CUCM\StructType\UpdateMeetMeReq
     */
    public function setNewPattern($newPattern = null)
    {
        // validation for constraint: string
        if (!is_null($newPattern) && !is_string($newPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPattern)), __LINE__);
        }
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateMeetMeReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get newRoutePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getNewRoutePartitionName()
    {
        return isset($this->newRoutePartitionName) ? $this->newRoutePartitionName : null;
    }
    /**
     * Set newRoutePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $newRoutePartitionName
     * @return \CUCM\StructType\UpdateMeetMeReq
     */
    public function setNewRoutePartitionName(\CUCM\StructType\XFkType $newRoutePartitionName = null)
    {
        if (is_null($newRoutePartitionName) || (is_array($newRoutePartitionName) && empty($newRoutePartitionName))) {
            unset($this->newRoutePartitionName);
        } else {
            $this->newRoutePartitionName = $newRoutePartitionName;
        }
        return $this;
    }
    /**
     * Get minimumSecurityLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinimumSecurityLevel()
    {
        return isset($this->minimumSecurityLevel) ? $this->minimumSecurityLevel : null;
    }
    /**
     * Set minimumSecurityLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XDeviceSecurityMode::valueIsValid()
     * @uses \CUCM\EnumType\XDeviceSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $minimumSecurityLevel
     * @return \CUCM\StructType\UpdateMeetMeReq
     */
    public function setMinimumSecurityLevel($minimumSecurityLevel = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDeviceSecurityMode::valueIsValid($minimumSecurityLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $minimumSecurityLevel, implode(', ', \CUCM\EnumType\XDeviceSecurityMode::getValidValues())), __LINE__);
        }
        if (is_null($minimumSecurityLevel) || (is_array($minimumSecurityLevel) && empty($minimumSecurityLevel))) {
            unset($this->minimumSecurityLevel);
        } else {
            $this->minimumSecurityLevel = $minimumSecurityLevel;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateMeetMeReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
