<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateMediaResourceGroupReq StructType
 * @subpackage Structs
 */
class UpdateMediaResourceGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * The multicast
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicast;
    /**
     * The removeMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Members
     */
    public $members;
    /**
     * Constructor method for UpdateMediaResourceGroupReq
     * @uses UpdateMediaResourceGroupReq::setNewName()
     * @uses UpdateMediaResourceGroupReq::setDescription()
     * @uses UpdateMediaResourceGroupReq::setMulticast()
     * @uses UpdateMediaResourceGroupReq::setRemoveMembers()
     * @uses UpdateMediaResourceGroupReq::setAddMembers()
     * @uses UpdateMediaResourceGroupReq::setMembers()
     * @param string $newName
     * @param string $description
     * @param string $multicast
     * @param \CUCM\StructType\RemoveMembers $removeMembers
     * @param \CUCM\StructType\AddMembers $addMembers
     * @param \CUCM\StructType\Members $members
     */
    public function __construct($newName = null, $description = null, $multicast = null, \CUCM\StructType\RemoveMembers $removeMembers = null, \CUCM\StructType\AddMembers $addMembers = null, \CUCM\StructType\Members $members = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setMulticast($multicast)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateMediaResourceGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateMediaResourceGroupReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get multicast value
     * @return string|null
     */
    public function getMulticast()
    {
        return $this->multicast;
    }
    /**
     * Set multicast value
     * @param string $multicast
     * @return \CUCM\StructType\UpdateMediaResourceGroupReq
     */
    public function setMulticast($multicast = null)
    {
        // validation for constraint: pattern
        if (is_scalar($multicast) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($multicast, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($multicast) && !is_string($multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($multicast)), __LINE__);
        }
        $this->multicast = $multicast;
        return $this;
    }
    /**
     * Get removeMembers value
     * @return \CUCM\StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return $this->removeMembers;
    }
    /**
     * Set removeMembers value
     * @param \CUCM\StructType\RemoveMembers $removeMembers
     * @return \CUCM\StructType\UpdateMediaResourceGroupReq
     */
    public function setRemoveMembers(\CUCM\StructType\RemoveMembers $removeMembers = null)
    {
        $this->removeMembers = $removeMembers;
        return $this;
    }
    /**
     * Get addMembers value
     * @return \CUCM\StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return $this->addMembers;
    }
    /**
     * Set addMembers value
     * @param \CUCM\StructType\AddMembers $addMembers
     * @return \CUCM\StructType\UpdateMediaResourceGroupReq
     */
    public function setAddMembers(\CUCM\StructType\AddMembers $addMembers = null)
    {
        $this->addMembers = $addMembers;
        return $this;
    }
    /**
     * Get members value
     * @return \CUCM\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \CUCM\StructType\Members $members
     * @return \CUCM\StructType\UpdateMediaResourceGroupReq
     */
    public function setMembers(\CUCM\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateMediaResourceGroupReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
