<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLineReq StructType
 * @subpackage Structs
 */
class UpdateLineReq extends APIRequest
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The newPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The newRoutePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $newRoutePartitionName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The aarDestinationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $aarDestinationMask;
    /**
     * The aarKeepCallHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $aarKeepCallHistory;
    /**
     * The aarVoiceMailEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $aarVoiceMailEnabled;
    /**
     * The callForwardAll
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XCallForwardAll
     */
    public $callForwardAll;
    /**
     * The callForwardBusy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XCallForwardBusy
     */
    public $callForwardBusy;
    /**
     * The callForwardBusyInt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XCallForwardBusyInt
     */
    public $callForwardBusyInt;
    /**
     * The callForwardNoAnswer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XCallForwardNoAnswer
     */
    public $callForwardNoAnswer;
    /**
     * The callForwardNoAnswerInt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XCallForwardNoAnswerInt
     */
    public $callForwardNoAnswerInt;
    /**
     * The callForwardNoCoverage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XCallForwardNoCoverage
     */
    public $callForwardNoCoverage;
    /**
     * The callForwardNoCoverageInt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XCallForwardNoCoverageInt
     */
    public $callForwardNoCoverageInt;
    /**
     * The callForwardOnFailure
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XCallForwardOnFailure
     */
    public $callForwardOnFailure;
    /**
     * The callForwardAlternateParty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XCallForwardAlternateParty
     */
    public $callForwardAlternateParty;
    /**
     * The callForwardNotRegistered
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XCallForwardNotRegistered
     */
    public $callForwardNotRegistered;
    /**
     * The callForwardNotRegisteredInt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XCallForwardNotRegisteredInt
     */
    public $callForwardNotRegisteredInt;
    /**
     * The callPickupGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $callPickupGroupName;
    /**
     * The autoAnswer
     * Meta informations extracted from the WSDL
     * - default: Auto Answer Off
     * - documentation: For an intercom line this tag should be treated as a mandatory tag and the valid values are Auto Answer with Headset and Auto Answer with Speakerphone.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $autoAnswer;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: A value of 0 means 'none selected'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The alertingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $alertingName;
    /**
     * The asciiAlertingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 32
     * @var string
     */
    public $asciiAlertingName;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The shareLineAppearanceCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $shareLineAppearanceCssName;
    /**
     * The voiceMailProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $voiceMailProfileName;
    /**
     * The patternPrecedence
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $patternPrecedence;
    /**
     * The releaseClause
     * Meta informations extracted from the WSDL
     * - default: No Error
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $releaseClause;
    /**
     * The hrDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $hrDuration;
    /**
     * The hrInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $hrInterval;
    /**
     * The cfaCssPolicy
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $cfaCssPolicy;
    /**
     * The defaultActivatedDeviceName
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable for only intercom lines and if not set, intercom lines will not be active.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $defaultActivatedDeviceName;
    /**
     * The parkMonForwardNoRetrieveDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $parkMonForwardNoRetrieveDn;
    /**
     * The parkMonForwardNoRetrieveIntDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $parkMonForwardNoRetrieveIntDn;
    /**
     * The parkMonForwardNoRetrieveVmEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $parkMonForwardNoRetrieveVmEnabled;
    /**
     * The parkMonForwardNoRetrieveIntVmEnabled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $parkMonForwardNoRetrieveIntVmEnabled;
    /**
     * The parkMonForwardNoRetrieveCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $parkMonForwardNoRetrieveCssName;
    /**
     * The parkMonForwardNoRetrieveIntCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $parkMonForwardNoRetrieveIntCssName;
    /**
     * The parkMonReversionTimer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $parkMonReversionTimer;
    /**
     * The partyEntranceTone
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $partyEntranceTone;
    /**
     * Constructor method for UpdateLineReq
     * @uses UpdateLineReq::setPattern()
     * @uses UpdateLineReq::setUuid()
     * @uses UpdateLineReq::setRoutePartitionName()
     * @uses UpdateLineReq::setNewPattern()
     * @uses UpdateLineReq::setDescription()
     * @uses UpdateLineReq::setNewRoutePartitionName()
     * @uses UpdateLineReq::setAarNeighborhoodName()
     * @uses UpdateLineReq::setAarDestinationMask()
     * @uses UpdateLineReq::setAarKeepCallHistory()
     * @uses UpdateLineReq::setAarVoiceMailEnabled()
     * @uses UpdateLineReq::setCallForwardAll()
     * @uses UpdateLineReq::setCallForwardBusy()
     * @uses UpdateLineReq::setCallForwardBusyInt()
     * @uses UpdateLineReq::setCallForwardNoAnswer()
     * @uses UpdateLineReq::setCallForwardNoAnswerInt()
     * @uses UpdateLineReq::setCallForwardNoCoverage()
     * @uses UpdateLineReq::setCallForwardNoCoverageInt()
     * @uses UpdateLineReq::setCallForwardOnFailure()
     * @uses UpdateLineReq::setCallForwardAlternateParty()
     * @uses UpdateLineReq::setCallForwardNotRegistered()
     * @uses UpdateLineReq::setCallForwardNotRegisteredInt()
     * @uses UpdateLineReq::setCallPickupGroupName()
     * @uses UpdateLineReq::setAutoAnswer()
     * @uses UpdateLineReq::setNetworkHoldMohAudioSourceId()
     * @uses UpdateLineReq::setUserHoldMohAudioSourceId()
     * @uses UpdateLineReq::setAlertingName()
     * @uses UpdateLineReq::setAsciiAlertingName()
     * @uses UpdateLineReq::setPresenceGroupName()
     * @uses UpdateLineReq::setShareLineAppearanceCssName()
     * @uses UpdateLineReq::setVoiceMailProfileName()
     * @uses UpdateLineReq::setPatternPrecedence()
     * @uses UpdateLineReq::setReleaseClause()
     * @uses UpdateLineReq::setHrDuration()
     * @uses UpdateLineReq::setHrInterval()
     * @uses UpdateLineReq::setCfaCssPolicy()
     * @uses UpdateLineReq::setDefaultActivatedDeviceName()
     * @uses UpdateLineReq::setParkMonForwardNoRetrieveDn()
     * @uses UpdateLineReq::setParkMonForwardNoRetrieveIntDn()
     * @uses UpdateLineReq::setParkMonForwardNoRetrieveVmEnabled()
     * @uses UpdateLineReq::setParkMonForwardNoRetrieveIntVmEnabled()
     * @uses UpdateLineReq::setParkMonForwardNoRetrieveCssName()
     * @uses UpdateLineReq::setParkMonForwardNoRetrieveIntCssName()
     * @uses UpdateLineReq::setParkMonReversionTimer()
     * @uses UpdateLineReq::setPartyEntranceTone()
     * @param string $pattern
     * @param string $uuid
     * @param \CUCM\StructType\XFkType $routePartitionName
     * @param string $newPattern
     * @param string $description
     * @param \CUCM\StructType\XFkType $newRoutePartitionName
     * @param \CUCM\StructType\XFkType $aarNeighborhoodName
     * @param string $aarDestinationMask
     * @param string $aarKeepCallHistory
     * @param string $aarVoiceMailEnabled
     * @param \CUCM\StructType\XCallForwardAll $callForwardAll
     * @param \CUCM\StructType\XCallForwardBusy $callForwardBusy
     * @param \CUCM\StructType\XCallForwardBusyInt $callForwardBusyInt
     * @param \CUCM\StructType\XCallForwardNoAnswer $callForwardNoAnswer
     * @param \CUCM\StructType\XCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @param \CUCM\StructType\XCallForwardNoCoverage $callForwardNoCoverage
     * @param \CUCM\StructType\XCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @param \CUCM\StructType\XCallForwardOnFailure $callForwardOnFailure
     * @param \CUCM\StructType\XCallForwardAlternateParty $callForwardAlternateParty
     * @param \CUCM\StructType\XCallForwardNotRegistered $callForwardNotRegistered
     * @param \CUCM\StructType\XCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @param \CUCM\StructType\XFkType $callPickupGroupName
     * @param string $autoAnswer
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param string $alertingName
     * @param string $asciiAlertingName
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @param \CUCM\StructType\XFkType $shareLineAppearanceCssName
     * @param \CUCM\StructType\XFkType $voiceMailProfileName
     * @param string $patternPrecedence
     * @param string $releaseClause
     * @param string $hrDuration
     * @param string $hrInterval
     * @param string $cfaCssPolicy
     * @param \CUCM\StructType\XFkType $defaultActivatedDeviceName
     * @param string $parkMonForwardNoRetrieveDn
     * @param string $parkMonForwardNoRetrieveIntDn
     * @param string $parkMonForwardNoRetrieveVmEnabled
     * @param string $parkMonForwardNoRetrieveIntVmEnabled
     * @param \CUCM\StructType\XFkType $parkMonForwardNoRetrieveCssName
     * @param \CUCM\StructType\XFkType $parkMonForwardNoRetrieveIntCssName
     * @param string $parkMonReversionTimer
     * @param string $partyEntranceTone
     */
    public function __construct($pattern = null, $uuid = null, \CUCM\StructType\XFkType $routePartitionName = null, $newPattern = null, $description = null, \CUCM\StructType\XFkType $newRoutePartitionName = null, \CUCM\StructType\XFkType $aarNeighborhoodName = null, $aarDestinationMask = null, $aarKeepCallHistory = null, $aarVoiceMailEnabled = null, \CUCM\StructType\XCallForwardAll $callForwardAll = null, \CUCM\StructType\XCallForwardBusy $callForwardBusy = null, \CUCM\StructType\XCallForwardBusyInt $callForwardBusyInt = null, \CUCM\StructType\XCallForwardNoAnswer $callForwardNoAnswer = null, \CUCM\StructType\XCallForwardNoAnswerInt $callForwardNoAnswerInt = null, \CUCM\StructType\XCallForwardNoCoverage $callForwardNoCoverage = null, \CUCM\StructType\XCallForwardNoCoverageInt $callForwardNoCoverageInt = null, \CUCM\StructType\XCallForwardOnFailure $callForwardOnFailure = null, \CUCM\StructType\XCallForwardAlternateParty $callForwardAlternateParty = null, \CUCM\StructType\XCallForwardNotRegistered $callForwardNotRegistered = null, \CUCM\StructType\XCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null, \CUCM\StructType\XFkType $callPickupGroupName = null, $autoAnswer = 'Auto Answer Off', $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, $alertingName = null, $asciiAlertingName = null, \CUCM\StructType\XFkType $presenceGroupName = null, \CUCM\StructType\XFkType $shareLineAppearanceCssName = null, \CUCM\StructType\XFkType $voiceMailProfileName = null, $patternPrecedence = 'Default', $releaseClause = 'No Error', $hrDuration = null, $hrInterval = null, $cfaCssPolicy = 'Use System Default', \CUCM\StructType\XFkType $defaultActivatedDeviceName = null, $parkMonForwardNoRetrieveDn = null, $parkMonForwardNoRetrieveIntDn = null, $parkMonForwardNoRetrieveVmEnabled = null, $parkMonForwardNoRetrieveIntVmEnabled = null, \CUCM\StructType\XFkType $parkMonForwardNoRetrieveCssName = null, \CUCM\StructType\XFkType $parkMonForwardNoRetrieveIntCssName = null, $parkMonReversionTimer = null, $partyEntranceTone = 'Default')
    {
        $this
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setRoutePartitionName($routePartitionName)
            ->setNewPattern($newPattern)
            ->setDescription($description)
            ->setNewRoutePartitionName($newRoutePartitionName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setAarDestinationMask($aarDestinationMask)
            ->setAarKeepCallHistory($aarKeepCallHistory)
            ->setAarVoiceMailEnabled($aarVoiceMailEnabled)
            ->setCallForwardAll($callForwardAll)
            ->setCallForwardBusy($callForwardBusy)
            ->setCallForwardBusyInt($callForwardBusyInt)
            ->setCallForwardNoAnswer($callForwardNoAnswer)
            ->setCallForwardNoAnswerInt($callForwardNoAnswerInt)
            ->setCallForwardNoCoverage($callForwardNoCoverage)
            ->setCallForwardNoCoverageInt($callForwardNoCoverageInt)
            ->setCallForwardOnFailure($callForwardOnFailure)
            ->setCallForwardAlternateParty($callForwardAlternateParty)
            ->setCallForwardNotRegistered($callForwardNotRegistered)
            ->setCallForwardNotRegisteredInt($callForwardNotRegisteredInt)
            ->setCallPickupGroupName($callPickupGroupName)
            ->setAutoAnswer($autoAnswer)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAlertingName($alertingName)
            ->setAsciiAlertingName($asciiAlertingName)
            ->setPresenceGroupName($presenceGroupName)
            ->setShareLineAppearanceCssName($shareLineAppearanceCssName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setPatternPrecedence($patternPrecedence)
            ->setReleaseClause($releaseClause)
            ->setHrDuration($hrDuration)
            ->setHrInterval($hrInterval)
            ->setCfaCssPolicy($cfaCssPolicy)
            ->setDefaultActivatedDeviceName($defaultActivatedDeviceName)
            ->setParkMonForwardNoRetrieveDn($parkMonForwardNoRetrieveDn)
            ->setParkMonForwardNoRetrieveIntDn($parkMonForwardNoRetrieveIntDn)
            ->setParkMonForwardNoRetrieveVmEnabled($parkMonForwardNoRetrieveVmEnabled)
            ->setParkMonForwardNoRetrieveIntVmEnabled($parkMonForwardNoRetrieveIntVmEnabled)
            ->setParkMonForwardNoRetrieveCssName($parkMonForwardNoRetrieveCssName)
            ->setParkMonForwardNoRetrieveIntCssName($parkMonForwardNoRetrieveIntCssName)
            ->setParkMonReversionTimer($parkMonReversionTimer)
            ->setPartyEntranceTone($partyEntranceTone);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $routePartitionName
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setRoutePartitionName(\CUCM\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setNewPattern($newPattern = null)
    {
        // validation for constraint: string
        if (!is_null($newPattern) && !is_string($newPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPattern)), __LINE__);
        }
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get newRoutePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getNewRoutePartitionName()
    {
        return isset($this->newRoutePartitionName) ? $this->newRoutePartitionName : null;
    }
    /**
     * Set newRoutePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $newRoutePartitionName
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setNewRoutePartitionName(\CUCM\StructType\XFkType $newRoutePartitionName = null)
    {
        if (is_null($newRoutePartitionName) || (is_array($newRoutePartitionName) && empty($newRoutePartitionName))) {
            unset($this->newRoutePartitionName);
        } else {
            $this->newRoutePartitionName = $newRoutePartitionName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $aarNeighborhoodName
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setAarNeighborhoodName(\CUCM\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get aarDestinationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAarDestinationMask()
    {
        return isset($this->aarDestinationMask) ? $this->aarDestinationMask : null;
    }
    /**
     * Set aarDestinationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aarDestinationMask
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setAarDestinationMask($aarDestinationMask = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($aarDestinationMask) && strlen($aarDestinationMask) > 128) || (is_array($aarDestinationMask) && count($aarDestinationMask) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($aarDestinationMask) ? strlen($aarDestinationMask) : count($aarDestinationMask)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aarDestinationMask) && !is_string($aarDestinationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aarDestinationMask)), __LINE__);
        }
        if (is_null($aarDestinationMask) || (is_array($aarDestinationMask) && empty($aarDestinationMask))) {
            unset($this->aarDestinationMask);
        } else {
            $this->aarDestinationMask = $aarDestinationMask;
        }
        return $this;
    }
    /**
     * Get aarKeepCallHistory value
     * @return string|null
     */
    public function getAarKeepCallHistory()
    {
        return $this->aarKeepCallHistory;
    }
    /**
     * Set aarKeepCallHistory value
     * @param string $aarKeepCallHistory
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setAarKeepCallHistory($aarKeepCallHistory = null)
    {
        // validation for constraint: pattern
        if (is_scalar($aarKeepCallHistory) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $aarKeepCallHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($aarKeepCallHistory, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aarKeepCallHistory) && !is_string($aarKeepCallHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aarKeepCallHistory)), __LINE__);
        }
        $this->aarKeepCallHistory = $aarKeepCallHistory;
        return $this;
    }
    /**
     * Get aarVoiceMailEnabled value
     * @return string|null
     */
    public function getAarVoiceMailEnabled()
    {
        return $this->aarVoiceMailEnabled;
    }
    /**
     * Set aarVoiceMailEnabled value
     * @param string $aarVoiceMailEnabled
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setAarVoiceMailEnabled($aarVoiceMailEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($aarVoiceMailEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $aarVoiceMailEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($aarVoiceMailEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aarVoiceMailEnabled) && !is_string($aarVoiceMailEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aarVoiceMailEnabled)), __LINE__);
        }
        $this->aarVoiceMailEnabled = $aarVoiceMailEnabled;
        return $this;
    }
    /**
     * Get callForwardAll value
     * @return \CUCM\StructType\XCallForwardAll|null
     */
    public function getCallForwardAll()
    {
        return $this->callForwardAll;
    }
    /**
     * Set callForwardAll value
     * @param \CUCM\StructType\XCallForwardAll $callForwardAll
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setCallForwardAll(\CUCM\StructType\XCallForwardAll $callForwardAll = null)
    {
        $this->callForwardAll = $callForwardAll;
        return $this;
    }
    /**
     * Get callForwardBusy value
     * @return \CUCM\StructType\XCallForwardBusy|null
     */
    public function getCallForwardBusy()
    {
        return $this->callForwardBusy;
    }
    /**
     * Set callForwardBusy value
     * @param \CUCM\StructType\XCallForwardBusy $callForwardBusy
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setCallForwardBusy(\CUCM\StructType\XCallForwardBusy $callForwardBusy = null)
    {
        $this->callForwardBusy = $callForwardBusy;
        return $this;
    }
    /**
     * Get callForwardBusyInt value
     * @return \CUCM\StructType\XCallForwardBusyInt|null
     */
    public function getCallForwardBusyInt()
    {
        return $this->callForwardBusyInt;
    }
    /**
     * Set callForwardBusyInt value
     * @param \CUCM\StructType\XCallForwardBusyInt $callForwardBusyInt
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setCallForwardBusyInt(\CUCM\StructType\XCallForwardBusyInt $callForwardBusyInt = null)
    {
        $this->callForwardBusyInt = $callForwardBusyInt;
        return $this;
    }
    /**
     * Get callForwardNoAnswer value
     * @return \CUCM\StructType\XCallForwardNoAnswer|null
     */
    public function getCallForwardNoAnswer()
    {
        return $this->callForwardNoAnswer;
    }
    /**
     * Set callForwardNoAnswer value
     * @param \CUCM\StructType\XCallForwardNoAnswer $callForwardNoAnswer
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setCallForwardNoAnswer(\CUCM\StructType\XCallForwardNoAnswer $callForwardNoAnswer = null)
    {
        $this->callForwardNoAnswer = $callForwardNoAnswer;
        return $this;
    }
    /**
     * Get callForwardNoAnswerInt value
     * @return \CUCM\StructType\XCallForwardNoAnswerInt|null
     */
    public function getCallForwardNoAnswerInt()
    {
        return $this->callForwardNoAnswerInt;
    }
    /**
     * Set callForwardNoAnswerInt value
     * @param \CUCM\StructType\XCallForwardNoAnswerInt $callForwardNoAnswerInt
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setCallForwardNoAnswerInt(\CUCM\StructType\XCallForwardNoAnswerInt $callForwardNoAnswerInt = null)
    {
        $this->callForwardNoAnswerInt = $callForwardNoAnswerInt;
        return $this;
    }
    /**
     * Get callForwardNoCoverage value
     * @return \CUCM\StructType\XCallForwardNoCoverage|null
     */
    public function getCallForwardNoCoverage()
    {
        return $this->callForwardNoCoverage;
    }
    /**
     * Set callForwardNoCoverage value
     * @param \CUCM\StructType\XCallForwardNoCoverage $callForwardNoCoverage
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setCallForwardNoCoverage(\CUCM\StructType\XCallForwardNoCoverage $callForwardNoCoverage = null)
    {
        $this->callForwardNoCoverage = $callForwardNoCoverage;
        return $this;
    }
    /**
     * Get callForwardNoCoverageInt value
     * @return \CUCM\StructType\XCallForwardNoCoverageInt|null
     */
    public function getCallForwardNoCoverageInt()
    {
        return $this->callForwardNoCoverageInt;
    }
    /**
     * Set callForwardNoCoverageInt value
     * @param \CUCM\StructType\XCallForwardNoCoverageInt $callForwardNoCoverageInt
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setCallForwardNoCoverageInt(\CUCM\StructType\XCallForwardNoCoverageInt $callForwardNoCoverageInt = null)
    {
        $this->callForwardNoCoverageInt = $callForwardNoCoverageInt;
        return $this;
    }
    /**
     * Get callForwardOnFailure value
     * @return \CUCM\StructType\XCallForwardOnFailure|null
     */
    public function getCallForwardOnFailure()
    {
        return $this->callForwardOnFailure;
    }
    /**
     * Set callForwardOnFailure value
     * @param \CUCM\StructType\XCallForwardOnFailure $callForwardOnFailure
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setCallForwardOnFailure(\CUCM\StructType\XCallForwardOnFailure $callForwardOnFailure = null)
    {
        $this->callForwardOnFailure = $callForwardOnFailure;
        return $this;
    }
    /**
     * Get callForwardAlternateParty value
     * @return \CUCM\StructType\XCallForwardAlternateParty|null
     */
    public function getCallForwardAlternateParty()
    {
        return $this->callForwardAlternateParty;
    }
    /**
     * Set callForwardAlternateParty value
     * @param \CUCM\StructType\XCallForwardAlternateParty $callForwardAlternateParty
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setCallForwardAlternateParty(\CUCM\StructType\XCallForwardAlternateParty $callForwardAlternateParty = null)
    {
        $this->callForwardAlternateParty = $callForwardAlternateParty;
        return $this;
    }
    /**
     * Get callForwardNotRegistered value
     * @return \CUCM\StructType\XCallForwardNotRegistered|null
     */
    public function getCallForwardNotRegistered()
    {
        return $this->callForwardNotRegistered;
    }
    /**
     * Set callForwardNotRegistered value
     * @param \CUCM\StructType\XCallForwardNotRegistered $callForwardNotRegistered
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setCallForwardNotRegistered(\CUCM\StructType\XCallForwardNotRegistered $callForwardNotRegistered = null)
    {
        $this->callForwardNotRegistered = $callForwardNotRegistered;
        return $this;
    }
    /**
     * Get callForwardNotRegisteredInt value
     * @return \CUCM\StructType\XCallForwardNotRegisteredInt|null
     */
    public function getCallForwardNotRegisteredInt()
    {
        return $this->callForwardNotRegisteredInt;
    }
    /**
     * Set callForwardNotRegisteredInt value
     * @param \CUCM\StructType\XCallForwardNotRegisteredInt $callForwardNotRegisteredInt
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setCallForwardNotRegisteredInt(\CUCM\StructType\XCallForwardNotRegisteredInt $callForwardNotRegisteredInt = null)
    {
        $this->callForwardNotRegisteredInt = $callForwardNotRegisteredInt;
        return $this;
    }
    /**
     * Get callPickupGroupName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCallPickupGroupName()
    {
        return $this->callPickupGroupName;
    }
    /**
     * Set callPickupGroupName value
     * @param \CUCM\StructType\XFkType $callPickupGroupName
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setCallPickupGroupName(\CUCM\StructType\XFkType $callPickupGroupName = null)
    {
        $this->callPickupGroupName = $callPickupGroupName;
        return $this;
    }
    /**
     * Get autoAnswer value
     * @return string|null
     */
    public function getAutoAnswer()
    {
        return $this->autoAnswer;
    }
    /**
     * Set autoAnswer value
     * @uses \CUCM\EnumType\XAutoAnswer::valueIsValid()
     * @uses \CUCM\EnumType\XAutoAnswer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $autoAnswer
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setAutoAnswer($autoAnswer = 'Auto Answer Off')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XAutoAnswer::valueIsValid($autoAnswer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $autoAnswer, implode(', ', \CUCM\EnumType\XAutoAnswer::getValidValues())), __LINE__);
        }
        $this->autoAnswer = $autoAnswer;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return isset($this->networkHoldMohAudioSourceId) ? $this->networkHoldMohAudioSourceId : null;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \CUCM\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceId
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSourceId, implode(', ', \CUCM\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($networkHoldMohAudioSourceId) || (is_array($networkHoldMohAudioSourceId) && empty($networkHoldMohAudioSourceId))) {
            unset($this->networkHoldMohAudioSourceId);
        } else {
            $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return isset($this->userHoldMohAudioSourceId) ? $this->userHoldMohAudioSourceId : null;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \CUCM\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', \CUCM\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($userHoldMohAudioSourceId) || (is_array($userHoldMohAudioSourceId) && empty($userHoldMohAudioSourceId))) {
            unset($this->userHoldMohAudioSourceId);
        } else {
            $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get alertingName value
     * @return string|null
     */
    public function getAlertingName()
    {
        return $this->alertingName;
    }
    /**
     * Set alertingName value
     * @param string $alertingName
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setAlertingName($alertingName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($alertingName) && strlen($alertingName) > 50) || (is_array($alertingName) && count($alertingName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($alertingName) ? strlen($alertingName) : count($alertingName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($alertingName) && !is_string($alertingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alertingName)), __LINE__);
        }
        $this->alertingName = $alertingName;
        return $this;
    }
    /**
     * Get asciiAlertingName value
     * @return string|null
     */
    public function getAsciiAlertingName()
    {
        return $this->asciiAlertingName;
    }
    /**
     * Set asciiAlertingName value
     * @param string $asciiAlertingName
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setAsciiAlertingName($asciiAlertingName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asciiAlertingName) && strlen($asciiAlertingName) > 32) || (is_array($asciiAlertingName) && count($asciiAlertingName) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($asciiAlertingName) ? strlen($asciiAlertingName) : count($asciiAlertingName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asciiAlertingName) && !is_string($asciiAlertingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asciiAlertingName)), __LINE__);
        }
        $this->asciiAlertingName = $asciiAlertingName;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setPresenceGroupName(\CUCM\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get shareLineAppearanceCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getShareLineAppearanceCssName()
    {
        return isset($this->shareLineAppearanceCssName) ? $this->shareLineAppearanceCssName : null;
    }
    /**
     * Set shareLineAppearanceCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $shareLineAppearanceCssName
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setShareLineAppearanceCssName(\CUCM\StructType\XFkType $shareLineAppearanceCssName = null)
    {
        if (is_null($shareLineAppearanceCssName) || (is_array($shareLineAppearanceCssName) && empty($shareLineAppearanceCssName))) {
            unset($this->shareLineAppearanceCssName);
        } else {
            $this->shareLineAppearanceCssName = $shareLineAppearanceCssName;
        }
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return isset($this->voiceMailProfileName) ? $this->voiceMailProfileName : null;
    }
    /**
     * Set voiceMailProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $voiceMailProfileName
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setVoiceMailProfileName(\CUCM\StructType\XFkType $voiceMailProfileName = null)
    {
        if (is_null($voiceMailProfileName) || (is_array($voiceMailProfileName) && empty($voiceMailProfileName))) {
            unset($this->voiceMailProfileName);
        } else {
            $this->voiceMailProfileName = $voiceMailProfileName;
        }
        return $this;
    }
    /**
     * Get patternPrecedence value
     * @return string|null
     */
    public function getPatternPrecedence()
    {
        return $this->patternPrecedence;
    }
    /**
     * Set patternPrecedence value
     * @uses \CUCM\EnumType\XPatternPrecedence::valueIsValid()
     * @uses \CUCM\EnumType\XPatternPrecedence::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $patternPrecedence
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setPatternPrecedence($patternPrecedence = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPatternPrecedence::valueIsValid($patternPrecedence)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $patternPrecedence, implode(', ', \CUCM\EnumType\XPatternPrecedence::getValidValues())), __LINE__);
        }
        $this->patternPrecedence = $patternPrecedence;
        return $this;
    }
    /**
     * Get releaseClause value
     * @return string|null
     */
    public function getReleaseClause()
    {
        return $this->releaseClause;
    }
    /**
     * Set releaseClause value
     * @uses \CUCM\EnumType\XReleaseCauseValue::valueIsValid()
     * @uses \CUCM\EnumType\XReleaseCauseValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $releaseClause
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setReleaseClause($releaseClause = 'No Error')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XReleaseCauseValue::valueIsValid($releaseClause)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $releaseClause, implode(', ', \CUCM\EnumType\XReleaseCauseValue::getValidValues())), __LINE__);
        }
        $this->releaseClause = $releaseClause;
        return $this;
    }
    /**
     * Get hrDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHrDuration()
    {
        return isset($this->hrDuration) ? $this->hrDuration : null;
    }
    /**
     * Set hrDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hrDuration
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setHrDuration($hrDuration = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($hrDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hrDuration, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($hrDuration) || (is_array($hrDuration) && empty($hrDuration))) {
            unset($this->hrDuration);
        } else {
            $this->hrDuration = $hrDuration;
        }
        return $this;
    }
    /**
     * Get hrInterval value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHrInterval()
    {
        return isset($this->hrInterval) ? $this->hrInterval : null;
    }
    /**
     * Set hrInterval value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hrInterval
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setHrInterval($hrInterval = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($hrInterval)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $hrInterval, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($hrInterval) || (is_array($hrInterval) && empty($hrInterval))) {
            unset($this->hrInterval);
        } else {
            $this->hrInterval = $hrInterval;
        }
        return $this;
    }
    /**
     * Get cfaCssPolicy value
     * @return string|null
     */
    public function getCfaCssPolicy()
    {
        return $this->cfaCssPolicy;
    }
    /**
     * Set cfaCssPolicy value
     * @uses \CUCM\EnumType\XCFACSSActivationPolicy::valueIsValid()
     * @uses \CUCM\EnumType\XCFACSSActivationPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cfaCssPolicy
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setCfaCssPolicy($cfaCssPolicy = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XCFACSSActivationPolicy::valueIsValid($cfaCssPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cfaCssPolicy, implode(', ', \CUCM\EnumType\XCFACSSActivationPolicy::getValidValues())), __LINE__);
        }
        $this->cfaCssPolicy = $cfaCssPolicy;
        return $this;
    }
    /**
     * Get defaultActivatedDeviceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDefaultActivatedDeviceName()
    {
        return isset($this->defaultActivatedDeviceName) ? $this->defaultActivatedDeviceName : null;
    }
    /**
     * Set defaultActivatedDeviceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $defaultActivatedDeviceName
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setDefaultActivatedDeviceName(\CUCM\StructType\XFkType $defaultActivatedDeviceName = null)
    {
        if (is_null($defaultActivatedDeviceName) || (is_array($defaultActivatedDeviceName) && empty($defaultActivatedDeviceName))) {
            unset($this->defaultActivatedDeviceName);
        } else {
            $this->defaultActivatedDeviceName = $defaultActivatedDeviceName;
        }
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveDn()
    {
        return isset($this->parkMonForwardNoRetrieveDn) ? $this->parkMonForwardNoRetrieveDn : null;
    }
    /**
     * Set parkMonForwardNoRetrieveDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parkMonForwardNoRetrieveDn
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setParkMonForwardNoRetrieveDn($parkMonForwardNoRetrieveDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($parkMonForwardNoRetrieveDn) && strlen($parkMonForwardNoRetrieveDn) > 50) || (is_array($parkMonForwardNoRetrieveDn) && count($parkMonForwardNoRetrieveDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($parkMonForwardNoRetrieveDn) ? strlen($parkMonForwardNoRetrieveDn) : count($parkMonForwardNoRetrieveDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveDn) && !is_string($parkMonForwardNoRetrieveDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parkMonForwardNoRetrieveDn)), __LINE__);
        }
        if (is_null($parkMonForwardNoRetrieveDn) || (is_array($parkMonForwardNoRetrieveDn) && empty($parkMonForwardNoRetrieveDn))) {
            unset($this->parkMonForwardNoRetrieveDn);
        } else {
            $this->parkMonForwardNoRetrieveDn = $parkMonForwardNoRetrieveDn;
        }
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveIntDn()
    {
        return isset($this->parkMonForwardNoRetrieveIntDn) ? $this->parkMonForwardNoRetrieveIntDn : null;
    }
    /**
     * Set parkMonForwardNoRetrieveIntDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parkMonForwardNoRetrieveIntDn
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setParkMonForwardNoRetrieveIntDn($parkMonForwardNoRetrieveIntDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($parkMonForwardNoRetrieveIntDn) && strlen($parkMonForwardNoRetrieveIntDn) > 50) || (is_array($parkMonForwardNoRetrieveIntDn) && count($parkMonForwardNoRetrieveIntDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($parkMonForwardNoRetrieveIntDn) ? strlen($parkMonForwardNoRetrieveIntDn) : count($parkMonForwardNoRetrieveIntDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveIntDn) && !is_string($parkMonForwardNoRetrieveIntDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parkMonForwardNoRetrieveIntDn)), __LINE__);
        }
        if (is_null($parkMonForwardNoRetrieveIntDn) || (is_array($parkMonForwardNoRetrieveIntDn) && empty($parkMonForwardNoRetrieveIntDn))) {
            unset($this->parkMonForwardNoRetrieveIntDn);
        } else {
            $this->parkMonForwardNoRetrieveIntDn = $parkMonForwardNoRetrieveIntDn;
        }
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveVmEnabled value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveVmEnabled()
    {
        return $this->parkMonForwardNoRetrieveVmEnabled;
    }
    /**
     * Set parkMonForwardNoRetrieveVmEnabled value
     * @param string $parkMonForwardNoRetrieveVmEnabled
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setParkMonForwardNoRetrieveVmEnabled($parkMonForwardNoRetrieveVmEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($parkMonForwardNoRetrieveVmEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $parkMonForwardNoRetrieveVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($parkMonForwardNoRetrieveVmEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveVmEnabled) && !is_string($parkMonForwardNoRetrieveVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parkMonForwardNoRetrieveVmEnabled)), __LINE__);
        }
        $this->parkMonForwardNoRetrieveVmEnabled = $parkMonForwardNoRetrieveVmEnabled;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntVmEnabled value
     * @return string|null
     */
    public function getParkMonForwardNoRetrieveIntVmEnabled()
    {
        return $this->parkMonForwardNoRetrieveIntVmEnabled;
    }
    /**
     * Set parkMonForwardNoRetrieveIntVmEnabled value
     * @param string $parkMonForwardNoRetrieveIntVmEnabled
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setParkMonForwardNoRetrieveIntVmEnabled($parkMonForwardNoRetrieveIntVmEnabled = null)
    {
        // validation for constraint: pattern
        if (is_scalar($parkMonForwardNoRetrieveIntVmEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $parkMonForwardNoRetrieveIntVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($parkMonForwardNoRetrieveIntVmEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($parkMonForwardNoRetrieveIntVmEnabled) && !is_string($parkMonForwardNoRetrieveIntVmEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parkMonForwardNoRetrieveIntVmEnabled)), __LINE__);
        }
        $this->parkMonForwardNoRetrieveIntVmEnabled = $parkMonForwardNoRetrieveIntVmEnabled;
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getParkMonForwardNoRetrieveCssName()
    {
        return isset($this->parkMonForwardNoRetrieveCssName) ? $this->parkMonForwardNoRetrieveCssName : null;
    }
    /**
     * Set parkMonForwardNoRetrieveCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $parkMonForwardNoRetrieveCssName
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setParkMonForwardNoRetrieveCssName(\CUCM\StructType\XFkType $parkMonForwardNoRetrieveCssName = null)
    {
        if (is_null($parkMonForwardNoRetrieveCssName) || (is_array($parkMonForwardNoRetrieveCssName) && empty($parkMonForwardNoRetrieveCssName))) {
            unset($this->parkMonForwardNoRetrieveCssName);
        } else {
            $this->parkMonForwardNoRetrieveCssName = $parkMonForwardNoRetrieveCssName;
        }
        return $this;
    }
    /**
     * Get parkMonForwardNoRetrieveIntCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getParkMonForwardNoRetrieveIntCssName()
    {
        return isset($this->parkMonForwardNoRetrieveIntCssName) ? $this->parkMonForwardNoRetrieveIntCssName : null;
    }
    /**
     * Set parkMonForwardNoRetrieveIntCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $parkMonForwardNoRetrieveIntCssName
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setParkMonForwardNoRetrieveIntCssName(\CUCM\StructType\XFkType $parkMonForwardNoRetrieveIntCssName = null)
    {
        if (is_null($parkMonForwardNoRetrieveIntCssName) || (is_array($parkMonForwardNoRetrieveIntCssName) && empty($parkMonForwardNoRetrieveIntCssName))) {
            unset($this->parkMonForwardNoRetrieveIntCssName);
        } else {
            $this->parkMonForwardNoRetrieveIntCssName = $parkMonForwardNoRetrieveIntCssName;
        }
        return $this;
    }
    /**
     * Get parkMonReversionTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParkMonReversionTimer()
    {
        return isset($this->parkMonReversionTimer) ? $this->parkMonReversionTimer : null;
    }
    /**
     * Set parkMonReversionTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parkMonReversionTimer
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setParkMonReversionTimer($parkMonReversionTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($parkMonReversionTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $parkMonReversionTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($parkMonReversionTimer) || (is_array($parkMonReversionTimer) && empty($parkMonReversionTimer))) {
            unset($this->parkMonReversionTimer);
        } else {
            $this->parkMonReversionTimer = $parkMonReversionTimer;
        }
        return $this;
    }
    /**
     * Get partyEntranceTone value
     * @return string|null
     */
    public function getPartyEntranceTone()
    {
        return $this->partyEntranceTone;
    }
    /**
     * Set partyEntranceTone value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $partyEntranceTone
     * @return \CUCM\StructType\UpdateLineReq
     */
    public function setPartyEntranceTone($partyEntranceTone = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($partyEntranceTone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $partyEntranceTone, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->partyEntranceTone = $partyEntranceTone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateLineReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
