<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLdapFilterReq StructType
 * @subpackage Structs
 */
class UpdateLdapFilterReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 4096
     * @var string
     */
    public $newName;
    /**
     * The filter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $filter;
    /**
     * Constructor method for UpdateLdapFilterReq
     * @uses UpdateLdapFilterReq::setNewName()
     * @uses UpdateLdapFilterReq::setFilter()
     * @param string $newName
     * @param string $filter
     */
    public function __construct($newName = null, $filter = null)
    {
        $this
            ->setNewName($newName)
            ->setFilter($filter);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateLdapFilterReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 4096) || (is_array($newName) && count($newName) > 4096)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4096 element(s) or a scalar of 4096 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @param string $filter
     * @return \CUCM\StructType\UpdateLdapFilterReq
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($filter) && strlen($filter) > 255) || (is_array($filter) && count($filter) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($filter) ? strlen($filter) : count($filter)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($filter) && !is_string($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filter)), __LINE__);
        }
        $this->filter = $filter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateLdapFilterReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
