<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeExclusionNumberReq StructType
 * @subpackage Structs
 */
class UpdateImeExclusionNumberReq extends APIRequest
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $newPattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The imeExclusionNumberGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $imeExclusionNumberGroupName;
    /**
     * Constructor method for UpdateImeExclusionNumberReq
     * @uses UpdateImeExclusionNumberReq::setPattern()
     * @uses UpdateImeExclusionNumberReq::setUuid()
     * @uses UpdateImeExclusionNumberReq::setNewPattern()
     * @uses UpdateImeExclusionNumberReq::setDescription()
     * @uses UpdateImeExclusionNumberReq::setImeExclusionNumberGroupName()
     * @param string $pattern
     * @param string $uuid
     * @param string $newPattern
     * @param string $description
     * @param \CUCM\StructType\XFkType $imeExclusionNumberGroupName
     */
    public function __construct($pattern = null, $uuid = null, $newPattern = null, $description = null, \CUCM\StructType\XFkType $imeExclusionNumberGroupName = null)
    {
        $this
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setNewPattern($newPattern)
            ->setDescription($description)
            ->setImeExclusionNumberGroupName($imeExclusionNumberGroupName);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \CUCM\StructType\UpdateImeExclusionNumberReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pattern) && strlen($pattern) > 16) || (is_array($pattern) && count($pattern) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($pattern) ? strlen($pattern) : count($pattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\UpdateImeExclusionNumberReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \CUCM\StructType\UpdateImeExclusionNumberReq
     */
    public function setNewPattern($newPattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newPattern) && strlen($newPattern) > 16) || (is_array($newPattern) && count($newPattern) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($newPattern) ? strlen($newPattern) : count($newPattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newPattern) && !is_string($newPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPattern)), __LINE__);
        }
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateImeExclusionNumberReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get imeExclusionNumberGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getImeExclusionNumberGroupName()
    {
        return isset($this->imeExclusionNumberGroupName) ? $this->imeExclusionNumberGroupName : null;
    }
    /**
     * Set imeExclusionNumberGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $imeExclusionNumberGroupName
     * @return \CUCM\StructType\UpdateImeExclusionNumberReq
     */
    public function setImeExclusionNumberGroupName(\CUCM\StructType\XFkType $imeExclusionNumberGroupName = null)
    {
        if (is_null($imeExclusionNumberGroupName) || (is_array($imeExclusionNumberGroupName) && empty($imeExclusionNumberGroupName))) {
            unset($this->imeExclusionNumberGroupName);
        } else {
            $this->imeExclusionNumberGroupName = $imeExclusionNumberGroupName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateImeExclusionNumberReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
