<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeE164TransformationReq StructType
 * @subpackage Structs
 */
class UpdateImeE164TransformationReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The isCgpnPreTransformation
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isCgpnPreTransformation;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The isCdpnPreTransformation
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isCdpnPreTransformation;
    /**
     * The incomingCgpnTransformationProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $incomingCgpnTransformationProfileName;
    /**
     * The incomingCdpnTransformationProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $incomingCdpnTransformationProfileName;
    /**
     * Constructor method for UpdateImeE164TransformationReq
     * @uses UpdateImeE164TransformationReq::setNewName()
     * @uses UpdateImeE164TransformationReq::setDescription()
     * @uses UpdateImeE164TransformationReq::setCgpnTransformationCssName()
     * @uses UpdateImeE164TransformationReq::setIsCgpnPreTransformation()
     * @uses UpdateImeE164TransformationReq::setCdpnTransformationCssName()
     * @uses UpdateImeE164TransformationReq::setIsCdpnPreTransformation()
     * @uses UpdateImeE164TransformationReq::setIncomingCgpnTransformationProfileName()
     * @uses UpdateImeE164TransformationReq::setIncomingCdpnTransformationProfileName()
     * @param string $newName
     * @param string $description
     * @param \CUCM\StructType\XFkType $cgpnTransformationCssName
     * @param string $isCgpnPreTransformation
     * @param \CUCM\StructType\XFkType $cdpnTransformationCssName
     * @param string $isCdpnPreTransformation
     * @param \CUCM\StructType\XFkType $incomingCgpnTransformationProfileName
     * @param \CUCM\StructType\XFkType $incomingCdpnTransformationProfileName
     */
    public function __construct($newName = null, $description = null, \CUCM\StructType\XFkType $cgpnTransformationCssName = null, $isCgpnPreTransformation = false, \CUCM\StructType\XFkType $cdpnTransformationCssName = null, $isCdpnPreTransformation = false, \CUCM\StructType\XFkType $incomingCgpnTransformationProfileName = null, \CUCM\StructType\XFkType $incomingCdpnTransformationProfileName = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setIsCgpnPreTransformation($isCgpnPreTransformation)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setIsCdpnPreTransformation($isCdpnPreTransformation)
            ->setIncomingCgpnTransformationProfileName($incomingCgpnTransformationProfileName)
            ->setIncomingCdpnTransformationProfileName($incomingCdpnTransformationProfileName);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateImeE164TransformationReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateImeE164TransformationReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $cgpnTransformationCssName
     * @return \CUCM\StructType\UpdateImeE164TransformationReq
     */
    public function setCgpnTransformationCssName(\CUCM\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get isCgpnPreTransformation value
     * @return string|null
     */
    public function getIsCgpnPreTransformation()
    {
        return $this->isCgpnPreTransformation;
    }
    /**
     * Set isCgpnPreTransformation value
     * @param string $isCgpnPreTransformation
     * @return \CUCM\StructType\UpdateImeE164TransformationReq
     */
    public function setIsCgpnPreTransformation($isCgpnPreTransformation = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isCgpnPreTransformation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isCgpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isCgpnPreTransformation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isCgpnPreTransformation) && !is_string($isCgpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isCgpnPreTransformation)), __LINE__);
        }
        $this->isCgpnPreTransformation = $isCgpnPreTransformation;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $cdpnTransformationCssName
     * @return \CUCM\StructType\UpdateImeE164TransformationReq
     */
    public function setCdpnTransformationCssName(\CUCM\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get isCdpnPreTransformation value
     * @return string|null
     */
    public function getIsCdpnPreTransformation()
    {
        return $this->isCdpnPreTransformation;
    }
    /**
     * Set isCdpnPreTransformation value
     * @param string $isCdpnPreTransformation
     * @return \CUCM\StructType\UpdateImeE164TransformationReq
     */
    public function setIsCdpnPreTransformation($isCdpnPreTransformation = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isCdpnPreTransformation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isCdpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isCdpnPreTransformation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isCdpnPreTransformation) && !is_string($isCdpnPreTransformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isCdpnPreTransformation)), __LINE__);
        }
        $this->isCdpnPreTransformation = $isCdpnPreTransformation;
        return $this;
    }
    /**
     * Get incomingCgpnTransformationProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getIncomingCgpnTransformationProfileName()
    {
        return isset($this->incomingCgpnTransformationProfileName) ? $this->incomingCgpnTransformationProfileName : null;
    }
    /**
     * Set incomingCgpnTransformationProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $incomingCgpnTransformationProfileName
     * @return \CUCM\StructType\UpdateImeE164TransformationReq
     */
    public function setIncomingCgpnTransformationProfileName(\CUCM\StructType\XFkType $incomingCgpnTransformationProfileName = null)
    {
        if (is_null($incomingCgpnTransformationProfileName) || (is_array($incomingCgpnTransformationProfileName) && empty($incomingCgpnTransformationProfileName))) {
            unset($this->incomingCgpnTransformationProfileName);
        } else {
            $this->incomingCgpnTransformationProfileName = $incomingCgpnTransformationProfileName;
        }
        return $this;
    }
    /**
     * Get incomingCdpnTransformationProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getIncomingCdpnTransformationProfileName()
    {
        return isset($this->incomingCdpnTransformationProfileName) ? $this->incomingCdpnTransformationProfileName : null;
    }
    /**
     * Set incomingCdpnTransformationProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $incomingCdpnTransformationProfileName
     * @return \CUCM\StructType\UpdateImeE164TransformationReq
     */
    public function setIncomingCdpnTransformationProfileName(\CUCM\StructType\XFkType $incomingCdpnTransformationProfileName = null)
    {
        if (is_null($incomingCdpnTransformationProfileName) || (is_array($incomingCdpnTransformationProfileName) && empty($incomingCdpnTransformationProfileName))) {
            unset($this->incomingCdpnTransformationProfileName);
        } else {
            $this->incomingCdpnTransformationProfileName = $incomingCdpnTransformationProfileName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateImeE164TransformationReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
