<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateHuntListReq StructType
 * @subpackage Structs
 */
class UpdateHuntListReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The callManagerGroupName
     * Meta informations extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The routeListEnabled
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $routeListEnabled;
    /**
     * The voiceMailUsage
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $voiceMailUsage;
    /**
     * The removeMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Members
     */
    public $members;
    /**
     * Constructor method for UpdateHuntListReq
     * @uses UpdateHuntListReq::setNewName()
     * @uses UpdateHuntListReq::setDescription()
     * @uses UpdateHuntListReq::setCallManagerGroupName()
     * @uses UpdateHuntListReq::setRouteListEnabled()
     * @uses UpdateHuntListReq::setVoiceMailUsage()
     * @uses UpdateHuntListReq::setRemoveMembers()
     * @uses UpdateHuntListReq::setAddMembers()
     * @uses UpdateHuntListReq::setMembers()
     * @param string $newName
     * @param string $description
     * @param \CUCM\StructType\XFkType $callManagerGroupName
     * @param string $routeListEnabled
     * @param string $voiceMailUsage
     * @param \CUCM\StructType\RemoveMembers $removeMembers
     * @param \CUCM\StructType\AddMembers $addMembers
     * @param \CUCM\StructType\Members $members
     */
    public function __construct($newName = null, $description = null, \CUCM\StructType\XFkType $callManagerGroupName = null, $routeListEnabled = false, $voiceMailUsage = false, \CUCM\StructType\RemoveMembers $removeMembers = null, \CUCM\StructType\AddMembers $addMembers = null, \CUCM\StructType\Members $members = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setRouteListEnabled($routeListEnabled)
            ->setVoiceMailUsage($voiceMailUsage)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateHuntListReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateHuntListReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCallManagerGroupName()
    {
        return isset($this->callManagerGroupName) ? $this->callManagerGroupName : null;
    }
    /**
     * Set callManagerGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $callManagerGroupName
     * @return \CUCM\StructType\UpdateHuntListReq
     */
    public function setCallManagerGroupName(\CUCM\StructType\XFkType $callManagerGroupName = null)
    {
        if (is_null($callManagerGroupName) || (is_array($callManagerGroupName) && empty($callManagerGroupName))) {
            unset($this->callManagerGroupName);
        } else {
            $this->callManagerGroupName = $callManagerGroupName;
        }
        return $this;
    }
    /**
     * Get routeListEnabled value
     * @return string|null
     */
    public function getRouteListEnabled()
    {
        return $this->routeListEnabled;
    }
    /**
     * Set routeListEnabled value
     * @param string $routeListEnabled
     * @return \CUCM\StructType\UpdateHuntListReq
     */
    public function setRouteListEnabled($routeListEnabled = false)
    {
        // validation for constraint: pattern
        if (is_scalar($routeListEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $routeListEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($routeListEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routeListEnabled) && !is_string($routeListEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeListEnabled)), __LINE__);
        }
        $this->routeListEnabled = $routeListEnabled;
        return $this;
    }
    /**
     * Get voiceMailUsage value
     * @return string|null
     */
    public function getVoiceMailUsage()
    {
        return $this->voiceMailUsage;
    }
    /**
     * Set voiceMailUsage value
     * @param string $voiceMailUsage
     * @return \CUCM\StructType\UpdateHuntListReq
     */
    public function setVoiceMailUsage($voiceMailUsage = false)
    {
        // validation for constraint: pattern
        if (is_scalar($voiceMailUsage) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $voiceMailUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($voiceMailUsage, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($voiceMailUsage) && !is_string($voiceMailUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voiceMailUsage)), __LINE__);
        }
        $this->voiceMailUsage = $voiceMailUsage;
        return $this;
    }
    /**
     * Get removeMembers value
     * @return \CUCM\StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return $this->removeMembers;
    }
    /**
     * Set removeMembers value
     * @param \CUCM\StructType\RemoveMembers $removeMembers
     * @return \CUCM\StructType\UpdateHuntListReq
     */
    public function setRemoveMembers(\CUCM\StructType\RemoveMembers $removeMembers = null)
    {
        $this->removeMembers = $removeMembers;
        return $this;
    }
    /**
     * Get addMembers value
     * @return \CUCM\StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return $this->addMembers;
    }
    /**
     * Set addMembers value
     * @param \CUCM\StructType\AddMembers $addMembers
     * @return \CUCM\StructType\UpdateHuntListReq
     */
    public function setAddMembers(\CUCM\StructType\AddMembers $addMembers = null)
    {
        $this->addMembers = $addMembers;
        return $this;
    }
    /**
     * Get members value
     * @return \CUCM\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \CUCM\StructType\Members $members
     * @return \CUCM\StructType\UpdateHuntListReq
     */
    public function setMembers(\CUCM\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateHuntListReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
