<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateGatewayReq StructType
 * @subpackage Structs
 */
class UpdateGatewayReq extends APIRequest
{
    /**
     * The domainName
     * Meta informations extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The newDomainName
     * Meta informations extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newDomainName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - default: Cisco VG200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $product;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - default: MGCP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The callManagerGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * Constructor method for UpdateGatewayReq
     * @uses UpdateGatewayReq::setDomainName()
     * @uses UpdateGatewayReq::setUuid()
     * @uses UpdateGatewayReq::setNewDomainName()
     * @uses UpdateGatewayReq::setDescription()
     * @uses UpdateGatewayReq::setProduct()
     * @uses UpdateGatewayReq::setProtocol()
     * @uses UpdateGatewayReq::setCallManagerGroupName()
     * @uses UpdateGatewayReq::setVendorConfig()
     * @param string $domainName
     * @param string $uuid
     * @param string $newDomainName
     * @param string $description
     * @param string $product
     * @param string $protocol
     * @param \CUCM\StructType\XFkType $callManagerGroupName
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     */
    public function __construct($domainName = null, $uuid = null, $newDomainName = null, $description = null, $product = 'Cisco VG200', $protocol = 'MGCP', \CUCM\StructType\XFkType $callManagerGroupName = null, \CUCM\StructType\XVendorConfig $vendorConfig = null)
    {
        $this
            ->setDomainName($domainName)
            ->setUuid($uuid)
            ->setNewDomainName($newDomainName)
            ->setDescription($description)
            ->setProduct($product)
            ->setProtocol($protocol)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setVendorConfig($vendorConfig);
    }
    /**
     * Get domainName value
     * @return string
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return \CUCM\StructType\UpdateGatewayReq
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\UpdateGatewayReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get newDomainName value
     * @return string|null
     */
    public function getNewDomainName()
    {
        return $this->newDomainName;
    }
    /**
     * Set newDomainName value
     * @param string $newDomainName
     * @return \CUCM\StructType\UpdateGatewayReq
     */
    public function setNewDomainName($newDomainName = null)
    {
        // validation for constraint: string
        if (!is_null($newDomainName) && !is_string($newDomainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newDomainName)), __LINE__);
        }
        $this->newDomainName = $newDomainName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateGatewayReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProduct()
    {
        return isset($this->product) ? $this->product : null;
    }
    /**
     * Set product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XProduct::valueIsValid()
     * @uses \CUCM\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \CUCM\StructType\UpdateGatewayReq
     */
    public function setProduct($product = 'Cisco VG200')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \CUCM\EnumType\XProduct::getValidValues())), __LINE__);
        }
        if (is_null($product) || (is_array($product) && empty($product))) {
            unset($this->product);
        } else {
            $this->product = $product;
        }
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \CUCM\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \CUCM\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \CUCM\StructType\UpdateGatewayReq
     */
    public function setProtocol($protocol = 'MGCP')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', \CUCM\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCallManagerGroupName()
    {
        return isset($this->callManagerGroupName) ? $this->callManagerGroupName : null;
    }
    /**
     * Set callManagerGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $callManagerGroupName
     * @return \CUCM\StructType\UpdateGatewayReq
     */
    public function setCallManagerGroupName(\CUCM\StructType\XFkType $callManagerGroupName = null)
    {
        if (is_null($callManagerGroupName) || (is_array($callManagerGroupName) && empty($callManagerGroupName))) {
            unset($this->callManagerGroupName);
        } else {
            $this->callManagerGroupName = $callManagerGroupName;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return isset($this->vendorConfig) ? $this->vendorConfig : null;
    }
    /**
     * Set vendorConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @return \CUCM\StructType\UpdateGatewayReq
     */
    public function setVendorConfig(\CUCM\StructType\XVendorConfig $vendorConfig = null)
    {
        if (is_null($vendorConfig) || (is_array($vendorConfig) && empty($vendorConfig))) {
            unset($this->vendorConfig);
        } else {
            $this->vendorConfig = $vendorConfig;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateGatewayReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
