<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDirectoryLookupDialRulesReq StructType
 * @subpackage Structs
 */
class UpdateDirectoryLookupDialRulesReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The numberBeginWith
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numberBeginWith;
    /**
     * The numberOfDigits
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numberOfDigits;
    /**
     * The digitsToBeRemoved
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $digitsToBeRemoved;
    /**
     * The prefixPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $prefixPattern;
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $priority;
    /**
     * Constructor method for UpdateDirectoryLookupDialRulesReq
     * @uses UpdateDirectoryLookupDialRulesReq::setNewName()
     * @uses UpdateDirectoryLookupDialRulesReq::setDescription()
     * @uses UpdateDirectoryLookupDialRulesReq::setNumberBeginWith()
     * @uses UpdateDirectoryLookupDialRulesReq::setNumberOfDigits()
     * @uses UpdateDirectoryLookupDialRulesReq::setDigitsToBeRemoved()
     * @uses UpdateDirectoryLookupDialRulesReq::setPrefixPattern()
     * @uses UpdateDirectoryLookupDialRulesReq::setPriority()
     * @param string $newName
     * @param string $description
     * @param string $numberBeginWith
     * @param string $numberOfDigits
     * @param string $digitsToBeRemoved
     * @param string $prefixPattern
     * @param string $priority
     */
    public function __construct($newName = null, $description = null, $numberBeginWith = null, $numberOfDigits = '0', $digitsToBeRemoved = '0', $prefixPattern = null, $priority = '0')
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setNumberBeginWith($numberBeginWith)
            ->setNumberOfDigits($numberOfDigits)
            ->setDigitsToBeRemoved($digitsToBeRemoved)
            ->setPrefixPattern($prefixPattern)
            ->setPriority($priority);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateDirectoryLookupDialRulesReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateDirectoryLookupDialRulesReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get numberBeginWith value
     * @return string|null
     */
    public function getNumberBeginWith()
    {
        return $this->numberBeginWith;
    }
    /**
     * Set numberBeginWith value
     * @param string $numberBeginWith
     * @return \CUCM\StructType\UpdateDirectoryLookupDialRulesReq
     */
    public function setNumberBeginWith($numberBeginWith = null)
    {
        // validation for constraint: string
        if (!is_null($numberBeginWith) && !is_string($numberBeginWith)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberBeginWith)), __LINE__);
        }
        $this->numberBeginWith = $numberBeginWith;
        return $this;
    }
    /**
     * Get numberOfDigits value
     * @return string|null
     */
    public function getNumberOfDigits()
    {
        return $this->numberOfDigits;
    }
    /**
     * Set numberOfDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfDigits
     * @return \CUCM\StructType\UpdateDirectoryLookupDialRulesReq
     */
    public function setNumberOfDigits($numberOfDigits = '0')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($numberOfDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numberOfDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numberOfDigits = $numberOfDigits;
        return $this;
    }
    /**
     * Get digitsToBeRemoved value
     * @return string|null
     */
    public function getDigitsToBeRemoved()
    {
        return $this->digitsToBeRemoved;
    }
    /**
     * Set digitsToBeRemoved value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $digitsToBeRemoved
     * @return \CUCM\StructType\UpdateDirectoryLookupDialRulesReq
     */
    public function setDigitsToBeRemoved($digitsToBeRemoved = '0')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($digitsToBeRemoved)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $digitsToBeRemoved, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->digitsToBeRemoved = $digitsToBeRemoved;
        return $this;
    }
    /**
     * Get prefixPattern value
     * @return string|null
     */
    public function getPrefixPattern()
    {
        return $this->prefixPattern;
    }
    /**
     * Set prefixPattern value
     * @param string $prefixPattern
     * @return \CUCM\StructType\UpdateDirectoryLookupDialRulesReq
     */
    public function setPrefixPattern($prefixPattern = null)
    {
        // validation for constraint: string
        if (!is_null($prefixPattern) && !is_string($prefixPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixPattern)), __LINE__);
        }
        $this->prefixPattern = $prefixPattern;
        return $this;
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \CUCM\StructType\UpdateDirectoryLookupDialRulesReq
     */
    public function setPriority($priority = '0')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateDirectoryLookupDialRulesReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
