<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCumaServerSecurityProfileReq StructType
 * @subpackage Structs
 */
class UpdateCumaServerSecurityProfileReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The securityMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityMode;
    /**
     * The transportType
     * Meta informations extracted from the WSDL
     * - default: TCP+UDP
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $transportType;
    /**
     * The x509SubjectName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $x509SubjectName;
    /**
     * The serverIpHostName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $serverIpHostName;
    /**
     * Constructor method for UpdateCumaServerSecurityProfileReq
     * @uses UpdateCumaServerSecurityProfileReq::setNewName()
     * @uses UpdateCumaServerSecurityProfileReq::setDescription()
     * @uses UpdateCumaServerSecurityProfileReq::setSecurityMode()
     * @uses UpdateCumaServerSecurityProfileReq::setTransportType()
     * @uses UpdateCumaServerSecurityProfileReq::setX509SubjectName()
     * @uses UpdateCumaServerSecurityProfileReq::setServerIpHostName()
     * @param string $newName
     * @param string $description
     * @param string $securityMode
     * @param string $transportType
     * @param string $x509SubjectName
     * @param string $serverIpHostName
     */
    public function __construct($newName = null, $description = null, $securityMode = null, $transportType = 'TCP+UDP', $x509SubjectName = null, $serverIpHostName = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setSecurityMode($securityMode)
            ->setTransportType($transportType)
            ->setX509SubjectName($x509SubjectName)
            ->setServerIpHostName($serverIpHostName);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \CUCM\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get securityMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityMode()
    {
        return isset($this->securityMode) ? $this->securityMode : null;
    }
    /**
     * Set securityMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XDeviceSecurityMode::valueIsValid()
     * @uses \CUCM\EnumType\XDeviceSecurityMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $securityMode
     * @return \CUCM\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setSecurityMode($securityMode = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDeviceSecurityMode::valueIsValid($securityMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $securityMode, implode(', ', \CUCM\EnumType\XDeviceSecurityMode::getValidValues())), __LINE__);
        }
        if (is_null($securityMode) || (is_array($securityMode) && empty($securityMode))) {
            unset($this->securityMode);
        } else {
            $this->securityMode = $securityMode;
        }
        return $this;
    }
    /**
     * Get transportType value
     * @return string|null
     */
    public function getTransportType()
    {
        return $this->transportType;
    }
    /**
     * Set transportType value
     * @uses \CUCM\EnumType\XTransport::valueIsValid()
     * @uses \CUCM\EnumType\XTransport::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transportType
     * @return \CUCM\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setTransportType($transportType = 'TCP+UDP')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTransport::valueIsValid($transportType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transportType, implode(', ', \CUCM\EnumType\XTransport::getValidValues())), __LINE__);
        }
        $this->transportType = $transportType;
        return $this;
    }
    /**
     * Get x509SubjectName value
     * @return string|null
     */
    public function getX509SubjectName()
    {
        return $this->x509SubjectName;
    }
    /**
     * Set x509SubjectName value
     * @param string $x509SubjectName
     * @return \CUCM\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setX509SubjectName($x509SubjectName = null)
    {
        // validation for constraint: string
        if (!is_null($x509SubjectName) && !is_string($x509SubjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($x509SubjectName)), __LINE__);
        }
        $this->x509SubjectName = $x509SubjectName;
        return $this;
    }
    /**
     * Get serverIpHostName value
     * @return string|null
     */
    public function getServerIpHostName()
    {
        return $this->serverIpHostName;
    }
    /**
     * Set serverIpHostName value
     * @param string $serverIpHostName
     * @return \CUCM\StructType\UpdateCumaServerSecurityProfileReq
     */
    public function setServerIpHostName($serverIpHostName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serverIpHostName) && strlen($serverIpHostName) > 255) || (is_array($serverIpHostName) && count($serverIpHostName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($serverIpHostName) ? strlen($serverIpHostName) : count($serverIpHostName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serverIpHostName) && !is_string($serverIpHostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serverIpHostName)), __LINE__);
        }
        $this->serverIpHostName = $serverIpHostName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateCumaServerSecurityProfileReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
