<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UPhoneLine StructType
 * @subpackage Structs
 */
class UPhoneLine extends AbstractStructBase
{
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * The label
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $label;
    /**
     * The asciiLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $asciiLabel;
    /**
     * The display
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $display;
    /**
     * The dirn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\UDirn
     */
    public $dirn;
    /**
     * The ringSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSetting;
    /**
     * The consecutiveRingSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $consecutiveRingSetting;
    /**
     * The ringSettingIdlePickupAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingIdlePickupAlert;
    /**
     * The ringSettingActivePickupAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ringSettingActivePickupAlert;
    /**
     * The displayAscii
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $displayAscii;
    /**
     * The e164Mask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $e164Mask;
    /**
     * The dialPlanWizardId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dialPlanWizardId;
    /**
     * The mwlPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mwlPolicy;
    /**
     * The maxNumCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $maxNumCalls;
    /**
     * The busyTrigger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $busyTrigger;
    /**
     * The callInfoDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\CallInfoDisplay
     */
    public $callInfoDisplay;
    /**
     * The recordingProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $recordingProfileName;
    /**
     * The monitoringCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $monitoringCssName;
    /**
     * The recordingFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $recordingFlag;
    /**
     * The audibleMwi
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $audibleMwi;
    /**
     * The speedDial
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $speedDial;
    /**
     * The associatedEndusers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AssociatedEndusers
     */
    public $associatedEndusers;
    /**
     * The missedCallLogging
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $missedCallLogging;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for UPhoneLine
     * @uses UPhoneLine::setIndex()
     * @uses UPhoneLine::setLabel()
     * @uses UPhoneLine::setAsciiLabel()
     * @uses UPhoneLine::setDisplay()
     * @uses UPhoneLine::setDirn()
     * @uses UPhoneLine::setRingSetting()
     * @uses UPhoneLine::setConsecutiveRingSetting()
     * @uses UPhoneLine::setRingSettingIdlePickupAlert()
     * @uses UPhoneLine::setRingSettingActivePickupAlert()
     * @uses UPhoneLine::setDisplayAscii()
     * @uses UPhoneLine::setE164Mask()
     * @uses UPhoneLine::setDialPlanWizardId()
     * @uses UPhoneLine::setMwlPolicy()
     * @uses UPhoneLine::setMaxNumCalls()
     * @uses UPhoneLine::setBusyTrigger()
     * @uses UPhoneLine::setCallInfoDisplay()
     * @uses UPhoneLine::setRecordingProfileName()
     * @uses UPhoneLine::setMonitoringCssName()
     * @uses UPhoneLine::setRecordingFlag()
     * @uses UPhoneLine::setAudibleMwi()
     * @uses UPhoneLine::setSpeedDial()
     * @uses UPhoneLine::setAssociatedEndusers()
     * @uses UPhoneLine::setMissedCallLogging()
     * @uses UPhoneLine::setUuid()
     * @uses UPhoneLine::setCtiid()
     * @param string $index
     * @param string $label
     * @param string $asciiLabel
     * @param string $display
     * @param \CUCM\StructType\UDirn $dirn
     * @param string $ringSetting
     * @param string $consecutiveRingSetting
     * @param string $ringSettingIdlePickupAlert
     * @param string $ringSettingActivePickupAlert
     * @param string $displayAscii
     * @param string $e164Mask
     * @param string $dialPlanWizardId
     * @param string $mwlPolicy
     * @param string $maxNumCalls
     * @param string $busyTrigger
     * @param \CUCM\StructType\CallInfoDisplay $callInfoDisplay
     * @param \CUCM\StructType\XFkType $recordingProfileName
     * @param \CUCM\StructType\XFkType $monitoringCssName
     * @param string $recordingFlag
     * @param string $audibleMwi
     * @param string $speedDial
     * @param \CUCM\StructType\AssociatedEndusers $associatedEndusers
     * @param string $missedCallLogging
     * @param string $uuid
     * @param int $ctiid
     */
    public function __construct($index = null, $label = null, $asciiLabel = null, $display = null, \CUCM\StructType\UDirn $dirn = null, $ringSetting = null, $consecutiveRingSetting = null, $ringSettingIdlePickupAlert = null, $ringSettingActivePickupAlert = null, $displayAscii = null, $e164Mask = null, $dialPlanWizardId = null, $mwlPolicy = null, $maxNumCalls = null, $busyTrigger = null, \CUCM\StructType\CallInfoDisplay $callInfoDisplay = null, \CUCM\StructType\XFkType $recordingProfileName = null, \CUCM\StructType\XFkType $monitoringCssName = null, $recordingFlag = null, $audibleMwi = null, $speedDial = null, \CUCM\StructType\AssociatedEndusers $associatedEndusers = null, $missedCallLogging = null, $uuid = null, $ctiid = null)
    {
        $this
            ->setIndex($index)
            ->setLabel($label)
            ->setAsciiLabel($asciiLabel)
            ->setDisplay($display)
            ->setDirn($dirn)
            ->setRingSetting($ringSetting)
            ->setConsecutiveRingSetting($consecutiveRingSetting)
            ->setRingSettingIdlePickupAlert($ringSettingIdlePickupAlert)
            ->setRingSettingActivePickupAlert($ringSettingActivePickupAlert)
            ->setDisplayAscii($displayAscii)
            ->setE164Mask($e164Mask)
            ->setDialPlanWizardId($dialPlanWizardId)
            ->setMwlPolicy($mwlPolicy)
            ->setMaxNumCalls($maxNumCalls)
            ->setBusyTrigger($busyTrigger)
            ->setCallInfoDisplay($callInfoDisplay)
            ->setRecordingProfileName($recordingProfileName)
            ->setMonitoringCssName($monitoringCssName)
            ->setRecordingFlag($recordingFlag)
            ->setAudibleMwi($audibleMwi)
            ->setSpeedDial($speedDial)
            ->setAssociatedEndusers($associatedEndusers)
            ->setMissedCallLogging($missedCallLogging)
            ->setUuid($uuid)
            ->setCtiid($ctiid);
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setLabel($label = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($label) && strlen($label) > 50) || (is_array($label) && count($label) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($label) ? strlen($label) : count($label)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get asciiLabel value
     * @return string|null
     */
    public function getAsciiLabel()
    {
        return $this->asciiLabel;
    }
    /**
     * Set asciiLabel value
     * @param string $asciiLabel
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setAsciiLabel($asciiLabel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($asciiLabel) && strlen($asciiLabel) > 50) || (is_array($asciiLabel) && count($asciiLabel) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($asciiLabel) ? strlen($asciiLabel) : count($asciiLabel)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($asciiLabel) && !is_string($asciiLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asciiLabel)), __LINE__);
        }
        $this->asciiLabel = $asciiLabel;
        return $this;
    }
    /**
     * Get display value
     * @return string|null
     */
    public function getDisplay()
    {
        return $this->display;
    }
    /**
     * Set display value
     * @param string $display
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setDisplay($display = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($display) && strlen($display) > 50) || (is_array($display) && count($display) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($display) ? strlen($display) : count($display)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($display) && !is_string($display)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($display)), __LINE__);
        }
        $this->display = $display;
        return $this;
    }
    /**
     * Get dirn value
     * @return \CUCM\StructType\UDirn|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param \CUCM\StructType\UDirn $dirn
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setDirn(\CUCM\StructType\UDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get ringSetting value
     * @return string|null
     */
    public function getRingSetting()
    {
        return $this->ringSetting;
    }
    /**
     * Set ringSetting value
     * @uses \CUCM\EnumType\XRingSetting::valueIsValid()
     * @uses \CUCM\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSetting
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setRingSetting($ringSetting = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XRingSetting::valueIsValid($ringSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSetting, implode(', ', \CUCM\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSetting = $ringSetting;
        return $this;
    }
    /**
     * Get consecutiveRingSetting value
     * @return string|null
     */
    public function getConsecutiveRingSetting()
    {
        return $this->consecutiveRingSetting;
    }
    /**
     * Set consecutiveRingSetting value
     * @uses \CUCM\EnumType\XRingSetting::valueIsValid()
     * @uses \CUCM\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $consecutiveRingSetting
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setConsecutiveRingSetting($consecutiveRingSetting = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XRingSetting::valueIsValid($consecutiveRingSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $consecutiveRingSetting, implode(', ', \CUCM\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->consecutiveRingSetting = $consecutiveRingSetting;
        return $this;
    }
    /**
     * Get ringSettingIdlePickupAlert value
     * @return string|null
     */
    public function getRingSettingIdlePickupAlert()
    {
        return $this->ringSettingIdlePickupAlert;
    }
    /**
     * Set ringSettingIdlePickupAlert value
     * @uses \CUCM\EnumType\XRingSetting::valueIsValid()
     * @uses \CUCM\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingIdlePickupAlert
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setRingSettingIdlePickupAlert($ringSettingIdlePickupAlert = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XRingSetting::valueIsValid($ringSettingIdlePickupAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingIdlePickupAlert, implode(', ', \CUCM\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSettingIdlePickupAlert = $ringSettingIdlePickupAlert;
        return $this;
    }
    /**
     * Get ringSettingActivePickupAlert value
     * @return string|null
     */
    public function getRingSettingActivePickupAlert()
    {
        return $this->ringSettingActivePickupAlert;
    }
    /**
     * Set ringSettingActivePickupAlert value
     * @uses \CUCM\EnumType\XRingSetting::valueIsValid()
     * @uses \CUCM\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ringSettingActivePickupAlert
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setRingSettingActivePickupAlert($ringSettingActivePickupAlert = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XRingSetting::valueIsValid($ringSettingActivePickupAlert)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ringSettingActivePickupAlert, implode(', ', \CUCM\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->ringSettingActivePickupAlert = $ringSettingActivePickupAlert;
        return $this;
    }
    /**
     * Get displayAscii value
     * @return string|null
     */
    public function getDisplayAscii()
    {
        return $this->displayAscii;
    }
    /**
     * Set displayAscii value
     * @param string $displayAscii
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setDisplayAscii($displayAscii = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($displayAscii) && strlen($displayAscii) > 50) || (is_array($displayAscii) && count($displayAscii) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($displayAscii) ? strlen($displayAscii) : count($displayAscii)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($displayAscii) && !is_string($displayAscii)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayAscii)), __LINE__);
        }
        $this->displayAscii = $displayAscii;
        return $this;
    }
    /**
     * Get e164Mask value
     * @return string|null
     */
    public function getE164Mask()
    {
        return $this->e164Mask;
    }
    /**
     * Set e164Mask value
     * @param string $e164Mask
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setE164Mask($e164Mask = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($e164Mask) && strlen($e164Mask) > 255) || (is_array($e164Mask) && count($e164Mask) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($e164Mask) ? strlen($e164Mask) : count($e164Mask)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($e164Mask) && !is_string($e164Mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164Mask)), __LINE__);
        }
        $this->e164Mask = $e164Mask;
        return $this;
    }
    /**
     * Get dialPlanWizardId value
     * @return string|null
     */
    public function getDialPlanWizardId()
    {
        return $this->dialPlanWizardId;
    }
    /**
     * Set dialPlanWizardId value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dialPlanWizardId
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setDialPlanWizardId($dialPlanWizardId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($dialPlanWizardId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dialPlanWizardId, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->dialPlanWizardId = $dialPlanWizardId;
        return $this;
    }
    /**
     * Get mwlPolicy value
     * @return string|null
     */
    public function getMwlPolicy()
    {
        return $this->mwlPolicy;
    }
    /**
     * Set mwlPolicy value
     * @uses \CUCM\EnumType\XMWLPolicy::valueIsValid()
     * @uses \CUCM\EnumType\XMWLPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mwlPolicy
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setMwlPolicy($mwlPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMWLPolicy::valueIsValid($mwlPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mwlPolicy, implode(', ', \CUCM\EnumType\XMWLPolicy::getValidValues())), __LINE__);
        }
        $this->mwlPolicy = $mwlPolicy;
        return $this;
    }
    /**
     * Get maxNumCalls value
     * @return string|null
     */
    public function getMaxNumCalls()
    {
        return $this->maxNumCalls;
    }
    /**
     * Set maxNumCalls value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxNumCalls
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setMaxNumCalls($maxNumCalls = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($maxNumCalls)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxNumCalls, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maxNumCalls = $maxNumCalls;
        return $this;
    }
    /**
     * Get busyTrigger value
     * @return string|null
     */
    public function getBusyTrigger()
    {
        return $this->busyTrigger;
    }
    /**
     * Set busyTrigger value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $busyTrigger
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setBusyTrigger($busyTrigger = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($busyTrigger)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $busyTrigger, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->busyTrigger = $busyTrigger;
        return $this;
    }
    /**
     * Get callInfoDisplay value
     * @return \CUCM\StructType\CallInfoDisplay|null
     */
    public function getCallInfoDisplay()
    {
        return $this->callInfoDisplay;
    }
    /**
     * Set callInfoDisplay value
     * @param \CUCM\StructType\CallInfoDisplay $callInfoDisplay
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setCallInfoDisplay(\CUCM\StructType\CallInfoDisplay $callInfoDisplay = null)
    {
        $this->callInfoDisplay = $callInfoDisplay;
        return $this;
    }
    /**
     * Get recordingProfileName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRecordingProfileName()
    {
        return $this->recordingProfileName;
    }
    /**
     * Set recordingProfileName value
     * @param \CUCM\StructType\XFkType $recordingProfileName
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setRecordingProfileName(\CUCM\StructType\XFkType $recordingProfileName = null)
    {
        $this->recordingProfileName = $recordingProfileName;
        return $this;
    }
    /**
     * Get monitoringCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getMonitoringCssName()
    {
        return $this->monitoringCssName;
    }
    /**
     * Set monitoringCssName value
     * @param \CUCM\StructType\XFkType $monitoringCssName
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setMonitoringCssName(\CUCM\StructType\XFkType $monitoringCssName = null)
    {
        $this->monitoringCssName = $monitoringCssName;
        return $this;
    }
    /**
     * Get recordingFlag value
     * @return string|null
     */
    public function getRecordingFlag()
    {
        return $this->recordingFlag;
    }
    /**
     * Set recordingFlag value
     * @uses \CUCM\EnumType\XRecordingFlag::valueIsValid()
     * @uses \CUCM\EnumType\XRecordingFlag::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recordingFlag
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setRecordingFlag($recordingFlag = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XRecordingFlag::valueIsValid($recordingFlag)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recordingFlag, implode(', ', \CUCM\EnumType\XRecordingFlag::getValidValues())), __LINE__);
        }
        $this->recordingFlag = $recordingFlag;
        return $this;
    }
    /**
     * Get audibleMwi value
     * @return string|null
     */
    public function getAudibleMwi()
    {
        return $this->audibleMwi;
    }
    /**
     * Set audibleMwi value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $audibleMwi
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setAudibleMwi($audibleMwi = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($audibleMwi)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $audibleMwi, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->audibleMwi = $audibleMwi;
        return $this;
    }
    /**
     * Get speedDial value
     * @return string|null
     */
    public function getSpeedDial()
    {
        return $this->speedDial;
    }
    /**
     * Set speedDial value
     * @param string $speedDial
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setSpeedDial($speedDial = null)
    {
        // validation for constraint: string
        if (!is_null($speedDial) && !is_string($speedDial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($speedDial)), __LINE__);
        }
        $this->speedDial = $speedDial;
        return $this;
    }
    /**
     * Get associatedEndusers value
     * @return \CUCM\StructType\AssociatedEndusers|null
     */
    public function getAssociatedEndusers()
    {
        return $this->associatedEndusers;
    }
    /**
     * Set associatedEndusers value
     * @param \CUCM\StructType\AssociatedEndusers $associatedEndusers
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setAssociatedEndusers(\CUCM\StructType\AssociatedEndusers $associatedEndusers = null)
    {
        $this->associatedEndusers = $associatedEndusers;
        return $this;
    }
    /**
     * Get missedCallLogging value
     * @return string|null
     */
    public function getMissedCallLogging()
    {
        return $this->missedCallLogging;
    }
    /**
     * Set missedCallLogging value
     * @param string $missedCallLogging
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setMissedCallLogging($missedCallLogging = null)
    {
        // validation for constraint: pattern
        if (is_scalar($missedCallLogging) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $missedCallLogging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($missedCallLogging, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($missedCallLogging) && !is_string($missedCallLogging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($missedCallLogging)), __LINE__);
        }
        $this->missedCallLogging = $missedCallLogging;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \CUCM\StructType\UPhoneLine
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UPhoneLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
