<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeRelatedPolicies StructType
 * @subpackage Structs
 */
class RemoveRelatedPolicies extends XCommonMembersExtension
{
    /**
     * The relatedPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \CUCM\StructType\XPolicyRelationship[]
     */
    public $relatedPolicy;
    /**
     * Constructor method for removeRelatedPolicies
     * @uses RemoveRelatedPolicies::setRelatedPolicy()
     * @param \CUCM\StructType\XPolicyRelationship[] $relatedPolicy
     */
    public function __construct(array $relatedPolicy = array())
    {
        $this
            ->setRelatedPolicy($relatedPolicy);
    }
    /**
     * Get relatedPolicy value
     * @return \CUCM\StructType\XPolicyRelationship[]
     */
    public function getRelatedPolicy()
    {
        return $this->relatedPolicy;
    }
    /**
     * Set relatedPolicy value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\XPolicyRelationship[] $relatedPolicy
     * @return \CUCM\StructType\RemoveRelatedPolicies
     */
    public function setRelatedPolicy(array $relatedPolicy = array())
    {
        foreach ($relatedPolicy as $removeRelatedPoliciesRelatedPolicyItem) {
            // validation for constraint: itemType
            if (!$removeRelatedPoliciesRelatedPolicyItem instanceof \CUCM\StructType\XPolicyRelationship) {
                throw new \InvalidArgumentException(sprintf('The relatedPolicy property can only contain items of \CUCM\StructType\XPolicyRelationship, "%s" given', is_object($removeRelatedPoliciesRelatedPolicyItem) ? get_class($removeRelatedPoliciesRelatedPolicyItem) : gettype($removeRelatedPoliciesRelatedPolicyItem)), __LINE__);
            }
        }
        $this->relatedPolicy = $relatedPolicy;
        return $this;
    }
    /**
     * Add item to relatedPolicy value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\XPolicyRelationship $item
     * @return \CUCM\StructType\RemoveRelatedPolicies
     */
    public function addToRelatedPolicy(\CUCM\StructType\XPolicyRelationship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CUCM\StructType\XPolicyRelationship) {
            throw new \InvalidArgumentException(sprintf('The relatedPolicy property can only contain items of \CUCM\StructType\XPolicyRelationship, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->relatedPolicy[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RemoveRelatedPolicies
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
