<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removePatterns StructType
 * @subpackage Structs
 */
class RemovePatterns extends XCommonMembersExtension
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \CUCM\StructType\XPatternMember[]
     */
    public $pattern;
    /**
     * Constructor method for removePatterns
     * @uses RemovePatterns::setPattern()
     * @param \CUCM\StructType\XPatternMember[] $pattern
     */
    public function __construct(array $pattern = array())
    {
        $this
            ->setPattern($pattern);
    }
    /**
     * Get pattern value
     * @return \CUCM\StructType\XPatternMember[]
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\XPatternMember[] $pattern
     * @return \CUCM\StructType\RemovePatterns
     */
    public function setPattern(array $pattern = array())
    {
        foreach ($pattern as $removePatternsPatternItem) {
            // validation for constraint: itemType
            if (!$removePatternsPatternItem instanceof \CUCM\StructType\XPatternMember) {
                throw new \InvalidArgumentException(sprintf('The pattern property can only contain items of \CUCM\StructType\XPatternMember, "%s" given', is_object($removePatternsPatternItem) ? get_class($removePatternsPatternItem) : gettype($removePatternsPatternItem)), __LINE__);
            }
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Add item to pattern value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\XPatternMember $item
     * @return \CUCM\StructType\RemovePatterns
     */
    public function addToPattern(\CUCM\StructType\XPatternMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CUCM\StructType\XPatternMember) {
            throw new \InvalidArgumentException(sprintf('The pattern property can only contain items of \CUCM\StructType\XPatternMember, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->pattern[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RemovePatterns
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
