<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relatedGroups StructType
 * @subpackage Structs
 */
class RelatedGroups extends AbstractStructBase
{
    /**
     * The relatedGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \CUCM\StructType\RAarGroupRelationship[]
     */
    public $relatedGroup;
    /**
     * Constructor method for relatedGroups
     * @uses RelatedGroups::setRelatedGroup()
     * @param \CUCM\StructType\RAarGroupRelationship[] $relatedGroup
     */
    public function __construct(array $relatedGroup = array())
    {
        $this
            ->setRelatedGroup($relatedGroup);
    }
    /**
     * Get relatedGroup value
     * @return \CUCM\StructType\RAarGroupRelationship[]|null
     */
    public function getRelatedGroup()
    {
        return $this->relatedGroup;
    }
    /**
     * Set relatedGroup value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\RAarGroupRelationship[] $relatedGroup
     * @return \CUCM\StructType\RelatedGroups
     */
    public function setRelatedGroup(array $relatedGroup = array())
    {
        foreach ($relatedGroup as $relatedGroupsRelatedGroupItem) {
            // validation for constraint: itemType
            if (!$relatedGroupsRelatedGroupItem instanceof \CUCM\StructType\RAarGroupRelationship) {
                throw new \InvalidArgumentException(sprintf('The relatedGroup property can only contain items of \CUCM\StructType\RAarGroupRelationship, "%s" given', is_object($relatedGroupsRelatedGroupItem) ? get_class($relatedGroupsRelatedGroupItem) : gettype($relatedGroupsRelatedGroupItem)), __LINE__);
            }
        }
        $this->relatedGroup = $relatedGroup;
        return $this;
    }
    /**
     * Add item to relatedGroup value
     * @throws \InvalidArgumentException
     * @param \CUCM\StructType\RAarGroupRelationship $item
     * @return \CUCM\StructType\RelatedGroups
     */
    public function addToRelatedGroup(\CUCM\StructType\RAarGroupRelationship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CUCM\StructType\RAarGroupRelationship) {
            throw new \InvalidArgumentException(sprintf('The relatedGroup property can only contain items of \CUCM\StructType\RAarGroupRelationship, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->relatedGroup[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RelatedGroups
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
