<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RUserPhoneAssociation StructType
 * @subpackage Structs
 */
class RUserPhoneAssociation extends AbstractStructBase
{
    /**
     * The userId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userId;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The pin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pin;
    /**
     * The lastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastName;
    /**
     * The middleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $middleName;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The productType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The dnCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $dnCssName;
    /**
     * The phoneCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $phoneCssName;
    /**
     * The e164Mask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $e164Mask;
    /**
     * The extension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $extension;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The voiceMailProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $voiceMailProfileName;
    /**
     * The enableExtensionMobility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableExtensionMobility;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RUserPhoneAssociation
     * @uses RUserPhoneAssociation::setUserId()
     * @uses RUserPhoneAssociation::setPassword()
     * @uses RUserPhoneAssociation::setPin()
     * @uses RUserPhoneAssociation::setLastName()
     * @uses RUserPhoneAssociation::setMiddleName()
     * @uses RUserPhoneAssociation::setFirstName()
     * @uses RUserPhoneAssociation::setProductType()
     * @uses RUserPhoneAssociation::setName()
     * @uses RUserPhoneAssociation::setDnCssName()
     * @uses RUserPhoneAssociation::setPhoneCssName()
     * @uses RUserPhoneAssociation::setE164Mask()
     * @uses RUserPhoneAssociation::setExtension()
     * @uses RUserPhoneAssociation::setRoutePartitionName()
     * @uses RUserPhoneAssociation::setVoiceMailProfileName()
     * @uses RUserPhoneAssociation::setEnableExtensionMobility()
     * @uses RUserPhoneAssociation::setUuid()
     * @param string $userId
     * @param string $password
     * @param string $pin
     * @param string $lastName
     * @param string $middleName
     * @param string $firstName
     * @param string $productType
     * @param string $name
     * @param \CUCM\StructType\XFkType $dnCssName
     * @param \CUCM\StructType\XFkType $phoneCssName
     * @param string $e164Mask
     * @param string $extension
     * @param \CUCM\StructType\XFkType $routePartitionName
     * @param \CUCM\StructType\XFkType $voiceMailProfileName
     * @param string $enableExtensionMobility
     * @param string $uuid
     */
    public function __construct($userId = null, $password = null, $pin = null, $lastName = null, $middleName = null, $firstName = null, $productType = null, $name = null, \CUCM\StructType\XFkType $dnCssName = null, \CUCM\StructType\XFkType $phoneCssName = null, $e164Mask = null, $extension = null, \CUCM\StructType\XFkType $routePartitionName = null, \CUCM\StructType\XFkType $voiceMailProfileName = null, $enableExtensionMobility = null, $uuid = null)
    {
        $this
            ->setUserId($userId)
            ->setPassword($password)
            ->setPin($pin)
            ->setLastName($lastName)
            ->setMiddleName($middleName)
            ->setFirstName($firstName)
            ->setProductType($productType)
            ->setName($name)
            ->setDnCssName($dnCssName)
            ->setPhoneCssName($phoneCssName)
            ->setE164Mask($e164Mask)
            ->setExtension($extension)
            ->setRoutePartitionName($routePartitionName)
            ->setVoiceMailProfileName($voiceMailProfileName)
            ->setEnableExtensionMobility($enableExtensionMobility)
            ->setUuid($uuid);
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get pin value
     * @return string|null
     */
    public function getPin()
    {
        return $this->pin;
    }
    /**
     * Set pin value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pin
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setPin($pin = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($pin)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pin, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->pin = $pin;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get middleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }
    /**
     * Set middleName value
     * @param string $middleName
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        $this->middleName = $middleName;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @uses \CUCM\EnumType\XModel::valueIsValid()
     * @uses \CUCM\EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XModel::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $productType, implode(', ', \CUCM\EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get dnCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDnCssName()
    {
        return $this->dnCssName;
    }
    /**
     * Set dnCssName value
     * @param \CUCM\StructType\XFkType $dnCssName
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setDnCssName(\CUCM\StructType\XFkType $dnCssName = null)
    {
        $this->dnCssName = $dnCssName;
        return $this;
    }
    /**
     * Get phoneCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getPhoneCssName()
    {
        return $this->phoneCssName;
    }
    /**
     * Set phoneCssName value
     * @param \CUCM\StructType\XFkType $phoneCssName
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setPhoneCssName(\CUCM\StructType\XFkType $phoneCssName = null)
    {
        $this->phoneCssName = $phoneCssName;
        return $this;
    }
    /**
     * Get e164Mask value
     * @return string|null
     */
    public function getE164Mask()
    {
        return $this->e164Mask;
    }
    /**
     * Set e164Mask value
     * @param string $e164Mask
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setE164Mask($e164Mask = null)
    {
        // validation for constraint: string
        if (!is_null($e164Mask) && !is_string($e164Mask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164Mask)), __LINE__);
        }
        $this->e164Mask = $e164Mask;
        return $this;
    }
    /**
     * Get extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->extension;
    }
    /**
     * Set extension value
     * @param string $extension
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extension)), __LINE__);
        }
        $this->extension = $extension;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param \CUCM\StructType\XFkType $routePartitionName
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setRoutePartitionName(\CUCM\StructType\XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get voiceMailProfileName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getVoiceMailProfileName()
    {
        return $this->voiceMailProfileName;
    }
    /**
     * Set voiceMailProfileName value
     * @param \CUCM\StructType\XFkType $voiceMailProfileName
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setVoiceMailProfileName(\CUCM\StructType\XFkType $voiceMailProfileName = null)
    {
        $this->voiceMailProfileName = $voiceMailProfileName;
        return $this;
    }
    /**
     * Get enableExtensionMobility value
     * @return string|null
     */
    public function getEnableExtensionMobility()
    {
        return $this->enableExtensionMobility;
    }
    /**
     * Set enableExtensionMobility value
     * @param string $enableExtensionMobility
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setEnableExtensionMobility($enableExtensionMobility = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableExtensionMobility) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableExtensionMobility, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableExtensionMobility) && !is_string($enableExtensionMobility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableExtensionMobility)), __LINE__);
        }
        $this->enableExtensionMobility = $enableExtensionMobility;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RUserPhoneAssociation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
