<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RTimeSchedule StructType
 * @subpackage Structs
 */
class RTimeSchedule extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Members
     */
    public $members;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The isPublished
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPublished;
    /**
     * The timeScheduleCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeScheduleCategory;
    /**
     * The todOwnerIdName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $todOwnerIdName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RTimeSchedule
     * @uses RTimeSchedule::setName()
     * @uses RTimeSchedule::setMembers()
     * @uses RTimeSchedule::setDescription()
     * @uses RTimeSchedule::setIsPublished()
     * @uses RTimeSchedule::setTimeScheduleCategory()
     * @uses RTimeSchedule::setTodOwnerIdName()
     * @uses RTimeSchedule::setUuid()
     * @param string $name
     * @param \CUCM\StructType\Members $members
     * @param string $description
     * @param string $isPublished
     * @param string $timeScheduleCategory
     * @param \CUCM\StructType\XFkType $todOwnerIdName
     * @param string $uuid
     */
    public function __construct($name = null, \CUCM\StructType\Members $members = null, $description = null, $isPublished = null, $timeScheduleCategory = null, \CUCM\StructType\XFkType $todOwnerIdName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setMembers($members)
            ->setDescription($description)
            ->setIsPublished($isPublished)
            ->setTimeScheduleCategory($timeScheduleCategory)
            ->setTodOwnerIdName($todOwnerIdName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RTimeSchedule
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get members value
     * @return \CUCM\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \CUCM\StructType\Members $members
     * @return \CUCM\StructType\RTimeSchedule
     */
    public function setMembers(\CUCM\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\RTimeSchedule
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isPublished value
     * @return string|null
     */
    public function getIsPublished()
    {
        return $this->isPublished;
    }
    /**
     * Set isPublished value
     * @param string $isPublished
     * @return \CUCM\StructType\RTimeSchedule
     */
    public function setIsPublished($isPublished = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isPublished) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isPublished, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isPublished) && !is_string($isPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isPublished)), __LINE__);
        }
        $this->isPublished = $isPublished;
        return $this;
    }
    /**
     * Get timeScheduleCategory value
     * @return string|null
     */
    public function getTimeScheduleCategory()
    {
        return $this->timeScheduleCategory;
    }
    /**
     * Set timeScheduleCategory value
     * @uses \CUCM\EnumType\XTimeScheduleCategory::valueIsValid()
     * @uses \CUCM\EnumType\XTimeScheduleCategory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeScheduleCategory
     * @return \CUCM\StructType\RTimeSchedule
     */
    public function setTimeScheduleCategory($timeScheduleCategory = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTimeScheduleCategory::valueIsValid($timeScheduleCategory)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeScheduleCategory, implode(', ', \CUCM\EnumType\XTimeScheduleCategory::getValidValues())), __LINE__);
        }
        $this->timeScheduleCategory = $timeScheduleCategory;
        return $this;
    }
    /**
     * Get todOwnerIdName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getTodOwnerIdName()
    {
        return $this->todOwnerIdName;
    }
    /**
     * Set todOwnerIdName value
     * @param \CUCM\StructType\XFkType $todOwnerIdName
     * @return \CUCM\StructType\RTimeSchedule
     */
    public function setTodOwnerIdName(\CUCM\StructType\XFkType $todOwnerIdName = null)
    {
        $this->todOwnerIdName = $todOwnerIdName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RTimeSchedule
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RTimeSchedule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
