<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RRouteFilterMember StructType
 * @subpackage Structs
 */
class RRouteFilterMember extends AbstractStructBase
{
    /**
     * The dialPlanTagName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $dialPlanTagName;
    /**
     * The digits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $digits;
    /**
     * The operator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $operator;
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $priority;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RRouteFilterMember
     * @uses RRouteFilterMember::setDialPlanTagName()
     * @uses RRouteFilterMember::setDigits()
     * @uses RRouteFilterMember::setOperator()
     * @uses RRouteFilterMember::setPriority()
     * @uses RRouteFilterMember::setUuid()
     * @param \CUCM\StructType\XFkType $dialPlanTagName
     * @param int $digits
     * @param string $operator
     * @param string $priority
     * @param string $uuid
     */
    public function __construct(\CUCM\StructType\XFkType $dialPlanTagName = null, $digits = null, $operator = null, $priority = null, $uuid = null)
    {
        $this
            ->setDialPlanTagName($dialPlanTagName)
            ->setDigits($digits)
            ->setOperator($operator)
            ->setPriority($priority)
            ->setUuid($uuid);
    }
    /**
     * Get dialPlanTagName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDialPlanTagName()
    {
        return $this->dialPlanTagName;
    }
    /**
     * Set dialPlanTagName value
     * @param \CUCM\StructType\XFkType $dialPlanTagName
     * @return \CUCM\StructType\RRouteFilterMember
     */
    public function setDialPlanTagName(\CUCM\StructType\XFkType $dialPlanTagName = null)
    {
        $this->dialPlanTagName = $dialPlanTagName;
        return $this;
    }
    /**
     * Get digits value
     * @return int|null
     */
    public function getDigits()
    {
        return $this->digits;
    }
    /**
     * Set digits value
     * @param int $digits
     * @return \CUCM\StructType\RRouteFilterMember
     */
    public function setDigits($digits = null)
    {
        // validation for constraint: int
        if (!is_null($digits) && !is_numeric($digits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($digits)), __LINE__);
        }
        $this->digits = $digits;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \CUCM\EnumType\XOperator::valueIsValid()
     * @uses \CUCM\EnumType\XOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \CUCM\StructType\RRouteFilterMember
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operator, implode(', ', \CUCM\EnumType\XOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \CUCM\StructType\RRouteFilterMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RRouteFilterMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RRouteFilterMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
