<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RRemoteCluster StructType
 * @subpackage Structs
 */
class RRemoteCluster extends AbstractStructBase
{
    /**
     * The clusterId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $clusterId;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The fullyQualifiedName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $fullyQualifiedName;
    /**
     * The emcc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RRemoteClusterMember
     */
    public $emcc;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RRemoteClusterMember
     */
    public $pstnAccess;
    /**
     * The rsvpAgent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RRemoteClusterMember
     */
    public $rsvpAgent;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RRemoteCluster
     * @uses RRemoteCluster::setClusterId()
     * @uses RRemoteCluster::setDescription()
     * @uses RRemoteCluster::setFullyQualifiedName()
     * @uses RRemoteCluster::setEmcc()
     * @uses RRemoteCluster::setPstnAccess()
     * @uses RRemoteCluster::setRsvpAgent()
     * @uses RRemoteCluster::setUuid()
     * @param string $clusterId
     * @param string $description
     * @param string $fullyQualifiedName
     * @param \CUCM\StructType\RRemoteClusterMember $emcc
     * @param \CUCM\StructType\RRemoteClusterMember $pstnAccess
     * @param \CUCM\StructType\RRemoteClusterMember $rsvpAgent
     * @param string $uuid
     */
    public function __construct($clusterId = null, $description = null, $fullyQualifiedName = null, \CUCM\StructType\RRemoteClusterMember $emcc = null, \CUCM\StructType\RRemoteClusterMember $pstnAccess = null, \CUCM\StructType\RRemoteClusterMember $rsvpAgent = null, $uuid = null)
    {
        $this
            ->setClusterId($clusterId)
            ->setDescription($description)
            ->setFullyQualifiedName($fullyQualifiedName)
            ->setEmcc($emcc)
            ->setPstnAccess($pstnAccess)
            ->setRsvpAgent($rsvpAgent)
            ->setUuid($uuid);
    }
    /**
     * Get clusterId value
     * @return string|null
     */
    public function getClusterId()
    {
        return $this->clusterId;
    }
    /**
     * Set clusterId value
     * @param string $clusterId
     * @return \CUCM\StructType\RRemoteCluster
     */
    public function setClusterId($clusterId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clusterId) && strlen($clusterId) > 255) || (is_array($clusterId) && count($clusterId) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($clusterId) ? strlen($clusterId) : count($clusterId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clusterId) && !is_string($clusterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clusterId)), __LINE__);
        }
        $this->clusterId = $clusterId;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\RRemoteCluster
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get fullyQualifiedName value
     * @return string|null
     */
    public function getFullyQualifiedName()
    {
        return $this->fullyQualifiedName;
    }
    /**
     * Set fullyQualifiedName value
     * @param string $fullyQualifiedName
     * @return \CUCM\StructType\RRemoteCluster
     */
    public function setFullyQualifiedName($fullyQualifiedName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fullyQualifiedName) && strlen($fullyQualifiedName) > 50) || (is_array($fullyQualifiedName) && count($fullyQualifiedName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($fullyQualifiedName) ? strlen($fullyQualifiedName) : count($fullyQualifiedName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fullyQualifiedName) && !is_string($fullyQualifiedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullyQualifiedName)), __LINE__);
        }
        $this->fullyQualifiedName = $fullyQualifiedName;
        return $this;
    }
    /**
     * Get emcc value
     * @return \CUCM\StructType\RRemoteClusterMember|null
     */
    public function getEmcc()
    {
        return $this->emcc;
    }
    /**
     * Set emcc value
     * @param \CUCM\StructType\RRemoteClusterMember $emcc
     * @return \CUCM\StructType\RRemoteCluster
     */
    public function setEmcc(\CUCM\StructType\RRemoteClusterMember $emcc = null)
    {
        $this->emcc = $emcc;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return \CUCM\StructType\RRemoteClusterMember|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param \CUCM\StructType\RRemoteClusterMember $pstnAccess
     * @return \CUCM\StructType\RRemoteCluster
     */
    public function setPstnAccess(\CUCM\StructType\RRemoteClusterMember $pstnAccess = null)
    {
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get rsvpAgent value
     * @return \CUCM\StructType\RRemoteClusterMember|null
     */
    public function getRsvpAgent()
    {
        return $this->rsvpAgent;
    }
    /**
     * Set rsvpAgent value
     * @param \CUCM\StructType\RRemoteClusterMember $rsvpAgent
     * @return \CUCM\StructType\RRemoteCluster
     */
    public function setRsvpAgent(\CUCM\StructType\RRemoteClusterMember $rsvpAgent = null)
    {
        $this->rsvpAgent = $rsvpAgent;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RRemoteCluster
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RRemoteCluster
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
