<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RRegion StructType
 * @subpackage Structs
 */
class RRegion extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The relatedRegions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RelatedRegions
     */
    public $relatedRegions;
    /**
     * The defaultCodec
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $defaultCodec;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RRegion
     * @uses RRegion::setName()
     * @uses RRegion::setRelatedRegions()
     * @uses RRegion::setDefaultCodec()
     * @uses RRegion::setUuid()
     * @param string $name
     * @param \CUCM\StructType\RelatedRegions $relatedRegions
     * @param string $defaultCodec
     * @param string $uuid
     */
    public function __construct($name = null, \CUCM\StructType\RelatedRegions $relatedRegions = null, $defaultCodec = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setRelatedRegions($relatedRegions)
            ->setDefaultCodec($defaultCodec)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RRegion
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get relatedRegions value
     * @return \CUCM\StructType\RelatedRegions|null
     */
    public function getRelatedRegions()
    {
        return $this->relatedRegions;
    }
    /**
     * Set relatedRegions value
     * @param \CUCM\StructType\RelatedRegions $relatedRegions
     * @return \CUCM\StructType\RRegion
     */
    public function setRelatedRegions(\CUCM\StructType\RelatedRegions $relatedRegions = null)
    {
        $this->relatedRegions = $relatedRegions;
        return $this;
    }
    /**
     * Get defaultCodec value
     * @return string|null
     */
    public function getDefaultCodec()
    {
        return $this->defaultCodec;
    }
    /**
     * Set defaultCodec value
     * @uses \CUCM\EnumType\XBandwidth::valueIsValid()
     * @uses \CUCM\EnumType\XBandwidth::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $defaultCodec
     * @return \CUCM\StructType\RRegion
     */
    public function setDefaultCodec($defaultCodec = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XBandwidth::valueIsValid($defaultCodec)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $defaultCodec, implode(', ', \CUCM\EnumType\XBandwidth::getValidValues())), __LINE__);
        }
        $this->defaultCodec = $defaultCodec;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RRegion
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RRegion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
