<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPolicyRelationship StructType
 * @subpackage Structs
 */
class RPolicyRelationship extends AbstractStructBase
{
    /**
     * The geoLocationPolicyAName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $geoLocationPolicyAName;
    /**
     * The geoLocationDeviceA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $geoLocationDeviceA;
    /**
     * The geoLocationPolicyBName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $geoLocationPolicyBName;
    /**
     * The geoLocationDeviceB
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $geoLocationDeviceB;
    /**
     * The logicalPartitionPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $logicalPartitionPolicy;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RPolicyRelationship
     * @uses RPolicyRelationship::setGeoLocationPolicyAName()
     * @uses RPolicyRelationship::setGeoLocationDeviceA()
     * @uses RPolicyRelationship::setGeoLocationPolicyBName()
     * @uses RPolicyRelationship::setGeoLocationDeviceB()
     * @uses RPolicyRelationship::setLogicalPartitionPolicy()
     * @uses RPolicyRelationship::setUuid()
     * @param \CUCM\StructType\XFkType $geoLocationPolicyAName
     * @param string $geoLocationDeviceA
     * @param \CUCM\StructType\XFkType $geoLocationPolicyBName
     * @param string $geoLocationDeviceB
     * @param string $logicalPartitionPolicy
     * @param string $uuid
     */
    public function __construct(\CUCM\StructType\XFkType $geoLocationPolicyAName = null, $geoLocationDeviceA = null, \CUCM\StructType\XFkType $geoLocationPolicyBName = null, $geoLocationDeviceB = null, $logicalPartitionPolicy = null, $uuid = null)
    {
        $this
            ->setGeoLocationPolicyAName($geoLocationPolicyAName)
            ->setGeoLocationDeviceA($geoLocationDeviceA)
            ->setGeoLocationPolicyBName($geoLocationPolicyBName)
            ->setGeoLocationDeviceB($geoLocationDeviceB)
            ->setLogicalPartitionPolicy($logicalPartitionPolicy)
            ->setUuid($uuid);
    }
    /**
     * Get geoLocationPolicyAName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getGeoLocationPolicyAName()
    {
        return $this->geoLocationPolicyAName;
    }
    /**
     * Set geoLocationPolicyAName value
     * @param \CUCM\StructType\XFkType $geoLocationPolicyAName
     * @return \CUCM\StructType\RPolicyRelationship
     */
    public function setGeoLocationPolicyAName(\CUCM\StructType\XFkType $geoLocationPolicyAName = null)
    {
        $this->geoLocationPolicyAName = $geoLocationPolicyAName;
        return $this;
    }
    /**
     * Get geoLocationDeviceA value
     * @return string|null
     */
    public function getGeoLocationDeviceA()
    {
        return $this->geoLocationDeviceA;
    }
    /**
     * Set geoLocationDeviceA value
     * @uses \CUCM\EnumType\XGeoLocationDevice::valueIsValid()
     * @uses \CUCM\EnumType\XGeoLocationDevice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoLocationDeviceA
     * @return \CUCM\StructType\RPolicyRelationship
     */
    public function setGeoLocationDeviceA($geoLocationDeviceA = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XGeoLocationDevice::valueIsValid($geoLocationDeviceA)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geoLocationDeviceA, implode(', ', \CUCM\EnumType\XGeoLocationDevice::getValidValues())), __LINE__);
        }
        $this->geoLocationDeviceA = $geoLocationDeviceA;
        return $this;
    }
    /**
     * Get geoLocationPolicyBName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getGeoLocationPolicyBName()
    {
        return $this->geoLocationPolicyBName;
    }
    /**
     * Set geoLocationPolicyBName value
     * @param \CUCM\StructType\XFkType $geoLocationPolicyBName
     * @return \CUCM\StructType\RPolicyRelationship
     */
    public function setGeoLocationPolicyBName(\CUCM\StructType\XFkType $geoLocationPolicyBName = null)
    {
        $this->geoLocationPolicyBName = $geoLocationPolicyBName;
        return $this;
    }
    /**
     * Get geoLocationDeviceB value
     * @return string|null
     */
    public function getGeoLocationDeviceB()
    {
        return $this->geoLocationDeviceB;
    }
    /**
     * Set geoLocationDeviceB value
     * @uses \CUCM\EnumType\XGeoLocationDevice::valueIsValid()
     * @uses \CUCM\EnumType\XGeoLocationDevice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoLocationDeviceB
     * @return \CUCM\StructType\RPolicyRelationship
     */
    public function setGeoLocationDeviceB($geoLocationDeviceB = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XGeoLocationDevice::valueIsValid($geoLocationDeviceB)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geoLocationDeviceB, implode(', ', \CUCM\EnumType\XGeoLocationDevice::getValidValues())), __LINE__);
        }
        $this->geoLocationDeviceB = $geoLocationDeviceB;
        return $this;
    }
    /**
     * Get logicalPartitionPolicy value
     * @return string|null
     */
    public function getLogicalPartitionPolicy()
    {
        return $this->logicalPartitionPolicy;
    }
    /**
     * Set logicalPartitionPolicy value
     * @uses \CUCM\EnumType\XLogicalPartitionPolicy::valueIsValid()
     * @uses \CUCM\EnumType\XLogicalPartitionPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $logicalPartitionPolicy
     * @return \CUCM\StructType\RPolicyRelationship
     */
    public function setLogicalPartitionPolicy($logicalPartitionPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XLogicalPartitionPolicy::valueIsValid($logicalPartitionPolicy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $logicalPartitionPolicy, implode(', ', \CUCM\EnumType\XLogicalPartitionPolicy::getValidValues())), __LINE__);
        }
        $this->logicalPartitionPolicy = $logicalPartitionPolicy;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RPolicyRelationship
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RPolicyRelationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
