<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RPickupGroupMember StructType
 * @subpackage Structs
 */
class RPickupGroupMember extends AbstractStructBase
{
    /**
     * The priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $priority;
    /**
     * The pickupGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $pickupGroupName;
    /**
     * The pickupDnAndPartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\PickupDnAndPartition
     */
    public $pickupDnAndPartition;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RPickupGroupMember
     * @uses RPickupGroupMember::setPriority()
     * @uses RPickupGroupMember::setPickupGroupName()
     * @uses RPickupGroupMember::setPickupDnAndPartition()
     * @uses RPickupGroupMember::setUuid()
     * @param string $priority
     * @param \CUCM\StructType\XFkType $pickupGroupName
     * @param \CUCM\StructType\PickupDnAndPartition $pickupDnAndPartition
     * @param string $uuid
     */
    public function __construct($priority = null, \CUCM\StructType\XFkType $pickupGroupName = null, \CUCM\StructType\PickupDnAndPartition $pickupDnAndPartition = null, $uuid = null)
    {
        $this
            ->setPriority($priority)
            ->setPickupGroupName($pickupGroupName)
            ->setPickupDnAndPartition($pickupDnAndPartition)
            ->setUuid($uuid);
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \CUCM\StructType\RPickupGroupMember
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $priority, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get pickupGroupName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getPickupGroupName()
    {
        return $this->pickupGroupName;
    }
    /**
     * Set pickupGroupName value
     * @param \CUCM\StructType\XFkType $pickupGroupName
     * @return \CUCM\StructType\RPickupGroupMember
     */
    public function setPickupGroupName(\CUCM\StructType\XFkType $pickupGroupName = null)
    {
        $this->pickupGroupName = $pickupGroupName;
        return $this;
    }
    /**
     * Get pickupDnAndPartition value
     * @return \CUCM\StructType\PickupDnAndPartition|null
     */
    public function getPickupDnAndPartition()
    {
        return $this->pickupDnAndPartition;
    }
    /**
     * Set pickupDnAndPartition value
     * @param \CUCM\StructType\PickupDnAndPartition $pickupDnAndPartition
     * @return \CUCM\StructType\RPickupGroupMember
     */
    public function setPickupDnAndPartition(\CUCM\StructType\PickupDnAndPartition $pickupDnAndPartition = null)
    {
        $this->pickupDnAndPartition = $pickupDnAndPartition;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RPickupGroupMember
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RPickupGroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
