<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RImeLearnedRoutes StructType
 * @subpackage Structs
 */
class RImeLearnedRoutes extends AbstractStructBase
{
    /**
     * The e164Did
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $e164Did;
    /**
     * The domain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $domain;
    /**
     * The signaling
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $signaling;
    /**
     * The learnedOn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $learnedOn;
    /**
     * The expiresOn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 32
     * @var string
     */
    public $expiresOn;
    /**
     * The adminEnabled
     * Meta informations extracted from the WSDL
     * - default: false
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $adminEnabled;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RImeLearnedRoutes
     * @uses RImeLearnedRoutes::setE164Did()
     * @uses RImeLearnedRoutes::setDomain()
     * @uses RImeLearnedRoutes::setSignaling()
     * @uses RImeLearnedRoutes::setLearnedOn()
     * @uses RImeLearnedRoutes::setExpiresOn()
     * @uses RImeLearnedRoutes::setAdminEnabled()
     * @uses RImeLearnedRoutes::setUuid()
     * @param string $e164Did
     * @param string $domain
     * @param string $signaling
     * @param string $learnedOn
     * @param string $expiresOn
     * @param string $adminEnabled
     * @param string $uuid
     */
    public function __construct($e164Did = null, $domain = null, $signaling = null, $learnedOn = null, $expiresOn = null, $adminEnabled = false, $uuid = null)
    {
        $this
            ->setE164Did($e164Did)
            ->setDomain($domain)
            ->setSignaling($signaling)
            ->setLearnedOn($learnedOn)
            ->setExpiresOn($expiresOn)
            ->setAdminEnabled($adminEnabled)
            ->setUuid($uuid);
    }
    /**
     * Get e164Did value
     * @return string|null
     */
    public function getE164Did()
    {
        return $this->e164Did;
    }
    /**
     * Set e164Did value
     * @param string $e164Did
     * @return \CUCM\StructType\RImeLearnedRoutes
     */
    public function setE164Did($e164Did = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($e164Did) && strlen($e164Did) > 32) || (is_array($e164Did) && count($e164Did) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($e164Did) ? strlen($e164Did) : count($e164Did)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($e164Did) && !is_string($e164Did)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($e164Did)), __LINE__);
        }
        $this->e164Did = $e164Did;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \CUCM\StructType\RImeLearnedRoutes
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($domain) && strlen($domain) > 255) || (is_array($domain) && count($domain) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($domain) ? strlen($domain) : count($domain)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get signaling value
     * @return string|null
     */
    public function getSignaling()
    {
        return $this->signaling;
    }
    /**
     * Set signaling value
     * @param string $signaling
     * @return \CUCM\StructType\RImeLearnedRoutes
     */
    public function setSignaling($signaling = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($signaling) && strlen($signaling) > 1024) || (is_array($signaling) && count($signaling) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($signaling) ? strlen($signaling) : count($signaling)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signaling) && !is_string($signaling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signaling)), __LINE__);
        }
        $this->signaling = $signaling;
        return $this;
    }
    /**
     * Get learnedOn value
     * @return string|null
     */
    public function getLearnedOn()
    {
        return $this->learnedOn;
    }
    /**
     * Set learnedOn value
     * @param string $learnedOn
     * @return \CUCM\StructType\RImeLearnedRoutes
     */
    public function setLearnedOn($learnedOn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($learnedOn) && strlen($learnedOn) > 32) || (is_array($learnedOn) && count($learnedOn) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($learnedOn) ? strlen($learnedOn) : count($learnedOn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($learnedOn) && !is_string($learnedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($learnedOn)), __LINE__);
        }
        $this->learnedOn = $learnedOn;
        return $this;
    }
    /**
     * Get expiresOn value
     * @return string|null
     */
    public function getExpiresOn()
    {
        return $this->expiresOn;
    }
    /**
     * Set expiresOn value
     * @param string $expiresOn
     * @return \CUCM\StructType\RImeLearnedRoutes
     */
    public function setExpiresOn($expiresOn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($expiresOn) && strlen($expiresOn) > 32) || (is_array($expiresOn) && count($expiresOn) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($expiresOn) ? strlen($expiresOn) : count($expiresOn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($expiresOn) && !is_string($expiresOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiresOn)), __LINE__);
        }
        $this->expiresOn = $expiresOn;
        return $this;
    }
    /**
     * Get adminEnabled value
     * @return string|null
     */
    public function getAdminEnabled()
    {
        return $this->adminEnabled;
    }
    /**
     * Set adminEnabled value
     * @param string $adminEnabled
     * @return \CUCM\StructType\RImeLearnedRoutes
     */
    public function setAdminEnabled($adminEnabled = false)
    {
        // validation for constraint: pattern
        if (is_scalar($adminEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $adminEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($adminEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($adminEnabled) && !is_string($adminEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adminEnabled)), __LINE__);
        }
        $this->adminEnabled = $adminEnabled;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RImeLearnedRoutes
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RImeLearnedRoutes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
