<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RH323Gateway StructType
 * @subpackage Structs
 */
class RH323Gateway extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The tunneledProtocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tunneledProtocol;
    /**
     * The asn1RoseOidEncoding
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $asn1RoseOidEncoding;
    /**
     * The qsigVariant
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $qsigVariant;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The pathReplacementSupport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pathReplacementSupport;
    /**
     * The traceFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The srtpAllowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The waitForFarEndH245TerminalSet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $waitForFarEndH245TerminalSet;
    /**
     * The mtpRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The callerIdDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $callerIdDn;
    /**
     * The callingPartySelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingLineIdPresentation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingLineIdPresentation;
    /**
     * The enableInboundFaststart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableInboundFaststart;
    /**
     * The enableOutboundFaststart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableOutboundFaststart;
    /**
     * The codecForOutboundFaststart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $codecForOutboundFaststart;
    /**
     * The transmitUtf8
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The signalingPort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $signalingPort;
    /**
     * The allowH235PassThrough
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowH235PassThrough;
    /**
     * The sigDigits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \CUCM\StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The prefixDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $prefixDn;
    /**
     * The calledPartyIeNumberType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyIeNumberType;
    /**
     * The callingPartyIeNumberType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyIeNumberType;
    /**
     * The calledNumberingPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledNumberingPlan;
    /**
     * The callingNumberingPlan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingNumberingPlan;
    /**
     * The callingPartyNationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $callingPartyNationalPrefix;
    /**
     * The callingPartyInternationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $callingPartyInternationalPrefix;
    /**
     * The callingPartyUnknownPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $callingPartyUnknownPrefix;
    /**
     * The callingPartySubscriberPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $callingPartySubscriberPrefix;
    /**
     * The callingPartyNationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyNationalStripDigits;
    /**
     * The callingPartyInternationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyInternationalStripDigits;
    /**
     * The callingPartyUnknownStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartyUnknownStripDigits;
    /**
     * The callingPartySubscriberStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callingPartySubscriberStripDigits;
    /**
     * The callingPartyNationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $callingPartyNationalTransformationCssName;
    /**
     * The callingPartyInternationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $callingPartyInternationalTransformationCssName;
    /**
     * The callingPartyUnknownTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $callingPartyUnknownTransformationCssName;
    /**
     * The callingPartySubscriberTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $callingPartySubscriberTransformationCssName;
    /**
     * The calledPartyNationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $calledPartyNationalPrefix;
    /**
     * The calledPartyInternationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $calledPartyInternationalPrefix;
    /**
     * The calledPartyUnknownPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $calledPartyUnknownPrefix;
    /**
     * The calledPartySubscriberPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $calledPartySubscriberPrefix;
    /**
     * The calledPartyNationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyNationalStripDigits;
    /**
     * The calledPartyInternationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyInternationalStripDigits;
    /**
     * The calledPartyUnknownStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartyUnknownStripDigits;
    /**
     * The calledPartySubscriberStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $calledPartySubscriberStripDigits;
    /**
     * The calledPartyNationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $calledPartyNationalTransformationCssName;
    /**
     * The calledPartyInternationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $calledPartyInternationalTransformationCssName;
    /**
     * The calledPartyUnknownTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $calledPartyUnknownTransformationCssName;
    /**
     * The calledPartySubscriberTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $calledPartySubscriberTransformationCssName;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * The displayIeDelivery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $displayIeDelivery;
    /**
     * The redirectOutboundNumberIe
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectOutboundNumberIe;
    /**
     * The redirectInboundNumberIe
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectInboundNumberIe;
    /**
     * The useDevicePoolCgpnTransformCssNatl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssNatl;
    /**
     * The useDevicePoolCgpnTransformCssIntl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssIntl;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The useDevicePoolCgpnTransformCssSubs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssSubs;
    /**
     * The useDevicePoolCalledCssNatl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssNatl;
    /**
     * The useDevicePoolCalledCssIntl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssIntl;
    /**
     * The useDevicePoolCalledCssUnkn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssUnkn;
    /**
     * The useDevicePoolCalledCssSubs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCalledCssSubs;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RH323Gateway
     * @uses RH323Gateway::setName()
     * @uses RH323Gateway::setDescription()
     * @uses RH323Gateway::setProduct()
     * @uses RH323Gateway::setModel()
     * @uses RH323Gateway::setClass()
     * @uses RH323Gateway::setProtocol()
     * @uses RH323Gateway::setProtocolSide()
     * @uses RH323Gateway::setCallingSearchSpaceName()
     * @uses RH323Gateway::setDevicePoolName()
     * @uses RH323Gateway::setCommonDeviceConfigName()
     * @uses RH323Gateway::setNetworkLocation()
     * @uses RH323Gateway::setLocationName()
     * @uses RH323Gateway::setMediaResourceListName()
     * @uses RH323Gateway::setAutomatedAlternateRoutingCssName()
     * @uses RH323Gateway::setAarNeighborhoodName()
     * @uses RH323Gateway::setLoadInformation()
     * @uses RH323Gateway::setTunneledProtocol()
     * @uses RH323Gateway::setAsn1RoseOidEncoding()
     * @uses RH323Gateway::setQsigVariant()
     * @uses RH323Gateway::setVendorConfig()
     * @uses RH323Gateway::setPathReplacementSupport()
     * @uses RH323Gateway::setTraceFlag()
     * @uses RH323Gateway::setMlppDomainId()
     * @uses RH323Gateway::setUseTrustedRelayPoint()
     * @uses RH323Gateway::setRetryVideoCallAsAudio()
     * @uses RH323Gateway::setCgpnTransformationCssName()
     * @uses RH323Gateway::setUseDevicePoolCgpnTransformCss()
     * @uses RH323Gateway::setGeoLocationName()
     * @uses RH323Gateway::setGeoLocationFilterName()
     * @uses RH323Gateway::setCdpnTransformationCssName()
     * @uses RH323Gateway::setUseDevicePoolCdpnTransformCss()
     * @uses RH323Gateway::setPacketCaptureMode()
     * @uses RH323Gateway::setPacketCaptureDuration()
     * @uses RH323Gateway::setSrtpAllowed()
     * @uses RH323Gateway::setWaitForFarEndH245TerminalSet()
     * @uses RH323Gateway::setMtpRequired()
     * @uses RH323Gateway::setCallerIdDn()
     * @uses RH323Gateway::setCallingPartySelection()
     * @uses RH323Gateway::setCallingLineIdPresentation()
     * @uses RH323Gateway::setEnableInboundFaststart()
     * @uses RH323Gateway::setEnableOutboundFaststart()
     * @uses RH323Gateway::setCodecForOutboundFaststart()
     * @uses RH323Gateway::setTransmitUtf8()
     * @uses RH323Gateway::setSignalingPort()
     * @uses RH323Gateway::setAllowH235PassThrough()
     * @uses RH323Gateway::setSigDigits()
     * @uses RH323Gateway::setPrefixDn()
     * @uses RH323Gateway::setCalledPartyIeNumberType()
     * @uses RH323Gateway::setCallingPartyIeNumberType()
     * @uses RH323Gateway::setCalledNumberingPlan()
     * @uses RH323Gateway::setCallingNumberingPlan()
     * @uses RH323Gateway::setCallingPartyNationalPrefix()
     * @uses RH323Gateway::setCallingPartyInternationalPrefix()
     * @uses RH323Gateway::setCallingPartyUnknownPrefix()
     * @uses RH323Gateway::setCallingPartySubscriberPrefix()
     * @uses RH323Gateway::setCallingPartyNationalStripDigits()
     * @uses RH323Gateway::setCallingPartyInternationalStripDigits()
     * @uses RH323Gateway::setCallingPartyUnknownStripDigits()
     * @uses RH323Gateway::setCallingPartySubscriberStripDigits()
     * @uses RH323Gateway::setCallingPartyNationalTransformationCssName()
     * @uses RH323Gateway::setCallingPartyInternationalTransformationCssName()
     * @uses RH323Gateway::setCallingPartyUnknownTransformationCssName()
     * @uses RH323Gateway::setCallingPartySubscriberTransformationCssName()
     * @uses RH323Gateway::setCalledPartyNationalPrefix()
     * @uses RH323Gateway::setCalledPartyInternationalPrefix()
     * @uses RH323Gateway::setCalledPartyUnknownPrefix()
     * @uses RH323Gateway::setCalledPartySubscriberPrefix()
     * @uses RH323Gateway::setCalledPartyNationalStripDigits()
     * @uses RH323Gateway::setCalledPartyInternationalStripDigits()
     * @uses RH323Gateway::setCalledPartyUnknownStripDigits()
     * @uses RH323Gateway::setCalledPartySubscriberStripDigits()
     * @uses RH323Gateway::setCalledPartyNationalTransformationCssName()
     * @uses RH323Gateway::setCalledPartyInternationalTransformationCssName()
     * @uses RH323Gateway::setCalledPartyUnknownTransformationCssName()
     * @uses RH323Gateway::setCalledPartySubscriberTransformationCssName()
     * @uses RH323Gateway::setPstnAccess()
     * @uses RH323Gateway::setImeE164TransformationName()
     * @uses RH323Gateway::setDisplayIeDelivery()
     * @uses RH323Gateway::setRedirectOutboundNumberIe()
     * @uses RH323Gateway::setRedirectInboundNumberIe()
     * @uses RH323Gateway::setUseDevicePoolCgpnTransformCssNatl()
     * @uses RH323Gateway::setUseDevicePoolCgpnTransformCssIntl()
     * @uses RH323Gateway::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses RH323Gateway::setUseDevicePoolCgpnTransformCssSubs()
     * @uses RH323Gateway::setUseDevicePoolCalledCssNatl()
     * @uses RH323Gateway::setUseDevicePoolCalledCssIntl()
     * @uses RH323Gateway::setUseDevicePoolCalledCssUnkn()
     * @uses RH323Gateway::setUseDevicePoolCalledCssSubs()
     * @uses RH323Gateway::setCtiid()
     * @uses RH323Gateway::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @param \CUCM\StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \CUCM\StructType\XFkType $locationName
     * @param \CUCM\StructType\XFkType $mediaResourceListName
     * @param \CUCM\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \CUCM\StructType\XFkType $aarNeighborhoodName
     * @param \CUCM\StructType\XLoadInformation $loadInformation
     * @param string $tunneledProtocol
     * @param string $asn1RoseOidEncoding
     * @param string $qsigVariant
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @param string $pathReplacementSupport
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param \CUCM\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \CUCM\StructType\XFkType $geoLocationName
     * @param \CUCM\StructType\XFkType $geoLocationFilterName
     * @param \CUCM\StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param string $srtpAllowed
     * @param string $waitForFarEndH245TerminalSet
     * @param string $mtpRequired
     * @param string $callerIdDn
     * @param string $callingPartySelection
     * @param string $callingLineIdPresentation
     * @param string $enableInboundFaststart
     * @param string $enableOutboundFaststart
     * @param string $codecForOutboundFaststart
     * @param string $transmitUtf8
     * @param string $signalingPort
     * @param string $allowH235PassThrough
     * @param \CUCM\StructType\SigDigits $sigDigits
     * @param string $prefixDn
     * @param string $calledPartyIeNumberType
     * @param string $callingPartyIeNumberType
     * @param string $calledNumberingPlan
     * @param string $callingNumberingPlan
     * @param string $callingPartyNationalPrefix
     * @param string $callingPartyInternationalPrefix
     * @param string $callingPartyUnknownPrefix
     * @param string $callingPartySubscriberPrefix
     * @param string $callingPartyNationalStripDigits
     * @param string $callingPartyInternationalStripDigits
     * @param string $callingPartyUnknownStripDigits
     * @param string $callingPartySubscriberStripDigits
     * @param \CUCM\StructType\XFkType $callingPartyNationalTransformationCssName
     * @param \CUCM\StructType\XFkType $callingPartyInternationalTransformationCssName
     * @param \CUCM\StructType\XFkType $callingPartyUnknownTransformationCssName
     * @param \CUCM\StructType\XFkType $callingPartySubscriberTransformationCssName
     * @param string $calledPartyNationalPrefix
     * @param string $calledPartyInternationalPrefix
     * @param string $calledPartyUnknownPrefix
     * @param string $calledPartySubscriberPrefix
     * @param string $calledPartyNationalStripDigits
     * @param string $calledPartyInternationalStripDigits
     * @param string $calledPartyUnknownStripDigits
     * @param string $calledPartySubscriberStripDigits
     * @param \CUCM\StructType\XFkType $calledPartyNationalTransformationCssName
     * @param \CUCM\StructType\XFkType $calledPartyInternationalTransformationCssName
     * @param \CUCM\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @param \CUCM\StructType\XFkType $calledPartySubscriberTransformationCssName
     * @param string $pstnAccess
     * @param \CUCM\StructType\XFkType $imeE164TransformationName
     * @param string $displayIeDelivery
     * @param string $redirectOutboundNumberIe
     * @param string $redirectInboundNumberIe
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @param string $useDevicePoolCalledCssNatl
     * @param string $useDevicePoolCalledCssIntl
     * @param string $useDevicePoolCalledCssUnkn
     * @param string $useDevicePoolCalledCssSubs
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, \CUCM\StructType\XFkType $callingSearchSpaceName = null, \CUCM\StructType\XFkType $devicePoolName = null, \CUCM\StructType\XFkType $commonDeviceConfigName = null, $networkLocation = null, \CUCM\StructType\XFkType $locationName = null, \CUCM\StructType\XFkType $mediaResourceListName = null, \CUCM\StructType\XFkType $automatedAlternateRoutingCssName = null, \CUCM\StructType\XFkType $aarNeighborhoodName = null, \CUCM\StructType\XLoadInformation $loadInformation = null, $tunneledProtocol = null, $asn1RoseOidEncoding = null, $qsigVariant = null, \CUCM\StructType\XVendorConfig $vendorConfig = null, $pathReplacementSupport = null, $traceFlag = null, $mlppDomainId = null, $useTrustedRelayPoint = null, $retryVideoCallAsAudio = null, \CUCM\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, \CUCM\StructType\XFkType $geoLocationName = null, \CUCM\StructType\XFkType $geoLocationFilterName = null, \CUCM\StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = null, $packetCaptureMode = null, $packetCaptureDuration = null, $srtpAllowed = null, $waitForFarEndH245TerminalSet = null, $mtpRequired = null, $callerIdDn = null, $callingPartySelection = null, $callingLineIdPresentation = null, $enableInboundFaststart = null, $enableOutboundFaststart = null, $codecForOutboundFaststart = null, $transmitUtf8 = null, $signalingPort = null, $allowH235PassThrough = null, \CUCM\StructType\SigDigits $sigDigits = null, $prefixDn = null, $calledPartyIeNumberType = null, $callingPartyIeNumberType = null, $calledNumberingPlan = null, $callingNumberingPlan = null, $callingPartyNationalPrefix = null, $callingPartyInternationalPrefix = null, $callingPartyUnknownPrefix = null, $callingPartySubscriberPrefix = null, $callingPartyNationalStripDigits = null, $callingPartyInternationalStripDigits = null, $callingPartyUnknownStripDigits = null, $callingPartySubscriberStripDigits = null, \CUCM\StructType\XFkType $callingPartyNationalTransformationCssName = null, \CUCM\StructType\XFkType $callingPartyInternationalTransformationCssName = null, \CUCM\StructType\XFkType $callingPartyUnknownTransformationCssName = null, \CUCM\StructType\XFkType $callingPartySubscriberTransformationCssName = null, $calledPartyNationalPrefix = null, $calledPartyInternationalPrefix = null, $calledPartyUnknownPrefix = null, $calledPartySubscriberPrefix = null, $calledPartyNationalStripDigits = null, $calledPartyInternationalStripDigits = null, $calledPartyUnknownStripDigits = null, $calledPartySubscriberStripDigits = null, \CUCM\StructType\XFkType $calledPartyNationalTransformationCssName = null, \CUCM\StructType\XFkType $calledPartyInternationalTransformationCssName = null, \CUCM\StructType\XFkType $calledPartyUnknownTransformationCssName = null, \CUCM\StructType\XFkType $calledPartySubscriberTransformationCssName = null, $pstnAccess = null, \CUCM\StructType\XFkType $imeE164TransformationName = null, $displayIeDelivery = null, $redirectOutboundNumberIe = null, $redirectInboundNumberIe = null, $useDevicePoolCgpnTransformCssNatl = null, $useDevicePoolCgpnTransformCssIntl = null, $useDevicePoolCgpnTransformCssUnkn = null, $useDevicePoolCgpnTransformCssSubs = null, $useDevicePoolCalledCssNatl = null, $useDevicePoolCalledCssIntl = null, $useDevicePoolCalledCssUnkn = null, $useDevicePoolCalledCssSubs = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setTunneledProtocol($tunneledProtocol)
            ->setAsn1RoseOidEncoding($asn1RoseOidEncoding)
            ->setQsigVariant($qsigVariant)
            ->setVendorConfig($vendorConfig)
            ->setPathReplacementSupport($pathReplacementSupport)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setSrtpAllowed($srtpAllowed)
            ->setWaitForFarEndH245TerminalSet($waitForFarEndH245TerminalSet)
            ->setMtpRequired($mtpRequired)
            ->setCallerIdDn($callerIdDn)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingLineIdPresentation($callingLineIdPresentation)
            ->setEnableInboundFaststart($enableInboundFaststart)
            ->setEnableOutboundFaststart($enableOutboundFaststart)
            ->setCodecForOutboundFaststart($codecForOutboundFaststart)
            ->setTransmitUtf8($transmitUtf8)
            ->setSignalingPort($signalingPort)
            ->setAllowH235PassThrough($allowH235PassThrough)
            ->setSigDigits($sigDigits)
            ->setPrefixDn($prefixDn)
            ->setCalledPartyIeNumberType($calledPartyIeNumberType)
            ->setCallingPartyIeNumberType($callingPartyIeNumberType)
            ->setCalledNumberingPlan($calledNumberingPlan)
            ->setCallingNumberingPlan($callingNumberingPlan)
            ->setCallingPartyNationalPrefix($callingPartyNationalPrefix)
            ->setCallingPartyInternationalPrefix($callingPartyInternationalPrefix)
            ->setCallingPartyUnknownPrefix($callingPartyUnknownPrefix)
            ->setCallingPartySubscriberPrefix($callingPartySubscriberPrefix)
            ->setCallingPartyNationalStripDigits($callingPartyNationalStripDigits)
            ->setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits)
            ->setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits)
            ->setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits)
            ->setCallingPartyNationalTransformationCssName($callingPartyNationalTransformationCssName)
            ->setCallingPartyInternationalTransformationCssName($callingPartyInternationalTransformationCssName)
            ->setCallingPartyUnknownTransformationCssName($callingPartyUnknownTransformationCssName)
            ->setCallingPartySubscriberTransformationCssName($callingPartySubscriberTransformationCssName)
            ->setCalledPartyNationalPrefix($calledPartyNationalPrefix)
            ->setCalledPartyInternationalPrefix($calledPartyInternationalPrefix)
            ->setCalledPartyUnknownPrefix($calledPartyUnknownPrefix)
            ->setCalledPartySubscriberPrefix($calledPartySubscriberPrefix)
            ->setCalledPartyNationalStripDigits($calledPartyNationalStripDigits)
            ->setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits)
            ->setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits)
            ->setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits)
            ->setCalledPartyNationalTransformationCssName($calledPartyNationalTransformationCssName)
            ->setCalledPartyInternationalTransformationCssName($calledPartyInternationalTransformationCssName)
            ->setCalledPartyUnknownTransformationCssName($calledPartyUnknownTransformationCssName)
            ->setCalledPartySubscriberTransformationCssName($calledPartySubscriberTransformationCssName)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setDisplayIeDelivery($displayIeDelivery)
            ->setRedirectOutboundNumberIe($redirectOutboundNumberIe)
            ->setRedirectInboundNumberIe($redirectInboundNumberIe)
            ->setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl)
            ->setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs)
            ->setUseDevicePoolCalledCssNatl($useDevicePoolCalledCssNatl)
            ->setUseDevicePoolCalledCssIntl($useDevicePoolCalledCssIntl)
            ->setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn)
            ->setUseDevicePoolCalledCssSubs($useDevicePoolCalledCssSubs)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \CUCM\EnumType\XProduct::valueIsValid()
     * @uses \CUCM\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \CUCM\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses \CUCM\EnumType\XModel::valueIsValid()
     * @uses \CUCM\EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $model, implode(', ', \CUCM\EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \CUCM\EnumType\XClass::valueIsValid()
     * @uses \CUCM\EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \CUCM\EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \CUCM\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \CUCM\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', \CUCM\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \CUCM\EnumType\XProtocolSide::valueIsValid()
     * @uses \CUCM\EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', \CUCM\EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingSearchSpaceName(\CUCM\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setDevicePoolName(\CUCM\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \CUCM\StructType\XFkType $commonDeviceConfigName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCommonDeviceConfigName(\CUCM\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses \CUCM\EnumType\XNetworkLocation::valueIsValid()
     * @uses \CUCM\EnumType\XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setNetworkLocation($networkLocation = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocation, implode(', ', \CUCM\EnumType\XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get locationName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \CUCM\StructType\XFkType $locationName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setLocationName(\CUCM\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \CUCM\StructType\XFkType $mediaResourceListName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setMediaResourceListName(\CUCM\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \CUCM\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setAutomatedAlternateRoutingCssName(\CUCM\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \CUCM\StructType\XFkType $aarNeighborhoodName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setAarNeighborhoodName(\CUCM\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \CUCM\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \CUCM\StructType\XLoadInformation $loadInformation
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setLoadInformation(\CUCM\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get tunneledProtocol value
     * @return string|null
     */
    public function getTunneledProtocol()
    {
        return $this->tunneledProtocol;
    }
    /**
     * Set tunneledProtocol value
     * @uses \CUCM\EnumType\XTunneledProtocol::valueIsValid()
     * @uses \CUCM\EnumType\XTunneledProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tunneledProtocol
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setTunneledProtocol($tunneledProtocol = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTunneledProtocol::valueIsValid($tunneledProtocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tunneledProtocol, implode(', ', \CUCM\EnumType\XTunneledProtocol::getValidValues())), __LINE__);
        }
        $this->tunneledProtocol = $tunneledProtocol;
        return $this;
    }
    /**
     * Get asn1RoseOidEncoding value
     * @return string|null
     */
    public function getAsn1RoseOidEncoding()
    {
        return $this->asn1RoseOidEncoding;
    }
    /**
     * Set asn1RoseOidEncoding value
     * @uses \CUCM\EnumType\XASN1RoseOidEncoding::valueIsValid()
     * @uses \CUCM\EnumType\XASN1RoseOidEncoding::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $asn1RoseOidEncoding
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setAsn1RoseOidEncoding($asn1RoseOidEncoding = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XASN1RoseOidEncoding::valueIsValid($asn1RoseOidEncoding)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $asn1RoseOidEncoding, implode(', ', \CUCM\EnumType\XASN1RoseOidEncoding::getValidValues())), __LINE__);
        }
        $this->asn1RoseOidEncoding = $asn1RoseOidEncoding;
        return $this;
    }
    /**
     * Get qsigVariant value
     * @return string|null
     */
    public function getQsigVariant()
    {
        return $this->qsigVariant;
    }
    /**
     * Set qsigVariant value
     * @uses \CUCM\EnumType\XQSIGVariant::valueIsValid()
     * @uses \CUCM\EnumType\XQSIGVariant::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qsigVariant
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setQsigVariant($qsigVariant = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XQSIGVariant::valueIsValid($qsigVariant)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $qsigVariant, implode(', ', \CUCM\EnumType\XQSIGVariant::getValidValues())), __LINE__);
        }
        $this->qsigVariant = $qsigVariant;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \CUCM\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setVendorConfig(\CUCM\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get pathReplacementSupport value
     * @return string|null
     */
    public function getPathReplacementSupport()
    {
        return $this->pathReplacementSupport;
    }
    /**
     * Set pathReplacementSupport value
     * @param string $pathReplacementSupport
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setPathReplacementSupport($pathReplacementSupport = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pathReplacementSupport) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pathReplacementSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pathReplacementSupport, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pathReplacementSupport) && !is_string($pathReplacementSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pathReplacementSupport)), __LINE__);
        }
        $this->pathReplacementSupport = $pathReplacementSupport;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($traceFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceFlag)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = null)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \CUCM\StructType\XFkType $cgpnTransformationCssName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCgpnTransformationCssName(\CUCM\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \CUCM\StructType\XFkType $geoLocationName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setGeoLocationName(\CUCM\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \CUCM\StructType\XFkType $geoLocationFilterName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setGeoLocationFilterName(\CUCM\StructType\XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return $this->cdpnTransformationCssName;
    }
    /**
     * Set cdpnTransformationCssName value
     * @param \CUCM\StructType\XFkType $cdpnTransformationCssName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCdpnTransformationCssName(\CUCM\StructType\XFkType $cdpnTransformationCssName = null)
    {
        $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses \CUCM\EnumType\XPacketCaptureMode::valueIsValid()
     * @uses \CUCM\EnumType\XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setPacketCaptureMode($packetCaptureMode = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', \CUCM\EnumType\XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return $this->packetCaptureDuration;
    }
    /**
     * Set packetCaptureDuration value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setPacketCaptureDuration($packetCaptureDuration = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->packetCaptureDuration = $packetCaptureDuration;
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setSrtpAllowed($srtpAllowed = null)
    {
        // validation for constraint: pattern
        if (is_scalar($srtpAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($srtpAllowed, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($srtpAllowed) && !is_string($srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srtpAllowed)), __LINE__);
        }
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get waitForFarEndH245TerminalSet value
     * @return string|null
     */
    public function getWaitForFarEndH245TerminalSet()
    {
        return $this->waitForFarEndH245TerminalSet;
    }
    /**
     * Set waitForFarEndH245TerminalSet value
     * @param string $waitForFarEndH245TerminalSet
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setWaitForFarEndH245TerminalSet($waitForFarEndH245TerminalSet = null)
    {
        // validation for constraint: pattern
        if (is_scalar($waitForFarEndH245TerminalSet) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $waitForFarEndH245TerminalSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($waitForFarEndH245TerminalSet, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($waitForFarEndH245TerminalSet) && !is_string($waitForFarEndH245TerminalSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($waitForFarEndH245TerminalSet)), __LINE__);
        }
        $this->waitForFarEndH245TerminalSet = $waitForFarEndH245TerminalSet;
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setMtpRequired($mtpRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mtpRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($mtpRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mtpRequired) && !is_string($mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mtpRequired)), __LINE__);
        }
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerIdDn) && strlen($callerIdDn) > 50) || (is_array($callerIdDn) && count($callerIdDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callerIdDn) ? strlen($callerIdDn) : count($callerIdDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdDn)), __LINE__);
        }
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses \CUCM\EnumType\XCallingPartySelection::valueIsValid()
     * @uses \CUCM\EnumType\XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartySelection, implode(', ', \CUCM\EnumType\XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingLineIdPresentation value
     * @return string|null
     */
    public function getCallingLineIdPresentation()
    {
        return $this->callingLineIdPresentation;
    }
    /**
     * Set callingLineIdPresentation value
     * @uses \CUCM\EnumType\XPresentationBit::valueIsValid()
     * @uses \CUCM\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLineIdPresentation
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingLineIdPresentation($callingLineIdPresentation = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPresentationBit::valueIsValid($callingLineIdPresentation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingLineIdPresentation, implode(', ', \CUCM\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLineIdPresentation = $callingLineIdPresentation;
        return $this;
    }
    /**
     * Get enableInboundFaststart value
     * @return string|null
     */
    public function getEnableInboundFaststart()
    {
        return $this->enableInboundFaststart;
    }
    /**
     * Set enableInboundFaststart value
     * @param string $enableInboundFaststart
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setEnableInboundFaststart($enableInboundFaststart = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableInboundFaststart) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableInboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableInboundFaststart, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableInboundFaststart) && !is_string($enableInboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableInboundFaststart)), __LINE__);
        }
        $this->enableInboundFaststart = $enableInboundFaststart;
        return $this;
    }
    /**
     * Get enableOutboundFaststart value
     * @return string|null
     */
    public function getEnableOutboundFaststart()
    {
        return $this->enableOutboundFaststart;
    }
    /**
     * Set enableOutboundFaststart value
     * @param string $enableOutboundFaststart
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setEnableOutboundFaststart($enableOutboundFaststart = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableOutboundFaststart) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableOutboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableOutboundFaststart, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableOutboundFaststart) && !is_string($enableOutboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableOutboundFaststart)), __LINE__);
        }
        $this->enableOutboundFaststart = $enableOutboundFaststart;
        return $this;
    }
    /**
     * Get codecForOutboundFaststart value
     * @return string|null
     */
    public function getCodecForOutboundFaststart()
    {
        return $this->codecForOutboundFaststart;
    }
    /**
     * Set codecForOutboundFaststart value
     * @uses \CUCM\EnumType\XMediaPayload::valueIsValid()
     * @uses \CUCM\EnumType\XMediaPayload::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codecForOutboundFaststart
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCodecForOutboundFaststart($codecForOutboundFaststart = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMediaPayload::valueIsValid($codecForOutboundFaststart)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $codecForOutboundFaststart, implode(', ', \CUCM\EnumType\XMediaPayload::getValidValues())), __LINE__);
        }
        $this->codecForOutboundFaststart = $codecForOutboundFaststart;
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setTransmitUtf8($transmitUtf8 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($transmitUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($transmitUtf8, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transmitUtf8) && !is_string($transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmitUtf8)), __LINE__);
        }
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get signalingPort value
     * @return string|null
     */
    public function getSignalingPort()
    {
        return $this->signalingPort;
    }
    /**
     * Set signalingPort value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $signalingPort
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setSignalingPort($signalingPort = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($signalingPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $signalingPort, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->signalingPort = $signalingPort;
        return $this;
    }
    /**
     * Get allowH235PassThrough value
     * @return string|null
     */
    public function getAllowH235PassThrough()
    {
        return $this->allowH235PassThrough;
    }
    /**
     * Set allowH235PassThrough value
     * @param string $allowH235PassThrough
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setAllowH235PassThrough($allowH235PassThrough = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowH235PassThrough) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowH235PassThrough)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowH235PassThrough, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowH235PassThrough) && !is_string($allowH235PassThrough)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowH235PassThrough)), __LINE__);
        }
        $this->allowH235PassThrough = $allowH235PassThrough;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return \CUCM\StructType\SigDigits|null
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param \CUCM\StructType\SigDigits $sigDigits
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setSigDigits(\CUCM\StructType\SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get prefixDn value
     * @return string|null
     */
    public function getPrefixDn()
    {
        return $this->prefixDn;
    }
    /**
     * Set prefixDn value
     * @param string $prefixDn
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setPrefixDn($prefixDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prefixDn) && strlen($prefixDn) > 50) || (is_array($prefixDn) && count($prefixDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($prefixDn) ? strlen($prefixDn) : count($prefixDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prefixDn) && !is_string($prefixDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDn)), __LINE__);
        }
        $this->prefixDn = $prefixDn;
        return $this;
    }
    /**
     * Get calledPartyIeNumberType value
     * @return string|null
     */
    public function getCalledPartyIeNumberType()
    {
        return $this->calledPartyIeNumberType;
    }
    /**
     * Set calledPartyIeNumberType value
     * @uses \CUCM\EnumType\XPriOfNumber::valueIsValid()
     * @uses \CUCM\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyIeNumberType
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCalledPartyIeNumberType($calledPartyIeNumberType = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPriOfNumber::valueIsValid($calledPartyIeNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyIeNumberType, implode(', ', \CUCM\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyIeNumberType = $calledPartyIeNumberType;
        return $this;
    }
    /**
     * Get callingPartyIeNumberType value
     * @return string|null
     */
    public function getCallingPartyIeNumberType()
    {
        return $this->callingPartyIeNumberType;
    }
    /**
     * Set callingPartyIeNumberType value
     * @uses \CUCM\EnumType\XPriOfNumber::valueIsValid()
     * @uses \CUCM\EnumType\XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyIeNumberType
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingPartyIeNumberType($callingPartyIeNumberType = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPriOfNumber::valueIsValid($callingPartyIeNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyIeNumberType, implode(', ', \CUCM\EnumType\XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPartyIeNumberType = $callingPartyIeNumberType;
        return $this;
    }
    /**
     * Get calledNumberingPlan value
     * @return string|null
     */
    public function getCalledNumberingPlan()
    {
        return $this->calledNumberingPlan;
    }
    /**
     * Set calledNumberingPlan value
     * @uses \CUCM\EnumType\XNumberingPlan::valueIsValid()
     * @uses \CUCM\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledNumberingPlan
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCalledNumberingPlan($calledNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XNumberingPlan::valueIsValid($calledNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledNumberingPlan, implode(', ', \CUCM\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledNumberingPlan = $calledNumberingPlan;
        return $this;
    }
    /**
     * Get callingNumberingPlan value
     * @return string|null
     */
    public function getCallingNumberingPlan()
    {
        return $this->callingNumberingPlan;
    }
    /**
     * Set callingNumberingPlan value
     * @uses \CUCM\EnumType\XNumberingPlan::valueIsValid()
     * @uses \CUCM\EnumType\XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingNumberingPlan
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingNumberingPlan($callingNumberingPlan = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XNumberingPlan::valueIsValid($callingNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingNumberingPlan, implode(', ', \CUCM\EnumType\XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingNumberingPlan = $callingNumberingPlan;
        return $this;
    }
    /**
     * Get callingPartyNationalPrefix value
     * @return string|null
     */
    public function getCallingPartyNationalPrefix()
    {
        return $this->callingPartyNationalPrefix;
    }
    /**
     * Set callingPartyNationalPrefix value
     * @param string $callingPartyNationalPrefix
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingPartyNationalPrefix($callingPartyNationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyNationalPrefix) && strlen($callingPartyNationalPrefix) > 16) || (is_array($callingPartyNationalPrefix) && count($callingPartyNationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartyNationalPrefix) ? strlen($callingPartyNationalPrefix) : count($callingPartyNationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyNationalPrefix) && !is_string($callingPartyNationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyNationalPrefix)), __LINE__);
        }
        $this->callingPartyNationalPrefix = $callingPartyNationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyInternationalPrefix value
     * @return string|null
     */
    public function getCallingPartyInternationalPrefix()
    {
        return $this->callingPartyInternationalPrefix;
    }
    /**
     * Set callingPartyInternationalPrefix value
     * @param string $callingPartyInternationalPrefix
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingPartyInternationalPrefix($callingPartyInternationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyInternationalPrefix) && strlen($callingPartyInternationalPrefix) > 16) || (is_array($callingPartyInternationalPrefix) && count($callingPartyInternationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartyInternationalPrefix) ? strlen($callingPartyInternationalPrefix) : count($callingPartyInternationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyInternationalPrefix) && !is_string($callingPartyInternationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyInternationalPrefix)), __LINE__);
        }
        $this->callingPartyInternationalPrefix = $callingPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get callingPartyUnknownPrefix value
     * @return string|null
     */
    public function getCallingPartyUnknownPrefix()
    {
        return $this->callingPartyUnknownPrefix;
    }
    /**
     * Set callingPartyUnknownPrefix value
     * @param string $callingPartyUnknownPrefix
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingPartyUnknownPrefix($callingPartyUnknownPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartyUnknownPrefix) && strlen($callingPartyUnknownPrefix) > 16) || (is_array($callingPartyUnknownPrefix) && count($callingPartyUnknownPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartyUnknownPrefix) ? strlen($callingPartyUnknownPrefix) : count($callingPartyUnknownPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartyUnknownPrefix) && !is_string($callingPartyUnknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartyUnknownPrefix)), __LINE__);
        }
        $this->callingPartyUnknownPrefix = $callingPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get callingPartySubscriberPrefix value
     * @return string|null
     */
    public function getCallingPartySubscriberPrefix()
    {
        return $this->callingPartySubscriberPrefix;
    }
    /**
     * Set callingPartySubscriberPrefix value
     * @param string $callingPartySubscriberPrefix
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingPartySubscriberPrefix($callingPartySubscriberPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callingPartySubscriberPrefix) && strlen($callingPartySubscriberPrefix) > 16) || (is_array($callingPartySubscriberPrefix) && count($callingPartySubscriberPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($callingPartySubscriberPrefix) ? strlen($callingPartySubscriberPrefix) : count($callingPartySubscriberPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callingPartySubscriberPrefix) && !is_string($callingPartySubscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callingPartySubscriberPrefix)), __LINE__);
        }
        $this->callingPartySubscriberPrefix = $callingPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get callingPartyNationalStripDigits value
     * @return string|null
     */
    public function getCallingPartyNationalStripDigits()
    {
        return $this->callingPartyNationalStripDigits;
    }
    /**
     * Set callingPartyNationalStripDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyNationalStripDigits
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingPartyNationalStripDigits($callingPartyNationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($callingPartyNationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyNationalStripDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callingPartyNationalStripDigits = $callingPartyNationalStripDigits;
        return $this;
    }
    /**
     * Get callingPartyInternationalStripDigits value
     * @return string|null
     */
    public function getCallingPartyInternationalStripDigits()
    {
        return $this->callingPartyInternationalStripDigits;
    }
    /**
     * Set callingPartyInternationalStripDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyInternationalStripDigits
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingPartyInternationalStripDigits($callingPartyInternationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($callingPartyInternationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyInternationalStripDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callingPartyInternationalStripDigits = $callingPartyInternationalStripDigits;
        return $this;
    }
    /**
     * Get callingPartyUnknownStripDigits value
     * @return string|null
     */
    public function getCallingPartyUnknownStripDigits()
    {
        return $this->callingPartyUnknownStripDigits;
    }
    /**
     * Set callingPartyUnknownStripDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartyUnknownStripDigits
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingPartyUnknownStripDigits($callingPartyUnknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($callingPartyUnknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartyUnknownStripDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callingPartyUnknownStripDigits = $callingPartyUnknownStripDigits;
        return $this;
    }
    /**
     * Get callingPartySubscriberStripDigits value
     * @return string|null
     */
    public function getCallingPartySubscriberStripDigits()
    {
        return $this->callingPartySubscriberStripDigits;
    }
    /**
     * Set callingPartySubscriberStripDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySubscriberStripDigits
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingPartySubscriberStripDigits($callingPartySubscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($callingPartySubscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartySubscriberStripDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callingPartySubscriberStripDigits = $callingPartySubscriberStripDigits;
        return $this;
    }
    /**
     * Get callingPartyNationalTransformationCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCallingPartyNationalTransformationCssName()
    {
        return $this->callingPartyNationalTransformationCssName;
    }
    /**
     * Set callingPartyNationalTransformationCssName value
     * @param \CUCM\StructType\XFkType $callingPartyNationalTransformationCssName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingPartyNationalTransformationCssName(\CUCM\StructType\XFkType $callingPartyNationalTransformationCssName = null)
    {
        $this->callingPartyNationalTransformationCssName = $callingPartyNationalTransformationCssName;
        return $this;
    }
    /**
     * Get callingPartyInternationalTransformationCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCallingPartyInternationalTransformationCssName()
    {
        return $this->callingPartyInternationalTransformationCssName;
    }
    /**
     * Set callingPartyInternationalTransformationCssName value
     * @param \CUCM\StructType\XFkType $callingPartyInternationalTransformationCssName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingPartyInternationalTransformationCssName(\CUCM\StructType\XFkType $callingPartyInternationalTransformationCssName = null)
    {
        $this->callingPartyInternationalTransformationCssName = $callingPartyInternationalTransformationCssName;
        return $this;
    }
    /**
     * Get callingPartyUnknownTransformationCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCallingPartyUnknownTransformationCssName()
    {
        return $this->callingPartyUnknownTransformationCssName;
    }
    /**
     * Set callingPartyUnknownTransformationCssName value
     * @param \CUCM\StructType\XFkType $callingPartyUnknownTransformationCssName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingPartyUnknownTransformationCssName(\CUCM\StructType\XFkType $callingPartyUnknownTransformationCssName = null)
    {
        $this->callingPartyUnknownTransformationCssName = $callingPartyUnknownTransformationCssName;
        return $this;
    }
    /**
     * Get callingPartySubscriberTransformationCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCallingPartySubscriberTransformationCssName()
    {
        return $this->callingPartySubscriberTransformationCssName;
    }
    /**
     * Set callingPartySubscriberTransformationCssName value
     * @param \CUCM\StructType\XFkType $callingPartySubscriberTransformationCssName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCallingPartySubscriberTransformationCssName(\CUCM\StructType\XFkType $callingPartySubscriberTransformationCssName = null)
    {
        $this->callingPartySubscriberTransformationCssName = $callingPartySubscriberTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartyNationalPrefix value
     * @return string|null
     */
    public function getCalledPartyNationalPrefix()
    {
        return $this->calledPartyNationalPrefix;
    }
    /**
     * Set calledPartyNationalPrefix value
     * @param string $calledPartyNationalPrefix
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCalledPartyNationalPrefix($calledPartyNationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($calledPartyNationalPrefix) && strlen($calledPartyNationalPrefix) > 16) || (is_array($calledPartyNationalPrefix) && count($calledPartyNationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($calledPartyNationalPrefix) ? strlen($calledPartyNationalPrefix) : count($calledPartyNationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calledPartyNationalPrefix) && !is_string($calledPartyNationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyNationalPrefix)), __LINE__);
        }
        $this->calledPartyNationalPrefix = $calledPartyNationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyInternationalPrefix value
     * @return string|null
     */
    public function getCalledPartyInternationalPrefix()
    {
        return $this->calledPartyInternationalPrefix;
    }
    /**
     * Set calledPartyInternationalPrefix value
     * @param string $calledPartyInternationalPrefix
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCalledPartyInternationalPrefix($calledPartyInternationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($calledPartyInternationalPrefix) && strlen($calledPartyInternationalPrefix) > 16) || (is_array($calledPartyInternationalPrefix) && count($calledPartyInternationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($calledPartyInternationalPrefix) ? strlen($calledPartyInternationalPrefix) : count($calledPartyInternationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calledPartyInternationalPrefix) && !is_string($calledPartyInternationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyInternationalPrefix)), __LINE__);
        }
        $this->calledPartyInternationalPrefix = $calledPartyInternationalPrefix;
        return $this;
    }
    /**
     * Get calledPartyUnknownPrefix value
     * @return string|null
     */
    public function getCalledPartyUnknownPrefix()
    {
        return $this->calledPartyUnknownPrefix;
    }
    /**
     * Set calledPartyUnknownPrefix value
     * @param string $calledPartyUnknownPrefix
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCalledPartyUnknownPrefix($calledPartyUnknownPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($calledPartyUnknownPrefix) && strlen($calledPartyUnknownPrefix) > 16) || (is_array($calledPartyUnknownPrefix) && count($calledPartyUnknownPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($calledPartyUnknownPrefix) ? strlen($calledPartyUnknownPrefix) : count($calledPartyUnknownPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calledPartyUnknownPrefix) && !is_string($calledPartyUnknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyUnknownPrefix)), __LINE__);
        }
        $this->calledPartyUnknownPrefix = $calledPartyUnknownPrefix;
        return $this;
    }
    /**
     * Get calledPartySubscriberPrefix value
     * @return string|null
     */
    public function getCalledPartySubscriberPrefix()
    {
        return $this->calledPartySubscriberPrefix;
    }
    /**
     * Set calledPartySubscriberPrefix value
     * @param string $calledPartySubscriberPrefix
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCalledPartySubscriberPrefix($calledPartySubscriberPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($calledPartySubscriberPrefix) && strlen($calledPartySubscriberPrefix) > 16) || (is_array($calledPartySubscriberPrefix) && count($calledPartySubscriberPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($calledPartySubscriberPrefix) ? strlen($calledPartySubscriberPrefix) : count($calledPartySubscriberPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($calledPartySubscriberPrefix) && !is_string($calledPartySubscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartySubscriberPrefix)), __LINE__);
        }
        $this->calledPartySubscriberPrefix = $calledPartySubscriberPrefix;
        return $this;
    }
    /**
     * Get calledPartyNationalStripDigits value
     * @return string|null
     */
    public function getCalledPartyNationalStripDigits()
    {
        return $this->calledPartyNationalStripDigits;
    }
    /**
     * Set calledPartyNationalStripDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNationalStripDigits
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCalledPartyNationalStripDigits($calledPartyNationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($calledPartyNationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNationalStripDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->calledPartyNationalStripDigits = $calledPartyNationalStripDigits;
        return $this;
    }
    /**
     * Get calledPartyInternationalStripDigits value
     * @return string|null
     */
    public function getCalledPartyInternationalStripDigits()
    {
        return $this->calledPartyInternationalStripDigits;
    }
    /**
     * Set calledPartyInternationalStripDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyInternationalStripDigits
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCalledPartyInternationalStripDigits($calledPartyInternationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($calledPartyInternationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyInternationalStripDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->calledPartyInternationalStripDigits = $calledPartyInternationalStripDigits;
        return $this;
    }
    /**
     * Get calledPartyUnknownStripDigits value
     * @return string|null
     */
    public function getCalledPartyUnknownStripDigits()
    {
        return $this->calledPartyUnknownStripDigits;
    }
    /**
     * Set calledPartyUnknownStripDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyUnknownStripDigits
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCalledPartyUnknownStripDigits($calledPartyUnknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($calledPartyUnknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyUnknownStripDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->calledPartyUnknownStripDigits = $calledPartyUnknownStripDigits;
        return $this;
    }
    /**
     * Get calledPartySubscriberStripDigits value
     * @return string|null
     */
    public function getCalledPartySubscriberStripDigits()
    {
        return $this->calledPartySubscriberStripDigits;
    }
    /**
     * Set calledPartySubscriberStripDigits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartySubscriberStripDigits
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCalledPartySubscriberStripDigits($calledPartySubscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($calledPartySubscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartySubscriberStripDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->calledPartySubscriberStripDigits = $calledPartySubscriberStripDigits;
        return $this;
    }
    /**
     * Get calledPartyNationalTransformationCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCalledPartyNationalTransformationCssName()
    {
        return $this->calledPartyNationalTransformationCssName;
    }
    /**
     * Set calledPartyNationalTransformationCssName value
     * @param \CUCM\StructType\XFkType $calledPartyNationalTransformationCssName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCalledPartyNationalTransformationCssName(\CUCM\StructType\XFkType $calledPartyNationalTransformationCssName = null)
    {
        $this->calledPartyNationalTransformationCssName = $calledPartyNationalTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartyInternationalTransformationCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCalledPartyInternationalTransformationCssName()
    {
        return $this->calledPartyInternationalTransformationCssName;
    }
    /**
     * Set calledPartyInternationalTransformationCssName value
     * @param \CUCM\StructType\XFkType $calledPartyInternationalTransformationCssName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCalledPartyInternationalTransformationCssName(\CUCM\StructType\XFkType $calledPartyInternationalTransformationCssName = null)
    {
        $this->calledPartyInternationalTransformationCssName = $calledPartyInternationalTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartyUnknownTransformationCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCalledPartyUnknownTransformationCssName()
    {
        return $this->calledPartyUnknownTransformationCssName;
    }
    /**
     * Set calledPartyUnknownTransformationCssName value
     * @param \CUCM\StructType\XFkType $calledPartyUnknownTransformationCssName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCalledPartyUnknownTransformationCssName(\CUCM\StructType\XFkType $calledPartyUnknownTransformationCssName = null)
    {
        $this->calledPartyUnknownTransformationCssName = $calledPartyUnknownTransformationCssName;
        return $this;
    }
    /**
     * Get calledPartySubscriberTransformationCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCalledPartySubscriberTransformationCssName()
    {
        return $this->calledPartySubscriberTransformationCssName;
    }
    /**
     * Set calledPartySubscriberTransformationCssName value
     * @param \CUCM\StructType\XFkType $calledPartySubscriberTransformationCssName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCalledPartySubscriberTransformationCssName(\CUCM\StructType\XFkType $calledPartySubscriberTransformationCssName = null)
    {
        $this->calledPartySubscriberTransformationCssName = $calledPartySubscriberTransformationCssName;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setPstnAccess($pstnAccess = null)
    {
        // validation for constraint: pattern
        if (is_scalar($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pstnAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnAccess)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return $this->imeE164TransformationName;
    }
    /**
     * Set imeE164TransformationName value
     * @param \CUCM\StructType\XFkType $imeE164TransformationName
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setImeE164TransformationName(\CUCM\StructType\XFkType $imeE164TransformationName = null)
    {
        $this->imeE164TransformationName = $imeE164TransformationName;
        return $this;
    }
    /**
     * Get displayIeDelivery value
     * @return string|null
     */
    public function getDisplayIeDelivery()
    {
        return $this->displayIeDelivery;
    }
    /**
     * Set displayIeDelivery value
     * @param string $displayIeDelivery
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setDisplayIeDelivery($displayIeDelivery = null)
    {
        // validation for constraint: pattern
        if (is_scalar($displayIeDelivery) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $displayIeDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($displayIeDelivery, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($displayIeDelivery) && !is_string($displayIeDelivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayIeDelivery)), __LINE__);
        }
        $this->displayIeDelivery = $displayIeDelivery;
        return $this;
    }
    /**
     * Get redirectOutboundNumberIe value
     * @return string|null
     */
    public function getRedirectOutboundNumberIe()
    {
        return $this->redirectOutboundNumberIe;
    }
    /**
     * Set redirectOutboundNumberIe value
     * @param string $redirectOutboundNumberIe
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setRedirectOutboundNumberIe($redirectOutboundNumberIe = null)
    {
        // validation for constraint: pattern
        if (is_scalar($redirectOutboundNumberIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectOutboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($redirectOutboundNumberIe, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($redirectOutboundNumberIe) && !is_string($redirectOutboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redirectOutboundNumberIe)), __LINE__);
        }
        $this->redirectOutboundNumberIe = $redirectOutboundNumberIe;
        return $this;
    }
    /**
     * Get redirectInboundNumberIe value
     * @return string|null
     */
    public function getRedirectInboundNumberIe()
    {
        return $this->redirectInboundNumberIe;
    }
    /**
     * Set redirectInboundNumberIe value
     * @param string $redirectInboundNumberIe
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setRedirectInboundNumberIe($redirectInboundNumberIe = null)
    {
        // validation for constraint: pattern
        if (is_scalar($redirectInboundNumberIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectInboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($redirectInboundNumberIe, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($redirectInboundNumberIe) && !is_string($redirectInboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redirectInboundNumberIe)), __LINE__);
        }
        $this->redirectInboundNumberIe = $redirectInboundNumberIe;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssNatl()
    {
        return $this->useDevicePoolCgpnTransformCssNatl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssNatl value
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssNatl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssNatl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssNatl) && !is_string($useDevicePoolCgpnTransformCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssNatl)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssNatl = $useDevicePoolCgpnTransformCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssIntl()
    {
        return $this->useDevicePoolCgpnTransformCssIntl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssIntl value
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssIntl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssIntl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssIntl) && !is_string($useDevicePoolCgpnTransformCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssIntl)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssIntl = $useDevicePoolCgpnTransformCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssUnkn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssUnkn) && !is_string($useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssUnkn)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssSubs()
    {
        return $this->useDevicePoolCgpnTransformCssSubs;
    }
    /**
     * Set useDevicePoolCgpnTransformCssSubs value
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssSubs) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssSubs, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssSubs) && !is_string($useDevicePoolCgpnTransformCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssSubs)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssSubs = $useDevicePoolCgpnTransformCssSubs;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssNatl()
    {
        return $this->useDevicePoolCalledCssNatl;
    }
    /**
     * Set useDevicePoolCalledCssNatl value
     * @param string $useDevicePoolCalledCssNatl
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setUseDevicePoolCalledCssNatl($useDevicePoolCalledCssNatl = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCalledCssNatl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCalledCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCalledCssNatl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCalledCssNatl) && !is_string($useDevicePoolCalledCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCalledCssNatl)), __LINE__);
        }
        $this->useDevicePoolCalledCssNatl = $useDevicePoolCalledCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssIntl()
    {
        return $this->useDevicePoolCalledCssIntl;
    }
    /**
     * Set useDevicePoolCalledCssIntl value
     * @param string $useDevicePoolCalledCssIntl
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setUseDevicePoolCalledCssIntl($useDevicePoolCalledCssIntl = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCalledCssIntl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCalledCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCalledCssIntl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCalledCssIntl) && !is_string($useDevicePoolCalledCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCalledCssIntl)), __LINE__);
        }
        $this->useDevicePoolCalledCssIntl = $useDevicePoolCalledCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssUnkn()
    {
        return $this->useDevicePoolCalledCssUnkn;
    }
    /**
     * Set useDevicePoolCalledCssUnkn value
     * @param string $useDevicePoolCalledCssUnkn
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setUseDevicePoolCalledCssUnkn($useDevicePoolCalledCssUnkn = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCalledCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCalledCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCalledCssUnkn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCalledCssUnkn) && !is_string($useDevicePoolCalledCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCalledCssUnkn)), __LINE__);
        }
        $this->useDevicePoolCalledCssUnkn = $useDevicePoolCalledCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCalledCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCalledCssSubs()
    {
        return $this->useDevicePoolCalledCssSubs;
    }
    /**
     * Set useDevicePoolCalledCssSubs value
     * @param string $useDevicePoolCalledCssSubs
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setUseDevicePoolCalledCssSubs($useDevicePoolCalledCssSubs = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCalledCssSubs) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCalledCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCalledCssSubs, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCalledCssSubs) && !is_string($useDevicePoolCalledCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCalledCssSubs)), __LINE__);
        }
        $this->useDevicePoolCalledCssSubs = $useDevicePoolCalledCssSubs;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RH323Gateway
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RH323Gateway
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
