<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFixedMohAudioSource StructType
 * @subpackage Structs
 */
class RFixedMohAudioSource extends AbstractStructBase
{
    /**
     * The sourceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sourceId;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The multicast
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $multicast;
    /**
     * The enable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $enable;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RFixedMohAudioSource
     * @uses RFixedMohAudioSource::setSourceId()
     * @uses RFixedMohAudioSource::setName()
     * @uses RFixedMohAudioSource::setMulticast()
     * @uses RFixedMohAudioSource::setEnable()
     * @uses RFixedMohAudioSource::setUuid()
     * @param string $sourceId
     * @param string $name
     * @param string $multicast
     * @param string $enable
     * @param string $uuid
     */
    public function __construct($sourceId = null, $name = null, $multicast = null, $enable = null, $uuid = null)
    {
        $this
            ->setSourceId($sourceId)
            ->setName($name)
            ->setMulticast($multicast)
            ->setEnable($enable)
            ->setUuid($uuid);
    }
    /**
     * Get sourceId value
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->sourceId;
    }
    /**
     * Set sourceId value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceId
     * @return \CUCM\StructType\RFixedMohAudioSource
     */
    public function setSourceId($sourceId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($sourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sourceId, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->sourceId = $sourceId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RFixedMohAudioSource
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get multicast value
     * @return string|null
     */
    public function getMulticast()
    {
        return $this->multicast;
    }
    /**
     * Set multicast value
     * @param string $multicast
     * @return \CUCM\StructType\RFixedMohAudioSource
     */
    public function setMulticast($multicast = null)
    {
        // validation for constraint: pattern
        if (is_scalar($multicast) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($multicast, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($multicast) && !is_string($multicast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($multicast)), __LINE__);
        }
        $this->multicast = $multicast;
        return $this;
    }
    /**
     * Get enable value
     * @return string|null
     */
    public function getEnable()
    {
        return $this->enable;
    }
    /**
     * Set enable value
     * @param string $enable
     * @return \CUCM\StructType\RFixedMohAudioSource
     */
    public function setEnable($enable = null)
    {
        // validation for constraint: string
        if (!is_null($enable) && !is_string($enable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enable)), __LINE__);
        }
        $this->enable = $enable;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RFixedMohAudioSource
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RFixedMohAudioSource
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
