<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RDeviceProfile StructType
 * @subpackage Structs
 */
class RDeviceProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The versionStamp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $versionStamp;
    /**
     * The traceFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The lines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Lines
     */
    public $lines;
    /**
     * The numberOfButtons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numberOfButtons;
    /**
     * The phoneTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $phoneTemplateName;
    /**
     * The speeddials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Speeddials
     */
    public $speeddials;
    /**
     * The busyLampFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\BusyLampFields
     */
    public $busyLampFields;
    /**
     * The blfDirectedCallParks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\BlfDirectedCallParks
     */
    public $blfDirectedCallParks;
    /**
     * The addOnModules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AddOnModules
     */
    public $addOnModules;
    /**
     * The userlocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userlocale;
    /**
     * The defaultProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $defaultProfileName;
    /**
     * The currentProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $currentProfileName;
    /**
     * The loginTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginTime;
    /**
     * The loginDuration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loginDuration;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The loginUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $loginUserId;
    /**
     * The ignorePresentationIndicators
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePresentationIndicators;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndOption;
    /**
     * The dndRingSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dndRingSetting;
    /**
     * The dndStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The emccCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $emccCallingSearchSpace;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $softkeyTemplateName;
    /**
     * The callInfoPrivacyStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $callInfoPrivacyStatus;
    /**
     * The currentConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\CurrentConfig
     */
    public $currentConfig;
    /**
     * The services
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Services
     */
    public $services;
    /**
     * The featureControlPolicy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $featureControlPolicy;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RDeviceProfile
     * @uses RDeviceProfile::setName()
     * @uses RDeviceProfile::setDescription()
     * @uses RDeviceProfile::setProduct()
     * @uses RDeviceProfile::setModel()
     * @uses RDeviceProfile::setClass()
     * @uses RDeviceProfile::setProtocol()
     * @uses RDeviceProfile::setProtocolSide()
     * @uses RDeviceProfile::setUserHoldMohAudioSourceId()
     * @uses RDeviceProfile::setVendorConfig()
     * @uses RDeviceProfile::setVersionStamp()
     * @uses RDeviceProfile::setTraceFlag()
     * @uses RDeviceProfile::setMlppDomainId()
     * @uses RDeviceProfile::setMlppIndicationStatus()
     * @uses RDeviceProfile::setPreemption()
     * @uses RDeviceProfile::setLines()
     * @uses RDeviceProfile::setNumberOfButtons()
     * @uses RDeviceProfile::setPhoneTemplateName()
     * @uses RDeviceProfile::setSpeeddials()
     * @uses RDeviceProfile::setBusyLampFields()
     * @uses RDeviceProfile::setBlfDirectedCallParks()
     * @uses RDeviceProfile::setAddOnModules()
     * @uses RDeviceProfile::setUserlocale()
     * @uses RDeviceProfile::setDefaultProfileName()
     * @uses RDeviceProfile::setCurrentProfileName()
     * @uses RDeviceProfile::setLoginTime()
     * @uses RDeviceProfile::setLoginDuration()
     * @uses RDeviceProfile::setSingleButtonBarge()
     * @uses RDeviceProfile::setJoinAcrossLines()
     * @uses RDeviceProfile::setLoginUserId()
     * @uses RDeviceProfile::setIgnorePresentationIndicators()
     * @uses RDeviceProfile::setDndOption()
     * @uses RDeviceProfile::setDndRingSetting()
     * @uses RDeviceProfile::setDndStatus()
     * @uses RDeviceProfile::setEmccCallingSearchSpace()
     * @uses RDeviceProfile::setAlwaysUsePrimeLine()
     * @uses RDeviceProfile::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses RDeviceProfile::setSoftkeyTemplateName()
     * @uses RDeviceProfile::setCallInfoPrivacyStatus()
     * @uses RDeviceProfile::setCurrentConfig()
     * @uses RDeviceProfile::setServices()
     * @uses RDeviceProfile::setFeatureControlPolicy()
     * @uses RDeviceProfile::setCtiid()
     * @uses RDeviceProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param string $userHoldMohAudioSourceId
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @param string $versionStamp
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param \CUCM\StructType\Lines $lines
     * @param string $numberOfButtons
     * @param \CUCM\StructType\XFkType $phoneTemplateName
     * @param \CUCM\StructType\Speeddials $speeddials
     * @param \CUCM\StructType\BusyLampFields $busyLampFields
     * @param \CUCM\StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @param \CUCM\StructType\AddOnModules $addOnModules
     * @param string $userlocale
     * @param string $defaultProfileName
     * @param \CUCM\StructType\XFkType $currentProfileName
     * @param string $loginTime
     * @param string $loginDuration
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param \CUCM\StructType\XFkType $loginUserId
     * @param string $ignorePresentationIndicators
     * @param string $dndOption
     * @param string $dndRingSetting
     * @param string $dndStatus
     * @param \CUCM\StructType\XFkType $emccCallingSearchSpace
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param \CUCM\StructType\XFkType $softkeyTemplateName
     * @param string $callInfoPrivacyStatus
     * @param \CUCM\StructType\CurrentConfig $currentConfig
     * @param \CUCM\StructType\Services $services
     * @param \CUCM\StructType\XFkType $featureControlPolicy
     * @param int $ctiid
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, $userHoldMohAudioSourceId = null, \CUCM\StructType\XVendorConfig $vendorConfig = null, $versionStamp = null, $traceFlag = null, $mlppDomainId = null, $mlppIndicationStatus = null, $preemption = null, \CUCM\StructType\Lines $lines = null, $numberOfButtons = null, \CUCM\StructType\XFkType $phoneTemplateName = null, \CUCM\StructType\Speeddials $speeddials = null, \CUCM\StructType\BusyLampFields $busyLampFields = null, \CUCM\StructType\BlfDirectedCallParks $blfDirectedCallParks = null, \CUCM\StructType\AddOnModules $addOnModules = null, $userlocale = null, $defaultProfileName = null, \CUCM\StructType\XFkType $currentProfileName = null, $loginTime = null, $loginDuration = null, $singleButtonBarge = null, $joinAcrossLines = null, \CUCM\StructType\XFkType $loginUserId = null, $ignorePresentationIndicators = null, $dndOption = null, $dndRingSetting = null, $dndStatus = null, \CUCM\StructType\XFkType $emccCallingSearchSpace = null, $alwaysUsePrimeLine = null, $alwaysUsePrimeLineForVoiceMessage = null, \CUCM\StructType\XFkType $softkeyTemplateName = null, $callInfoPrivacyStatus = null, \CUCM\StructType\CurrentConfig $currentConfig = null, \CUCM\StructType\Services $services = null, \CUCM\StructType\XFkType $featureControlPolicy = null, $ctiid = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setVendorConfig($vendorConfig)
            ->setVersionStamp($versionStamp)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setLines($lines)
            ->setNumberOfButtons($numberOfButtons)
            ->setPhoneTemplateName($phoneTemplateName)
            ->setSpeeddials($speeddials)
            ->setBusyLampFields($busyLampFields)
            ->setBlfDirectedCallParks($blfDirectedCallParks)
            ->setAddOnModules($addOnModules)
            ->setUserlocale($userlocale)
            ->setDefaultProfileName($defaultProfileName)
            ->setCurrentProfileName($currentProfileName)
            ->setLoginTime($loginTime)
            ->setLoginDuration($loginDuration)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setLoginUserId($loginUserId)
            ->setIgnorePresentationIndicators($ignorePresentationIndicators)
            ->setDndOption($dndOption)
            ->setDndRingSetting($dndRingSetting)
            ->setDndStatus($dndStatus)
            ->setEmccCallingSearchSpace($emccCallingSearchSpace)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setCallInfoPrivacyStatus($callInfoPrivacyStatus)
            ->setCurrentConfig($currentConfig)
            ->setServices($services)
            ->setFeatureControlPolicy($featureControlPolicy)
            ->setCtiid($ctiid)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \CUCM\EnumType\XProduct::valueIsValid()
     * @uses \CUCM\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \CUCM\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses \CUCM\EnumType\XModel::valueIsValid()
     * @uses \CUCM\EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $model, implode(', ', \CUCM\EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \CUCM\EnumType\XClass::valueIsValid()
     * @uses \CUCM\EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \CUCM\EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \CUCM\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \CUCM\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', \CUCM\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \CUCM\EnumType\XProtocolSide::valueIsValid()
     * @uses \CUCM\EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', \CUCM\EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @uses \CUCM\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \CUCM\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', \CUCM\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \CUCM\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setVendorConfig(\CUCM\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get versionStamp value
     * @return string|null
     */
    public function getVersionStamp()
    {
        return $this->versionStamp;
    }
    /**
     * Set versionStamp value
     * @param string $versionStamp
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setVersionStamp($versionStamp = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($versionStamp) && strlen($versionStamp) > 128) || (is_array($versionStamp) && count($versionStamp) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($versionStamp) ? strlen($versionStamp) : count($versionStamp)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($versionStamp) && !is_string($versionStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versionStamp)), __LINE__);
        }
        $this->versionStamp = $versionStamp;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($traceFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceFlag)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \CUCM\EnumType\XPreemption::valueIsValid()
     * @uses \CUCM\EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', \CUCM\EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get lines value
     * @return \CUCM\StructType\Lines|null
     */
    public function getLines()
    {
        return $this->lines;
    }
    /**
     * Set lines value
     * @param \CUCM\StructType\Lines $lines
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setLines(\CUCM\StructType\Lines $lines = null)
    {
        $this->lines = $lines;
        return $this;
    }
    /**
     * Get numberOfButtons value
     * @return string|null
     */
    public function getNumberOfButtons()
    {
        return $this->numberOfButtons;
    }
    /**
     * Set numberOfButtons value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfButtons
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setNumberOfButtons($numberOfButtons = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($numberOfButtons)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numberOfButtons, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numberOfButtons = $numberOfButtons;
        return $this;
    }
    /**
     * Get phoneTemplateName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getPhoneTemplateName()
    {
        return $this->phoneTemplateName;
    }
    /**
     * Set phoneTemplateName value
     * @param \CUCM\StructType\XFkType $phoneTemplateName
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setPhoneTemplateName(\CUCM\StructType\XFkType $phoneTemplateName = null)
    {
        $this->phoneTemplateName = $phoneTemplateName;
        return $this;
    }
    /**
     * Get speeddials value
     * @return \CUCM\StructType\Speeddials|null
     */
    public function getSpeeddials()
    {
        return $this->speeddials;
    }
    /**
     * Set speeddials value
     * @param \CUCM\StructType\Speeddials $speeddials
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setSpeeddials(\CUCM\StructType\Speeddials $speeddials = null)
    {
        $this->speeddials = $speeddials;
        return $this;
    }
    /**
     * Get busyLampFields value
     * @return \CUCM\StructType\BusyLampFields|null
     */
    public function getBusyLampFields()
    {
        return $this->busyLampFields;
    }
    /**
     * Set busyLampFields value
     * @param \CUCM\StructType\BusyLampFields $busyLampFields
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setBusyLampFields(\CUCM\StructType\BusyLampFields $busyLampFields = null)
    {
        $this->busyLampFields = $busyLampFields;
        return $this;
    }
    /**
     * Get blfDirectedCallParks value
     * @return \CUCM\StructType\BlfDirectedCallParks|null
     */
    public function getBlfDirectedCallParks()
    {
        return $this->blfDirectedCallParks;
    }
    /**
     * Set blfDirectedCallParks value
     * @param \CUCM\StructType\BlfDirectedCallParks $blfDirectedCallParks
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setBlfDirectedCallParks(\CUCM\StructType\BlfDirectedCallParks $blfDirectedCallParks = null)
    {
        $this->blfDirectedCallParks = $blfDirectedCallParks;
        return $this;
    }
    /**
     * Get addOnModules value
     * @return \CUCM\StructType\AddOnModules|null
     */
    public function getAddOnModules()
    {
        return $this->addOnModules;
    }
    /**
     * Set addOnModules value
     * @param \CUCM\StructType\AddOnModules $addOnModules
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setAddOnModules(\CUCM\StructType\AddOnModules $addOnModules = null)
    {
        $this->addOnModules = $addOnModules;
        return $this;
    }
    /**
     * Get userlocale value
     * @return string|null
     */
    public function getUserlocale()
    {
        return $this->userlocale;
    }
    /**
     * Set userlocale value
     * @uses \CUCM\EnumType\XUserLocale::valueIsValid()
     * @uses \CUCM\EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userlocale
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setUserlocale($userlocale = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XUserLocale::valueIsValid($userlocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userlocale, implode(', ', \CUCM\EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        $this->userlocale = $userlocale;
        return $this;
    }
    /**
     * Get defaultProfileName value
     * @return string|null
     */
    public function getDefaultProfileName()
    {
        return $this->defaultProfileName;
    }
    /**
     * Set defaultProfileName value
     * @param string $defaultProfileName
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setDefaultProfileName($defaultProfileName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($defaultProfileName) && strlen($defaultProfileName) > 50) || (is_array($defaultProfileName) && count($defaultProfileName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($defaultProfileName) ? strlen($defaultProfileName) : count($defaultProfileName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($defaultProfileName) && !is_string($defaultProfileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultProfileName)), __LINE__);
        }
        $this->defaultProfileName = $defaultProfileName;
        return $this;
    }
    /**
     * Get currentProfileName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCurrentProfileName()
    {
        return $this->currentProfileName;
    }
    /**
     * Set currentProfileName value
     * @param \CUCM\StructType\XFkType $currentProfileName
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setCurrentProfileName(\CUCM\StructType\XFkType $currentProfileName = null)
    {
        $this->currentProfileName = $currentProfileName;
        return $this;
    }
    /**
     * Get loginTime value
     * @return string|null
     */
    public function getLoginTime()
    {
        return $this->loginTime;
    }
    /**
     * Set loginTime value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loginTime
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setLoginTime($loginTime = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($loginTime)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $loginTime, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->loginTime = $loginTime;
        return $this;
    }
    /**
     * Get loginDuration value
     * @return string|null
     */
    public function getLoginDuration()
    {
        return $this->loginDuration;
    }
    /**
     * Set loginDuration value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loginDuration
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setLoginDuration($loginDuration = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($loginDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $loginDuration, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->loginDuration = $loginDuration;
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses \CUCM\EnumType\XBarge::valueIsValid()
     * @uses \CUCM\EnumType\XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setSingleButtonBarge($singleButtonBarge = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $singleButtonBarge, implode(', ', \CUCM\EnumType\XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setJoinAcrossLines($joinAcrossLines = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $joinAcrossLines, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get loginUserId value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getLoginUserId()
    {
        return $this->loginUserId;
    }
    /**
     * Set loginUserId value
     * @param \CUCM\StructType\XFkType $loginUserId
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setLoginUserId(\CUCM\StructType\XFkType $loginUserId = null)
    {
        $this->loginUserId = $loginUserId;
        return $this;
    }
    /**
     * Get ignorePresentationIndicators value
     * @return string|null
     */
    public function getIgnorePresentationIndicators()
    {
        return $this->ignorePresentationIndicators;
    }
    /**
     * Set ignorePresentationIndicators value
     * @param string $ignorePresentationIndicators
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setIgnorePresentationIndicators($ignorePresentationIndicators = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ignorePresentationIndicators) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ignorePresentationIndicators, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ignorePresentationIndicators) && !is_string($ignorePresentationIndicators)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ignorePresentationIndicators)), __LINE__);
        }
        $this->ignorePresentationIndicators = $ignorePresentationIndicators;
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses \CUCM\EnumType\XDNDOption::valueIsValid()
     * @uses \CUCM\EnumType\XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setDndOption($dndOption = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndOption, implode(', ', \CUCM\EnumType\XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * @return string|null
     */
    public function getDndRingSetting()
    {
        return $this->dndRingSetting;
    }
    /**
     * Set dndRingSetting value
     * @uses \CUCM\EnumType\XRingSetting::valueIsValid()
     * @uses \CUCM\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndRingSetting
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setDndRingSetting($dndRingSetting = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XRingSetting::valueIsValid($dndRingSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndRingSetting, implode(', ', \CUCM\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        $this->dndRingSetting = $dndRingSetting;
        return $this;
    }
    /**
     * Get dndStatus value
     * @return string|null
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setDndStatus($dndStatus = null)
    {
        // validation for constraint: pattern
        if (is_scalar($dndStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($dndStatus, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dndStatus) && !is_string($dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dndStatus)), __LINE__);
        }
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get emccCallingSearchSpace value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getEmccCallingSearchSpace()
    {
        return $this->emccCallingSearchSpace;
    }
    /**
     * Set emccCallingSearchSpace value
     * @param \CUCM\StructType\XFkType $emccCallingSearchSpace
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setEmccCallingSearchSpace(\CUCM\StructType\XFkType $emccCallingSearchSpace = null)
    {
        $this->emccCallingSearchSpace = $emccCallingSearchSpace;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLine, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLineForVoiceMessage, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param \CUCM\StructType\XFkType $softkeyTemplateName
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setSoftkeyTemplateName(\CUCM\StructType\XFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get callInfoPrivacyStatus value
     * @return string|null
     */
    public function getCallInfoPrivacyStatus()
    {
        return $this->callInfoPrivacyStatus;
    }
    /**
     * Set callInfoPrivacyStatus value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callInfoPrivacyStatus
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setCallInfoPrivacyStatus($callInfoPrivacyStatus = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($callInfoPrivacyStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callInfoPrivacyStatus, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->callInfoPrivacyStatus = $callInfoPrivacyStatus;
        return $this;
    }
    /**
     * Get currentConfig value
     * @return \CUCM\StructType\CurrentConfig|null
     */
    public function getCurrentConfig()
    {
        return $this->currentConfig;
    }
    /**
     * Set currentConfig value
     * @param \CUCM\StructType\CurrentConfig $currentConfig
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setCurrentConfig(\CUCM\StructType\CurrentConfig $currentConfig = null)
    {
        $this->currentConfig = $currentConfig;
        return $this;
    }
    /**
     * Get services value
     * @return \CUCM\StructType\Services|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \CUCM\StructType\Services $services
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setServices(\CUCM\StructType\Services $services = null)
    {
        $this->services = $services;
        return $this;
    }
    /**
     * Get featureControlPolicy value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getFeatureControlPolicy()
    {
        return $this->featureControlPolicy;
    }
    /**
     * Set featureControlPolicy value
     * @param \CUCM\StructType\XFkType $featureControlPolicy
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setFeatureControlPolicy(\CUCM\StructType\XFkType $featureControlPolicy = null)
    {
        $this->featureControlPolicy = $featureControlPolicy;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RDeviceProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RDeviceProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
