<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCiscoCatalyst600024PortFXSGateway StructType
 * @subpackage Structs
 */
class RCiscoCatalyst600024PortFXSGateway extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product;
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $model;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocale;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The versionStamp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $versionStamp;
    /**
     * The traceFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The ports
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Ports
     */
    public $ports;
    /**
     * The portSelectionOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $portSelectionOrder;
    /**
     * The transmitUtf8
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCiscoCatalyst600024PortFXSGateway
     * @uses RCiscoCatalyst600024PortFXSGateway::setName()
     * @uses RCiscoCatalyst600024PortFXSGateway::setDescription()
     * @uses RCiscoCatalyst600024PortFXSGateway::setProduct()
     * @uses RCiscoCatalyst600024PortFXSGateway::setModel()
     * @uses RCiscoCatalyst600024PortFXSGateway::setClass()
     * @uses RCiscoCatalyst600024PortFXSGateway::setProtocol()
     * @uses RCiscoCatalyst600024PortFXSGateway::setProtocolSide()
     * @uses RCiscoCatalyst600024PortFXSGateway::setCallingSearchSpaceName()
     * @uses RCiscoCatalyst600024PortFXSGateway::setDevicePoolName()
     * @uses RCiscoCatalyst600024PortFXSGateway::setCommonDeviceConfigName()
     * @uses RCiscoCatalyst600024PortFXSGateway::setNetworkLocale()
     * @uses RCiscoCatalyst600024PortFXSGateway::setLocationName()
     * @uses RCiscoCatalyst600024PortFXSGateway::setMediaResourceListName()
     * @uses RCiscoCatalyst600024PortFXSGateway::setAutomatedAlternateRoutingCssName()
     * @uses RCiscoCatalyst600024PortFXSGateway::setAarNeighborhoodName()
     * @uses RCiscoCatalyst600024PortFXSGateway::setLoadInformation()
     * @uses RCiscoCatalyst600024PortFXSGateway::setVendorConfig()
     * @uses RCiscoCatalyst600024PortFXSGateway::setVersionStamp()
     * @uses RCiscoCatalyst600024PortFXSGateway::setTraceFlag()
     * @uses RCiscoCatalyst600024PortFXSGateway::setMlppDomainId()
     * @uses RCiscoCatalyst600024PortFXSGateway::setUseTrustedRelayPoint()
     * @uses RCiscoCatalyst600024PortFXSGateway::setCgpnTransformationCssName()
     * @uses RCiscoCatalyst600024PortFXSGateway::setUseDevicePoolCgpnTransformCss()
     * @uses RCiscoCatalyst600024PortFXSGateway::setGeoLocationName()
     * @uses RCiscoCatalyst600024PortFXSGateway::setPorts()
     * @uses RCiscoCatalyst600024PortFXSGateway::setPortSelectionOrder()
     * @uses RCiscoCatalyst600024PortFXSGateway::setTransmitUtf8()
     * @uses RCiscoCatalyst600024PortFXSGateway::setGeoLocationFilterName()
     * @uses RCiscoCatalyst600024PortFXSGateway::setUuid()
     * @param string $name
     * @param string $description
     * @param string $product
     * @param string $model
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @param \CUCM\StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocale
     * @param \CUCM\StructType\XFkType $locationName
     * @param \CUCM\StructType\XFkType $mediaResourceListName
     * @param \CUCM\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \CUCM\StructType\XFkType $aarNeighborhoodName
     * @param \CUCM\StructType\XLoadInformation $loadInformation
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @param string $versionStamp
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $useTrustedRelayPoint
     * @param \CUCM\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \CUCM\StructType\XFkType $geoLocationName
     * @param \CUCM\StructType\Ports $ports
     * @param string $portSelectionOrder
     * @param string $transmitUtf8
     * @param \CUCM\StructType\XFkType $geoLocationFilterName
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $product = null, $model = null, $class = null, $protocol = null, $protocolSide = null, \CUCM\StructType\XFkType $callingSearchSpaceName = null, \CUCM\StructType\XFkType $devicePoolName = null, \CUCM\StructType\XFkType $commonDeviceConfigName = null, $networkLocale = null, \CUCM\StructType\XFkType $locationName = null, \CUCM\StructType\XFkType $mediaResourceListName = null, \CUCM\StructType\XFkType $automatedAlternateRoutingCssName = null, \CUCM\StructType\XFkType $aarNeighborhoodName = null, \CUCM\StructType\XLoadInformation $loadInformation = null, \CUCM\StructType\XVendorConfig $vendorConfig = null, $versionStamp = null, $traceFlag = null, $mlppDomainId = null, $useTrustedRelayPoint = null, \CUCM\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = null, \CUCM\StructType\XFkType $geoLocationName = null, \CUCM\StructType\Ports $ports = null, $portSelectionOrder = null, $transmitUtf8 = null, \CUCM\StructType\XFkType $geoLocationFilterName = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setProduct($product)
            ->setModel($model)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocale($networkLocale)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setVersionStamp($versionStamp)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setPorts($ports)
            ->setPortSelectionOrder($portSelectionOrder)
            ->setTransmitUtf8($transmitUtf8)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \CUCM\EnumType\XProduct::valueIsValid()
     * @uses \CUCM\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \CUCM\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @uses \CUCM\EnumType\XModel::valueIsValid()
     * @uses \CUCM\EnumType\XModel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $model
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setModel($model = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XModel::valueIsValid($model)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $model, implode(', ', \CUCM\EnumType\XModel::getValidValues())), __LINE__);
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Get class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \CUCM\EnumType\XClass::valueIsValid()
     * @uses \CUCM\EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \CUCM\EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \CUCM\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \CUCM\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', \CUCM\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string|null
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \CUCM\EnumType\XProtocolSide::valueIsValid()
     * @uses \CUCM\EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setProtocolSide($protocolSide = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', \CUCM\EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setCallingSearchSpaceName(\CUCM\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setDevicePoolName(\CUCM\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param \CUCM\StructType\XFkType $commonDeviceConfigName
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setCommonDeviceConfigName(\CUCM\StructType\XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get networkLocale value
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return $this->networkLocale;
    }
    /**
     * Set networkLocale value
     * @uses \CUCM\EnumType\XCountry::valueIsValid()
     * @uses \CUCM\EnumType\XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocale, implode(', ', \CUCM\EnumType\XCountry::getValidValues())), __LINE__);
        }
        $this->networkLocale = $networkLocale;
        return $this;
    }
    /**
     * Get locationName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \CUCM\StructType\XFkType $locationName
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setLocationName(\CUCM\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param \CUCM\StructType\XFkType $mediaResourceListName
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setMediaResourceListName(\CUCM\StructType\XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param \CUCM\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setAutomatedAlternateRoutingCssName(\CUCM\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param \CUCM\StructType\XFkType $aarNeighborhoodName
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setAarNeighborhoodName(\CUCM\StructType\XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get loadInformation value
     * @return \CUCM\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return $this->loadInformation;
    }
    /**
     * Set loadInformation value
     * @param \CUCM\StructType\XLoadInformation $loadInformation
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setLoadInformation(\CUCM\StructType\XLoadInformation $loadInformation = null)
    {
        $this->loadInformation = $loadInformation;
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \CUCM\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setVendorConfig(\CUCM\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get versionStamp value
     * @return string|null
     */
    public function getVersionStamp()
    {
        return $this->versionStamp;
    }
    /**
     * Set versionStamp value
     * @param string $versionStamp
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setVersionStamp($versionStamp = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($versionStamp) && strlen($versionStamp) > 128) || (is_array($versionStamp) && count($versionStamp) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($versionStamp) ? strlen($versionStamp) : count($versionStamp)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($versionStamp) && !is_string($versionStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versionStamp)), __LINE__);
        }
        $this->versionStamp = $versionStamp;
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($traceFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceFlag)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return $this->mlppDomainId;
    }
    /**
     * Set mlppDomainId value
     * @param string $mlppDomainId
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        $this->mlppDomainId = $mlppDomainId;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param \CUCM\StructType\XFkType $cgpnTransformationCssName
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setCgpnTransformationCssName(\CUCM\StructType\XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param \CUCM\StructType\XFkType $geoLocationName
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setGeoLocationName(\CUCM\StructType\XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get ports value
     * @return \CUCM\StructType\Ports|null
     */
    public function getPorts()
    {
        return $this->ports;
    }
    /**
     * Set ports value
     * @param \CUCM\StructType\Ports $ports
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setPorts(\CUCM\StructType\Ports $ports = null)
    {
        $this->ports = $ports;
        return $this;
    }
    /**
     * Get portSelectionOrder value
     * @return string|null
     */
    public function getPortSelectionOrder()
    {
        return $this->portSelectionOrder;
    }
    /**
     * Set portSelectionOrder value
     * @uses \CUCM\EnumType\XTrunkSelectionOrder::valueIsValid()
     * @uses \CUCM\EnumType\XTrunkSelectionOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $portSelectionOrder
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setPortSelectionOrder($portSelectionOrder = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTrunkSelectionOrder::valueIsValid($portSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $portSelectionOrder, implode(', ', \CUCM\EnumType\XTrunkSelectionOrder::getValidValues())), __LINE__);
        }
        $this->portSelectionOrder = $portSelectionOrder;
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setTransmitUtf8($transmitUtf8 = null)
    {
        // validation for constraint: pattern
        if (is_scalar($transmitUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($transmitUtf8, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transmitUtf8) && !is_string($transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmitUtf8)), __LINE__);
        }
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return $this->geoLocationFilterName;
    }
    /**
     * Set geoLocationFilterName value
     * @param \CUCM\StructType\XFkType $geoLocationFilterName
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setGeoLocationFilterName(\CUCM\StructType\XFkType $geoLocationFilterName = null)
    {
        $this->geoLocationFilterName = $geoLocationFilterName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RCiscoCatalyst600024PortFXSGateway
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
