<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RBusyLampField StructType
 * @subpackage Structs
 */
class RBusyLampField extends AbstractStructBase
{
    /**
     * The blfDest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $blfDest;
    /**
     * The blfDirn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $blfDirn;
    /**
     * The routePartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $routePartition;
    /**
     * The label
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The asciiLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $asciiLabel;
    /**
     * The associatedBlfSdFeatures
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AssociatedBlfSdFeatures
     */
    public $associatedBlfSdFeatures;
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $index;
    /**
     * Constructor method for RBusyLampField
     * @uses RBusyLampField::setBlfDest()
     * @uses RBusyLampField::setBlfDirn()
     * @uses RBusyLampField::setRoutePartition()
     * @uses RBusyLampField::setLabel()
     * @uses RBusyLampField::setAsciiLabel()
     * @uses RBusyLampField::setAssociatedBlfSdFeatures()
     * @uses RBusyLampField::setIndex()
     * @param string $blfDest
     * @param string $blfDirn
     * @param string $routePartition
     * @param string $label
     * @param string $asciiLabel
     * @param \CUCM\StructType\AssociatedBlfSdFeatures $associatedBlfSdFeatures
     * @param string $index
     */
    public function __construct($blfDest = null, $blfDirn = null, $routePartition = null, $label = null, $asciiLabel = null, \CUCM\StructType\AssociatedBlfSdFeatures $associatedBlfSdFeatures = null, $index = null)
    {
        $this
            ->setBlfDest($blfDest)
            ->setBlfDirn($blfDirn)
            ->setRoutePartition($routePartition)
            ->setLabel($label)
            ->setAsciiLabel($asciiLabel)
            ->setAssociatedBlfSdFeatures($associatedBlfSdFeatures)
            ->setIndex($index);
    }
    /**
     * Get blfDest value
     * @return string|null
     */
    public function getBlfDest()
    {
        return $this->blfDest;
    }
    /**
     * Set blfDest value
     * @param string $blfDest
     * @return \CUCM\StructType\RBusyLampField
     */
    public function setBlfDest($blfDest = null)
    {
        // validation for constraint: string
        if (!is_null($blfDest) && !is_string($blfDest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blfDest)), __LINE__);
        }
        $this->blfDest = $blfDest;
        return $this;
    }
    /**
     * Get blfDirn value
     * @return string|null
     */
    public function getBlfDirn()
    {
        return $this->blfDirn;
    }
    /**
     * Set blfDirn value
     * @param string $blfDirn
     * @return \CUCM\StructType\RBusyLampField
     */
    public function setBlfDirn($blfDirn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($blfDirn) && strlen($blfDirn) > 255) || (is_array($blfDirn) && count($blfDirn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($blfDirn) ? strlen($blfDirn) : count($blfDirn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($blfDirn) && !is_string($blfDirn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blfDirn)), __LINE__);
        }
        $this->blfDirn = $blfDirn;
        return $this;
    }
    /**
     * Get routePartition value
     * @return string|null
     */
    public function getRoutePartition()
    {
        return $this->routePartition;
    }
    /**
     * Set routePartition value
     * @param string $routePartition
     * @return \CUCM\StructType\RBusyLampField
     */
    public function setRoutePartition($routePartition = null)
    {
        // validation for constraint: string
        if (!is_null($routePartition) && !is_string($routePartition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routePartition)), __LINE__);
        }
        $this->routePartition = $routePartition;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \CUCM\StructType\RBusyLampField
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get asciiLabel value
     * @return string|null
     */
    public function getAsciiLabel()
    {
        return $this->asciiLabel;
    }
    /**
     * Set asciiLabel value
     * @param string $asciiLabel
     * @return \CUCM\StructType\RBusyLampField
     */
    public function setAsciiLabel($asciiLabel = null)
    {
        // validation for constraint: string
        if (!is_null($asciiLabel) && !is_string($asciiLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($asciiLabel)), __LINE__);
        }
        $this->asciiLabel = $asciiLabel;
        return $this;
    }
    /**
     * Get associatedBlfSdFeatures value
     * @return \CUCM\StructType\AssociatedBlfSdFeatures|null
     */
    public function getAssociatedBlfSdFeatures()
    {
        return $this->associatedBlfSdFeatures;
    }
    /**
     * Set associatedBlfSdFeatures value
     * @param \CUCM\StructType\AssociatedBlfSdFeatures $associatedBlfSdFeatures
     * @return \CUCM\StructType\RBusyLampField
     */
    public function setAssociatedBlfSdFeatures(\CUCM\StructType\AssociatedBlfSdFeatures $associatedBlfSdFeatures = null)
    {
        $this->associatedBlfSdFeatures = $associatedBlfSdFeatures;
        return $this;
    }
    /**
     * Get index value
     * @return string|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return \CUCM\StructType\RBusyLampField
     */
    public function setIndex($index = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RBusyLampField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
