<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAppUser StructType
 * @subpackage Structs
 */
class RAppUser extends AbstractStructBase
{
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The passwordCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\PasswordCredentials
     */
    public $passwordCredentials;
    /**
     * The digestCredentials
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $digestCredentials;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The acceptPresenceSubscription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptPresenceSubscription;
    /**
     * The acceptOutOfDialogRefer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutOfDialogRefer;
    /**
     * The acceptUnsolicitedNotification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptUnsolicitedNotification;
    /**
     * The allowReplaceHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $allowReplaceHeader;
    /**
     * The isStandard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isStandard;
    /**
     * The associatedDevices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AssociatedDevices
     */
    public $associatedDevices;
    /**
     * The associatedGroups
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AssociatedGroups
     */
    public $associatedGroups;
    /**
     * The associatedCapfProfiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AssociatedCapfProfiles
     */
    public $associatedCapfProfiles;
    /**
     * The ctiControlledDeviceProfiles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\CtiControlledDeviceProfiles
     */
    public $ctiControlledDeviceProfiles;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RAppUser
     * @uses RAppUser::setUserid()
     * @uses RAppUser::setPassword()
     * @uses RAppUser::setPasswordCredentials()
     * @uses RAppUser::setDigestCredentials()
     * @uses RAppUser::setPresenceGroupName()
     * @uses RAppUser::setAcceptPresenceSubscription()
     * @uses RAppUser::setAcceptOutOfDialogRefer()
     * @uses RAppUser::setAcceptUnsolicitedNotification()
     * @uses RAppUser::setAllowReplaceHeader()
     * @uses RAppUser::setIsStandard()
     * @uses RAppUser::setAssociatedDevices()
     * @uses RAppUser::setAssociatedGroups()
     * @uses RAppUser::setAssociatedCapfProfiles()
     * @uses RAppUser::setCtiControlledDeviceProfiles()
     * @uses RAppUser::setUuid()
     * @param string $userid
     * @param string $password
     * @param \CUCM\StructType\PasswordCredentials $passwordCredentials
     * @param string $digestCredentials
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @param string $acceptPresenceSubscription
     * @param string $acceptOutOfDialogRefer
     * @param string $acceptUnsolicitedNotification
     * @param string $allowReplaceHeader
     * @param string $isStandard
     * @param \CUCM\StructType\AssociatedDevices $associatedDevices
     * @param \CUCM\StructType\AssociatedGroups $associatedGroups
     * @param \CUCM\StructType\AssociatedCapfProfiles $associatedCapfProfiles
     * @param \CUCM\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @param string $uuid
     */
    public function __construct($userid = null, $password = null, \CUCM\StructType\PasswordCredentials $passwordCredentials = null, $digestCredentials = null, \CUCM\StructType\XFkType $presenceGroupName = null, $acceptPresenceSubscription = null, $acceptOutOfDialogRefer = null, $acceptUnsolicitedNotification = null, $allowReplaceHeader = null, $isStandard = null, \CUCM\StructType\AssociatedDevices $associatedDevices = null, \CUCM\StructType\AssociatedGroups $associatedGroups = null, \CUCM\StructType\AssociatedCapfProfiles $associatedCapfProfiles = null, \CUCM\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null, $uuid = null)
    {
        $this
            ->setUserid($userid)
            ->setPassword($password)
            ->setPasswordCredentials($passwordCredentials)
            ->setDigestCredentials($digestCredentials)
            ->setPresenceGroupName($presenceGroupName)
            ->setAcceptPresenceSubscription($acceptPresenceSubscription)
            ->setAcceptOutOfDialogRefer($acceptOutOfDialogRefer)
            ->setAcceptUnsolicitedNotification($acceptUnsolicitedNotification)
            ->setAllowReplaceHeader($allowReplaceHeader)
            ->setIsStandard($isStandard)
            ->setAssociatedDevices($associatedDevices)
            ->setAssociatedGroups($associatedGroups)
            ->setAssociatedCapfProfiles($associatedCapfProfiles)
            ->setCtiControlledDeviceProfiles($ctiControlledDeviceProfiles)
            ->setUuid($uuid);
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \CUCM\StructType\RAppUser
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \CUCM\StructType\RAppUser
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get passwordCredentials value
     * @return \CUCM\StructType\PasswordCredentials|null
     */
    public function getPasswordCredentials()
    {
        return $this->passwordCredentials;
    }
    /**
     * Set passwordCredentials value
     * @param \CUCM\StructType\PasswordCredentials $passwordCredentials
     * @return \CUCM\StructType\RAppUser
     */
    public function setPasswordCredentials(\CUCM\StructType\PasswordCredentials $passwordCredentials = null)
    {
        $this->passwordCredentials = $passwordCredentials;
        return $this;
    }
    /**
     * Get digestCredentials value
     * @return string|null
     */
    public function getDigestCredentials()
    {
        return $this->digestCredentials;
    }
    /**
     * Set digestCredentials value
     * @param string $digestCredentials
     * @return \CUCM\StructType\RAppUser
     */
    public function setDigestCredentials($digestCredentials = null)
    {
        // validation for constraint: string
        if (!is_null($digestCredentials) && !is_string($digestCredentials)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($digestCredentials)), __LINE__);
        }
        $this->digestCredentials = $digestCredentials;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @return \CUCM\StructType\RAppUser
     */
    public function setPresenceGroupName(\CUCM\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get acceptPresenceSubscription value
     * @return string|null
     */
    public function getAcceptPresenceSubscription()
    {
        return $this->acceptPresenceSubscription;
    }
    /**
     * Set acceptPresenceSubscription value
     * @param string $acceptPresenceSubscription
     * @return \CUCM\StructType\RAppUser
     */
    public function setAcceptPresenceSubscription($acceptPresenceSubscription = null)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptPresenceSubscription) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptPresenceSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptPresenceSubscription, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptPresenceSubscription) && !is_string($acceptPresenceSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptPresenceSubscription)), __LINE__);
        }
        $this->acceptPresenceSubscription = $acceptPresenceSubscription;
        return $this;
    }
    /**
     * Get acceptOutOfDialogRefer value
     * @return string|null
     */
    public function getAcceptOutOfDialogRefer()
    {
        return $this->acceptOutOfDialogRefer;
    }
    /**
     * Set acceptOutOfDialogRefer value
     * @param string $acceptOutOfDialogRefer
     * @return \CUCM\StructType\RAppUser
     */
    public function setAcceptOutOfDialogRefer($acceptOutOfDialogRefer = null)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptOutOfDialogRefer) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptOutOfDialogRefer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptOutOfDialogRefer, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptOutOfDialogRefer) && !is_string($acceptOutOfDialogRefer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptOutOfDialogRefer)), __LINE__);
        }
        $this->acceptOutOfDialogRefer = $acceptOutOfDialogRefer;
        return $this;
    }
    /**
     * Get acceptUnsolicitedNotification value
     * @return string|null
     */
    public function getAcceptUnsolicitedNotification()
    {
        return $this->acceptUnsolicitedNotification;
    }
    /**
     * Set acceptUnsolicitedNotification value
     * @param string $acceptUnsolicitedNotification
     * @return \CUCM\StructType\RAppUser
     */
    public function setAcceptUnsolicitedNotification($acceptUnsolicitedNotification = null)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptUnsolicitedNotification) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptUnsolicitedNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptUnsolicitedNotification, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptUnsolicitedNotification) && !is_string($acceptUnsolicitedNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptUnsolicitedNotification)), __LINE__);
        }
        $this->acceptUnsolicitedNotification = $acceptUnsolicitedNotification;
        return $this;
    }
    /**
     * Get allowReplaceHeader value
     * @return string|null
     */
    public function getAllowReplaceHeader()
    {
        return $this->allowReplaceHeader;
    }
    /**
     * Set allowReplaceHeader value
     * @param string $allowReplaceHeader
     * @return \CUCM\StructType\RAppUser
     */
    public function setAllowReplaceHeader($allowReplaceHeader = null)
    {
        // validation for constraint: pattern
        if (is_scalar($allowReplaceHeader) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $allowReplaceHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($allowReplaceHeader, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($allowReplaceHeader) && !is_string($allowReplaceHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($allowReplaceHeader)), __LINE__);
        }
        $this->allowReplaceHeader = $allowReplaceHeader;
        return $this;
    }
    /**
     * Get isStandard value
     * @return string|null
     */
    public function getIsStandard()
    {
        return $this->isStandard;
    }
    /**
     * Set isStandard value
     * @param string $isStandard
     * @return \CUCM\StructType\RAppUser
     */
    public function setIsStandard($isStandard = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isStandard) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isStandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isStandard, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isStandard) && !is_string($isStandard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isStandard)), __LINE__);
        }
        $this->isStandard = $isStandard;
        return $this;
    }
    /**
     * Get associatedDevices value
     * @return \CUCM\StructType\AssociatedDevices|null
     */
    public function getAssociatedDevices()
    {
        return $this->associatedDevices;
    }
    /**
     * Set associatedDevices value
     * @param \CUCM\StructType\AssociatedDevices $associatedDevices
     * @return \CUCM\StructType\RAppUser
     */
    public function setAssociatedDevices(\CUCM\StructType\AssociatedDevices $associatedDevices = null)
    {
        $this->associatedDevices = $associatedDevices;
        return $this;
    }
    /**
     * Get associatedGroups value
     * @return \CUCM\StructType\AssociatedGroups|null
     */
    public function getAssociatedGroups()
    {
        return $this->associatedGroups;
    }
    /**
     * Set associatedGroups value
     * @param \CUCM\StructType\AssociatedGroups $associatedGroups
     * @return \CUCM\StructType\RAppUser
     */
    public function setAssociatedGroups(\CUCM\StructType\AssociatedGroups $associatedGroups = null)
    {
        $this->associatedGroups = $associatedGroups;
        return $this;
    }
    /**
     * Get associatedCapfProfiles value
     * @return \CUCM\StructType\AssociatedCapfProfiles|null
     */
    public function getAssociatedCapfProfiles()
    {
        return $this->associatedCapfProfiles;
    }
    /**
     * Set associatedCapfProfiles value
     * @param \CUCM\StructType\AssociatedCapfProfiles $associatedCapfProfiles
     * @return \CUCM\StructType\RAppUser
     */
    public function setAssociatedCapfProfiles(\CUCM\StructType\AssociatedCapfProfiles $associatedCapfProfiles = null)
    {
        $this->associatedCapfProfiles = $associatedCapfProfiles;
        return $this;
    }
    /**
     * Get ctiControlledDeviceProfiles value
     * @return \CUCM\StructType\CtiControlledDeviceProfiles|null
     */
    public function getCtiControlledDeviceProfiles()
    {
        return $this->ctiControlledDeviceProfiles;
    }
    /**
     * Set ctiControlledDeviceProfiles value
     * @param \CUCM\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles
     * @return \CUCM\StructType\RAppUser
     */
    public function setCtiControlledDeviceProfiles(\CUCM\StructType\CtiControlledDeviceProfiles $ctiControlledDeviceProfiles = null)
    {
        $this->ctiControlledDeviceProfiles = $ctiControlledDeviceProfiles;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RAppUser
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RAppUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
