<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RAppServerInfo StructType
 * @subpackage Structs
 */
class RAppServerInfo extends AbstractStructBase
{
    /**
     * The appServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XFkType
     */
    public $appServerName;
    /**
     * The appServerContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $appServerContent;
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XContent
     */
    public $content;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RAppServerInfo
     * @uses RAppServerInfo::setAppServerName()
     * @uses RAppServerInfo::setAppServerContent()
     * @uses RAppServerInfo::setContent()
     * @uses RAppServerInfo::setUuid()
     * @param \CUCM\StructType\XFkType $appServerName
     * @param string $appServerContent
     * @param \CUCM\StructType\XContent $content
     * @param string $uuid
     */
    public function __construct(\CUCM\StructType\XFkType $appServerName = null, $appServerContent = null, \CUCM\StructType\XContent $content = null, $uuid = null)
    {
        $this
            ->setAppServerName($appServerName)
            ->setAppServerContent($appServerContent)
            ->setContent($content)
            ->setUuid($uuid);
    }
    /**
     * Get appServerName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAppServerName()
    {
        return $this->appServerName;
    }
    /**
     * Set appServerName value
     * @param \CUCM\StructType\XFkType $appServerName
     * @return \CUCM\StructType\RAppServerInfo
     */
    public function setAppServerName(\CUCM\StructType\XFkType $appServerName = null)
    {
        $this->appServerName = $appServerName;
        return $this;
    }
    /**
     * Get appServerContent value
     * @return string|null
     */
    public function getAppServerContent()
    {
        return $this->appServerContent;
    }
    /**
     * Set appServerContent value
     * @uses \CUCM\EnumType\XAppServerContent::valueIsValid()
     * @uses \CUCM\EnumType\XAppServerContent::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appServerContent
     * @return \CUCM\StructType\RAppServerInfo
     */
    public function setAppServerContent($appServerContent = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XAppServerContent::valueIsValid($appServerContent)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $appServerContent, implode(', ', \CUCM\EnumType\XAppServerContent::getValidValues())), __LINE__);
        }
        $this->appServerContent = $appServerContent;
        return $this;
    }
    /**
     * Get content value
     * @return \CUCM\StructType\XContent|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param \CUCM\StructType\XContent $content
     * @return \CUCM\StructType\RAppServerInfo
     */
    public function setContent(\CUCM\StructType\XContent $content = null)
    {
        $this->content = $content;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\RAppServerInfo
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\RAppServerInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
