<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mgcpPorts StructType
 * @subpackage Structs
 */
class MgcpPorts extends AbstractStructBase
{
    /**
     * The listen
     * Meta informations extracted from the WSDL
     * - default: 2427
     * - documentation: UDP port for MGCP communication. | UDP port for MGCP communication. | UDP port for MGCP communication.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $listen;
    /**
     * The keepAlive
     * Meta informations extracted from the WSDL
     * - default: 2428
     * - documentation: TCP port for backhaul for Q.931 messages. | TCP port for backhaul for Q.931 messages. | TCP port for backhaul for Q.931 messages.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $keepAlive;
    /**
     * Constructor method for mgcpPorts
     * @uses MgcpPorts::setListen()
     * @uses MgcpPorts::setKeepAlive()
     * @param string $listen
     * @param string $keepAlive
     */
    public function __construct($listen = '2427', $keepAlive = '2428')
    {
        $this
            ->setListen($listen)
            ->setKeepAlive($keepAlive);
    }
    /**
     * Get listen value
     * @return string|null
     */
    public function getListen()
    {
        return $this->listen;
    }
    /**
     * Set listen value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $listen
     * @return \CUCM\StructType\MgcpPorts
     */
    public function setListen($listen = '2427')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($listen)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $listen, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->listen = $listen;
        return $this;
    }
    /**
     * Get keepAlive value
     * @return string|null
     */
    public function getKeepAlive()
    {
        return $this->keepAlive;
    }
    /**
     * Set keepAlive value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keepAlive
     * @return \CUCM\StructType\MgcpPorts
     */
    public function setKeepAlive($keepAlive = '2428')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($keepAlive)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keepAlive, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->keepAlive = $keepAlive;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\MgcpPorts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
