<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LUnitsToGateway StructType
 * @subpackage Structs
 */
class LUnitsToGateway extends AbstractStructBase
{
    /**
     * The domainName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $domainName;
    /**
     * The gatewayUuid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $gatewayUuid;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LUnitsToGateway
     * @uses LUnitsToGateway::setDomainName()
     * @uses LUnitsToGateway::setGatewayUuid()
     * @uses LUnitsToGateway::setUuid()
     * @param string $domainName
     * @param string $gatewayUuid
     * @param string $uuid
     */
    public function __construct($domainName = null, $gatewayUuid = null, $uuid = null)
    {
        $this
            ->setDomainName($domainName)
            ->setGatewayUuid($gatewayUuid)
            ->setUuid($uuid);
    }
    /**
     * Get domainName value
     * @return string|null
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return \CUCM\StructType\LUnitsToGateway
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get gatewayUuid value
     * @return string|null
     */
    public function getGatewayUuid()
    {
        return $this->gatewayUuid;
    }
    /**
     * Set gatewayUuid value
     * @param string $gatewayUuid
     * @return \CUCM\StructType\LUnitsToGateway
     */
    public function setGatewayUuid($gatewayUuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gatewayUuid) && !preg_match('/\\{........-....-....-....-............\\}/', $gatewayUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($gatewayUuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gatewayUuid) && !is_string($gatewayUuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gatewayUuid)), __LINE__);
        }
        $this->gatewayUuid = $gatewayUuid;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\LUnitsToGateway
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\LUnitsToGateway
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
